/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase.netwise;

import com.documentum.fc.client.DfClient;
import com.documentum.fc.client.DfDeadlockException;
import com.documentum.fc.client.DfNameNotFoundException;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseMessageManager;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseRpcClient;
import com.documentum.fc.client.impl.connection.docbase.UnknownServerResponseException;
import com.documentum.fc.client.impl.connection.docbase.UnknownSessionStartException;
import com.documentum.fc.client.impl.connection.netwise.AbstractNetwiseRpcClient;
import com.documentum.fc.client.impl.connection.netwise.ByteArrayBuilder;
import com.documentum.fc.client.impl.connection.netwise.NetwiseProtocol;
import com.documentum.fc.client.impl.connection.netwise.ProtocolException;
import com.documentum.fc.client.impl.connection.netwise.StringBuilderManager;
import com.documentum.fc.client.impl.connection.netwise.StringBuilderSerializer;
import com.documentum.fc.client.impl.docbase.DocbaseExceptionMapper;
import com.documentum.fc.client.impl.typeddata.DynamicallyTypedData;
import com.documentum.fc.client.impl.typeddata.EmptyTypedDataIterator;
import com.documentum.fc.client.impl.typeddata.IBatchedTypedDataIterator;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.ITypedDataIterator;
import com.documentum.fc.client.impl.typeddata.TypedData;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfTime;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.impl.util.holders.BooleanHolder;
import com.documentum.fc.impl.util.holders.IntHolder;
import com.documentum.fc.impl.util.holders.ObjectHolder;
import com.documentum.fc.tracing.ITraceString;
import com.documentum.fc.tracing.IUserIdentifyingObject;
import com.documentum.fc.tracing.IUserTracingInfo;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NetwiseDocbaseRpcClient
extends AbstractNetwiseRpcClient
implements IDocbaseRpcClient,
IUserIdentifyingObject {
    private static final int NETWISE_VERSION = 3;
    private static final int NETWISE_RELEASE = 5;
    private static final int NETWISE_INUMBER = 769;
    private static final int RPC_GET_BLOCK = 1;
    private static final int RPC_GET_BLOCK1 = 2;
    private static final int RPC_GET_BLOCK2 = 3;
    private static final int RPC_GET_BLOCK3 = 4;
    private static final int RPC_GET_BLOCK4 = 5;
    private static final int RPC_GET_BLOCK5 = 6;
    private static final int RPC_DO_PUSH = 27;
    private static final int RPC_NEW_SESSION_BY_ADDR = 51;
    private static final int RPC_CLOSE_SESSION = 52;
    private static final int RPC_FETCH_TYPE = 53;
    private static final int RPC_APPLY = 54;
    private static final int RPC_MULTI_NEXT = 56;
    private static final int RPC_CLOSE_COLLECTION = 57;
    private static final int RPC_APPLY_FOR_LONG = 58;
    private static final int RPC_APPLY_FOR_BOOL = 59;
    private static final int RPC_APPLY_FOR_ID = 60;
    private static final int RPC_APPLY_FOR_STRING = 61;
    private static final int RPC_APPLY_FOR_OBJECT = 62;
    private static final int RPC_APPLY_FOR_TIME = 63;
    private static final int RPC_APPLY_FOR_DOUBLE = 64;
    private static final int RPC_GET_NEXT_PIECE = 65;
    private static final int OOB_MASK_ERRORS_EXIST = 2;
    private static final int OOB_MASK_MORE_RESULT = 16;
    private static final int OOB_MASK_DEADLOCK = 32;
    private String m_sessionId = "0000000000000000";
    private int m_generationId = 0;
    private boolean m_importingMessages = false;
    private IDocbaseMessageManager m_messageManager = null;
    private Map<String, Integer> m_methodMap = NULL_METHOD_MAP;
    private IUserIdentifyingObject m_userIdentifyingObject = null;
    private static final Map<String, Integer> NULL_METHOD_MAP;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;

    NetwiseDocbaseRpcClient(Socket socket) {
        super(socket);
    }

    @Override
    public synchronized void quiesce() {
        super.quiesce();
        this.invalidateDataIterators();
    }

    private synchronized void invalidateDataIterators() {
        ++this.m_generationId;
    }

    @Override
    public void setMessageManager(IDocbaseMessageManager messageManager) {
        this.m_messageManager = messageManager;
    }

    private IDocbaseMessageManager getMessageManager() {
        if (this.m_messageManager == null) {
            throw new IllegalStateException("Message manager is not initialized");
        }
        return this.m_messageManager;
    }

    @Override
    public synchronized void setMethodMap(Map<String, Integer> methodMap) {
        this.m_methodMap = methodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized String newSessionByAddr(int n, String string, int[] nArray, ObjectHolder objectHolder, String string2) throws DfException {
        int n2 = n;
        String string3 = string;
        int[] nArray2 = nArray;
        ObjectHolder objectHolder2 = objectHolder;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            String string5;
            String string6;
            void serverVersionHolder;
            boolean valid;
            String sessionId;
            int[] serverVersion;
            String result;
            void clientVersion;
            void username;
            void docbaseId;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n2), string3, nArray2, objectHolder2, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                void sessionIdHint;
                int sequenceNumber = this.getNextSequenceNumber();
                NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 51);
                NetwiseProtocol.serializeInteger(buffer, (int)docbaseId);
                NetwiseProtocol.serializeString(buffer, (String)username);
                NetwiseProtocol.serializeString(buffer, DfClient.getDFCVersion());
                NetwiseProtocol.serializeString(buffer, null);
                NetwiseProtocol.serializeIntegerArray(buffer, (int[])clientVersion);
                NetwiseProtocol.serializeString(buffer, (String)sessionIdHint);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeString(buffer);
                serverVersion = NetwiseProtocol.deserializeIntegerArray(buffer);
                sessionId = NetwiseProtocol.deserializeString(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            boolean bl = valid = !sessionId.equals("0000000000000000");
            if (result.length() > 0) {
                throw DocbaseExceptionMapper.newException(result, new Object[0]);
            }
            if (!valid) {
                throw new UnknownSessionStartException((int)docbaseId, (String)username, (int[])clientVersion);
            }
            if (serverVersionHolder != null) {
                serverVersionHolder.value = serverVersion;
            }
            this.m_sessionId = sessionId;
            String string7 = string6 = (string5 = sessionId);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n2), string3, nArray2, objectHolder2, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(string6, joinPoint);
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n2), string3, nArray2, objectHolder2, string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static void serializeRequestHeader(ByteBuffer buffer, int sequenceNumber, int rpcId) {
        NetwiseProtocol.serializeRequestHeader(buffer, sequenceNumber, rpcId, 3, 5, 769);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int serializeApplyRequest(ByteBuffer buffer, int rpcId, String methodName, IDfId objectId, ITypedData arguments) throws DfException {
        StringBuilder stringBuilder = StringBuilderManager.getInstance().getStringBuilder();
        try {
            this.serializeObjectToStringBuilder(stringBuilder, arguments);
            StringBuilderSerializer stringBuilderSerializer = this.getStringBuilderSerializer();
            try {
                stringBuilderSerializer.initialize(stringBuilder);
                int seq = this.serializeApplyRequest(buffer, rpcId, methodName, objectId, stringBuilderSerializer);
                if (stringBuilderSerializer.isMore()) {
                    stringBuilderSerializer.initialize(stringBuilder);
                    seq = this.serializeChunkedRequest(buffer, rpcId, methodName, objectId, stringBuilder, arguments);
                }
                int n = seq;
                stringBuilderSerializer.release();
                return n;
            }
            catch (Throwable throwable) {
                stringBuilderSerializer.release();
                throw throwable;
            }
        }
        finally {
            StringBuilderManager.getInstance().releaseStringBuilder(stringBuilder);
        }
    }

    private int serializeApplyRequest(ByteBuffer buffer, int rpcId, String methodName, IDfId objectId, StringBuilderSerializer stringBuilderSerializer) throws DfException {
        int sequenceNumber = this.getNextSequenceNumber();
        NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, rpcId);
        NetwiseProtocol.serializeString(buffer, this.m_sessionId);
        NetwiseProtocol.serializeInteger(buffer, this.mapMethodNameToNumber(methodName));
        NetwiseProtocol.serializeId(buffer, objectId);
        stringBuilderSerializer.serialize(buffer);
        return sequenceNumber;
    }

    private void setChunking(IDfId objectId, boolean setOn) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setId("_PUSHED_ID_", objectId == null ? DfId.DF_NULLID : objectId);
        arguments.setBoolean("_PUSH_STATUS_", setOn);
        ITypedDataIterator c = this.applyForCollection("SET_PUSH_OBJECT_STATUS", DfId.DF_NULLID, arguments, 0, true, true);
    }

    private void sendTheChunks(ByteBuffer buffer, String methodName, IDfId objectId, StringBuilder stringBuilder, ITypedData arguments) throws DfException {
        StringBuilderSerializer stringBuilderSerializer = this.getStringBuilderSerializer();
        stringBuilderSerializer.initialize(stringBuilder);
        while (stringBuilderSerializer.isMore()) {
            this.sendAChunk(buffer, methodName, objectId, stringBuilderSerializer, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAChunk(ByteBuffer buffer, String methodName, IDfId objectId, StringBuilderSerializer stringBuilderSerializer, ITypedData arguments) throws DfException {
        int outOfBandData;
        boolean valid;
        try {
            this.initializeByteBuffer(buffer);
            int sequenceNumber = this.serializeApplyRequest(buffer, 58, methodName, objectId, stringBuilderSerializer);
            this.sendMessage(buffer);
            this.receiveMessage(buffer);
            NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
            int result = NetwiseProtocol.deserializeInteger(buffer);
            valid = NetwiseProtocol.deserializeBoolean(buffer);
            outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
        }
        finally {
            this.releaseByteBuffer(buffer);
        }
        this.checkForDeadlock(outOfBandData);
        this.checkForMessages(outOfBandData, true, true);
        if (!valid) {
            throw new UnknownServerResponseException(methodName, objectId, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int serializeTheDoIt(ByteBuffer buffer, int rpcId, String methodName, IDfId objectId) throws DfException {
        StringBuilder sb = StringBuilderManager.getInstance().getStringBuilder();
        try {
            int sequenceNumber;
            sb.append("_USE_SESSION_CHUNKED_OBJ_STRING_");
            StringBuilderSerializer stringBuilderSerializer = this.getStringBuilderSerializer();
            stringBuilderSerializer.initialize(sb);
            this.initializeByteBuffer(buffer);
            int n = sequenceNumber = this.serializeApplyRequest(buffer, rpcId, methodName, objectId, stringBuilderSerializer);
            return n;
        }
        finally {
            StringBuilderManager.getInstance().releaseStringBuilder(sb);
        }
    }

    private int serializeChunkedRequest(ByteBuffer buffer, int rpcId, String methodName, IDfId objectId, StringBuilder stringBuilder, ITypedData arguments) throws DfException {
        this.setChunking(objectId, true);
        this.sendTheChunks(buffer, methodName, objectId, stringBuilder, arguments);
        this.setChunking(objectId, false);
        return this.serializeTheDoIt(buffer, rpcId, methodName, objectId);
    }

    private int mapMethodNameToNumber(String methodName) {
        Integer mapEntry = this.m_methodMap.get(methodName);
        if (mapEntry != null) {
            return mapEntry;
        }
        if (methodName == null) {
            return 0;
        }
        if (methodName.equals("GET_ERRORS")) {
            return 558;
        }
        if (!this.isOpen()) {
            return -1;
        }
        throw new UnsupportedOperationException("Unknown server method name: " + methodName);
    }

    private void checkForDeadlock(int outOfBandData) throws DfDeadlockException {
        if (NetwiseDocbaseRpcClient.isDeadlockIndicated(outOfBandData)) {
            DfLogger.warn((Object)this, "Deadlock reported by server, connection={0}", new String[]{this.m_sessionId}, null);
            throw new DfDeadlockException();
        }
    }

    private static boolean isDeadlockIndicated(int outOfBandData) {
        return (outOfBandData & 0x20) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForMessages(int outOfBandData, boolean throwErrors, boolean flushOldMessages) throws DfException {
        if (!this.m_importingMessages) {
            if (flushOldMessages) {
                this.getMessageManager().flushMessages();
            }
            if (NetwiseDocbaseRpcClient.isMessageAvailable(outOfBandData)) {
                try {
                    this.m_importingMessages = true;
                    if (this.getMessageManager().importMessagesFromServer() && throwErrors) {
                        throw this.getMessageManager().getException();
                    }
                }
                finally {
                    this.m_importingMessages = false;
                }
            }
        }
    }

    private static boolean isMessageAvailable(int outOfBandData) {
        return (outOfBandData & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean applyForBool(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            boolean bl5;
            boolean bl6;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            boolean result;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 59, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeBoolean(buffer);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            boolean bl7 = bl6 = (bl5 = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl6);
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(object, joinPoint);
            }
            return bl5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized byte[] applyForByteArray(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            byte[] byArray;
            byte[] byArray2;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            byte[] result;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 61, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeByteArray(buffer, false);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            byte[] byArray3 = byArray2 = (byArray = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(byArray2, joinPoint);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized ITypedDataIterator applyForCollection(String string, IDfId iDfId, ITypedData iTypedData, int n, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        int n2 = n;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            EmptyTypedDataIterator emptyTypedDataIterator;
            EmptyTypedDataIterator emptyTypedDataIterator2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            int collectionId = -1;
            try {
                ITypedDataIterator iteratorResult;
                void flushOldMessages;
                void throwErrors;
                int outOfBandData;
                boolean maybeMore;
                String result;
                void arguments;
                void id;
                void methodName;
                ByteBuffer buffer = this.getByteBuffer();
                try {
                    int sequenceNumber = this.serializeApplyRequest(buffer, 54, (String)methodName, (IDfId)id, (ITypedData)arguments);
                    this.sendMessage(buffer);
                    this.receiveMessage(buffer);
                    NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                    result = NetwiseProtocol.deserializeString(buffer);
                    collectionId = NetwiseProtocol.deserializeInteger(buffer);
                    NetwiseProtocol.deserializeBoolean(buffer);
                    maybeMore = NetwiseProtocol.deserializeBoolean(buffer);
                    outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
                }
                finally {
                    this.releaseByteBuffer(buffer);
                }
                boolean valid = collectionId >= 0;
                this.getObjectProtocol().receiveOutOfBandData(outOfBandData);
                this.checkForDeadlock(outOfBandData);
                this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
                if (!valid) {
                    throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
                }
                if (!StringUtil.isEmptyOrNull(result)) {
                    void batchHint;
                    ILiteType type = (result = result.trim()).indexOf(" ") >= 0 ? this.getObjectProtocol().deserializeType(result) : this.getObjectProtocol().getType(result);
                    iteratorResult = new TypedDataIterator(collectionId, this.m_generationId, type, maybeMore, (int)batchHint);
                } else {
                    iteratorResult = new EmptyTypedDataIterator();
                }
                emptyTypedDataIterator2 = iteratorResult;
            }
            catch (DfException e) {
                if (collectionId != -1) {
                    this.closeCollectionSilently(collectionId);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (collectionId != -1) {
                    this.closeCollectionSilently(collectionId);
                }
                throw e;
            }
            EmptyTypedDataIterator emptyTypedDataIterator3 = emptyTypedDataIterator = emptyTypedDataIterator2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(emptyTypedDataIterator, joinPoint);
            }
            return emptyTypedDataIterator2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void closeCollectionSilently(int collectionId) {
        try {
            this.closeCollection(collectionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized double applyForDouble(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            double d;
            double d2;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            double result;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 64, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeDouble(buffer);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            double d3 = d2 = (d = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.doubleObject((double)d2);
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(object, joinPoint);
            }
            return d;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized IDfId applyForId(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            DfId dfId;
            DfId dfId2;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            DfId result;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 60, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeId(buffer);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            DfId dfId3 = dfId2 = (dfId = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(dfId2, joinPoint);
            }
            return dfId;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized int applyForInt(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            int result;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 58, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeInteger(buffer);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            int n3 = n2 = (n = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized long applyForLong(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            long result;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 58, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeLong(buffer);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            long l3 = l2 = (l = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized ITypedData applyForObject(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            ITypedData iTypedData3;
            ITypedData iTypedData4;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            byte[] resultBytes;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 62, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                resultBytes = NetwiseProtocol.deserializeByteArray(buffer, true);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            if (NetwiseDocbaseRpcClient.isMoreResultIndicated(outOfBandData)) {
                resultBytes = this.getCompleteResultBytes(resultBytes);
            }
            String resultString = NetwiseProtocol.toString(resultBytes);
            ITypedData iTypedData5 = iTypedData4 = methodName == null ? (iTypedData3 = this.getEntryPointObjectProtocol().deserializeObjectWithPreamble(resultString)) : (iTypedData3 = this.getObjectProtocol().deserializeObjectWithPreamble(resultString));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(iTypedData4, joinPoint);
            }
            return iTypedData3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static boolean isMoreResultIndicated(int outOfBandData) {
        return (outOfBandData & 0x10) != 0;
    }

    private byte[] getCompleteResultBytes(byte[] initialSegment) throws DfException {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        if (initialSegment[initialSegment.length - 1] == 0) {
            builder.append(initialSegment, 0, initialSegment.length - 1);
        } else {
            builder.append(initialSegment);
        }
        BooleanHolder moreHolder = new BooleanHolder(true);
        while (moreHolder.value) {
            byte[] segment = this.getNextPiece(moreHolder);
            if (segment[segment.length - 1] == 0) {
                builder.append(segment, 0, segment.length - 1);
                continue;
            }
            builder.append(segment);
        }
        return builder.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private synchronized byte[] getNextPiece(BooleanHolder booleanHolder) throws DfException {
        BooleanHolder booleanHolder2 = booleanHolder;
        JoinPoint joinPoint = null;
        try {
            byte[] byArray;
            byte[] byArray2;
            void moreHolder;
            boolean more;
            byte[] result;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)booleanHolder2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.getNextSequenceNumber();
                NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 65);
                NetwiseProtocol.serializeString(buffer, this.m_sessionId);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeByteArray(buffer, true);
                more = NetwiseProtocol.deserializeBoolean(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            if (moreHolder != null) {
                moreHolder.value = more;
            }
            byte[] byArray3 = byArray2 = (byArray = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)booleanHolder2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(byArray2, joinPoint);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)booleanHolder2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String applyForString(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            void flushOldMessages;
            void throwErrors;
            void arguments;
            void id;
            void methodName;
            String string3;
            String string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            String string5 = string4 = (string3 = this.applyForStringInternal((String)methodName, (IDfId)id, (ITypedData)arguments, (boolean)throwErrors, (boolean)flushOldMessages));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String applyForStringInternal(String methodName, IDfId id, ITypedData arguments, boolean throwErrors, boolean flushOldMessages) throws DfException {
        int outOfBandData;
        boolean valid;
        byte[] resultBytes;
        ByteBuffer buffer = this.getByteBuffer();
        try {
            int sequenceNumber = this.serializeApplyRequest(buffer, 61, methodName, id, arguments);
            this.sendMessage(buffer);
            this.receiveMessage(buffer);
            NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
            resultBytes = NetwiseProtocol.deserializeByteArray(buffer, true);
            valid = NetwiseProtocol.deserializeBoolean(buffer);
            outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
        }
        finally {
            this.releaseByteBuffer(buffer);
        }
        if (!valid && methodName.equals("PROCESS_NEW_SERVER_MESSAGE")) {
            throw new UnknownServerResponseException(methodName, id, arguments);
        }
        this.checkForDeadlock(outOfBandData);
        this.checkForMessages(outOfBandData, throwErrors || !valid, flushOldMessages);
        if (!valid) {
            throw new UnknownServerResponseException(methodName, id, arguments);
        }
        if (NetwiseDocbaseRpcClient.isMoreResultIndicated(outOfBandData)) {
            resultBytes = this.getCompleteResultBytes(resultBytes);
        }
        return NetwiseProtocol.toString(resultBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized IDfTime applyForTime(String string, IDfId iDfId, ITypedData iTypedData, boolean bl, boolean bl2) throws DfException {
        String string2 = string;
        IDfId iDfId2 = iDfId;
        ITypedData iTypedData2 = iTypedData;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            DfTime dfTime;
            DfTime dfTime2;
            void flushOldMessages;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            long result;
            void arguments;
            void id;
            void methodName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                int sequenceNumber = this.serializeApplyRequest(buffer, 63, (String)methodName, (IDfId)id, (ITypedData)arguments);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeLong(buffer);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, throwErrors != false || !valid, (boolean)flushOldMessages);
            if (!valid) {
                throw new UnknownServerResponseException((String)methodName, (IDfId)id, (ITypedData)arguments);
            }
            DfTime dfTime3 = dfTime2 = (dfTime = new DfTime(new Date(result * 1000L)));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(dfTime2, joinPoint);
            }
            return dfTime;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, iDfId2, iTypedData2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized ILiteType fetchType(String string, int n) throws DfException {
        String string2 = string;
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            void cacheVStamp;
            void typeName;
            ILiteType iLiteType;
            ILiteType iLiteType2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ILiteType iLiteType3 = iLiteType2 = this.m_methodMap.containsKey("FETCH_TYPE") ? (iLiteType = this.fetchTypeViaApply((String)typeName, (int)cacheVStamp)) : (iLiteType = this.fetchType((String)typeName));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(iLiteType2, joinPoint);
            }
            return iLiteType;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized String closeSession(IDfId iDfId) throws DfException {
        IDfId iDfId2 = iDfId;
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String result;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)iDfId2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                void closeSessionId;
                int sequenceNumber = this.getNextSequenceNumber();
                NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 52);
                NetwiseProtocol.serializeId(buffer, (IDfId)closeSessionId);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                result = NetwiseProtocol.deserializeString(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            String string3 = string2 = (string = result);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)iDfId2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)iDfId2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILiteType fetchType(String typeName) throws DfException {
        int outOfBandData;
        int count;
        String result;
        ByteBuffer buffer = this.getByteBuffer();
        try {
            int sequenceNumber = this.getNextSequenceNumber();
            NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 53);
            NetwiseProtocol.serializeString(buffer, this.m_sessionId);
            NetwiseProtocol.serializeString(buffer, typeName);
            this.sendMessage(buffer);
            this.receiveMessage(buffer);
            NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
            result = NetwiseProtocol.deserializeString(buffer);
            count = NetwiseProtocol.deserializeInteger(buffer);
            outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
        }
        finally {
            this.releaseByteBuffer(buffer);
        }
        this.checkForDeadlock(outOfBandData);
        this.checkForMessages(outOfBandData, true, true);
        if (count <= 0) {
            throw new DfNameNotFoundException(typeName, "Type");
        }
        ILiteType[] componentTypes = this.getObjectProtocol().deserializePersistentTypes(result, count);
        ILiteType typeResult = componentTypes[componentTypes.length - 1];
        if (!typeResult.getName().equals(typeName)) {
            throw new ProtocolException("Need to change algorithm because server did something different");
        }
        return typeResult;
    }

    private ILiteType fetchTypeViaApply(String typeName, int cacheVStamp) throws DfException {
        DynamicallyTypedData arguments = new DynamicallyTypedData();
        arguments.setString("TYPE_NAME", typeName);
        arguments.setInt("CACHE_VSTAMP", cacheVStamp);
        String result = this.applyForStringInternal("FETCH_TYPE", null, arguments, true, true);
        NumberFormat nf = NumberFormat.getIntegerInstance();
        ParsePosition pp = new ParsePosition(0);
        Number count = nf.parse(result, pp);
        if (pp.getIndex() == 0) {
            throw new ProtocolException("FETCH_TYPE result is missing type count");
        }
        if (count.intValue() <= 0) {
            throw new DfNameNotFoundException(typeName, "Type");
        }
        result = result.substring(pp.getIndex() + 1);
        ILiteType[] componentTypes = this.getObjectProtocol().deserializePersistentTypes(result, count.intValue());
        ILiteType typeResult = componentTypes[componentTypes.length - 1];
        if (!typeResult.getName().equals(typeName)) {
            throw new ProtocolException("Need to change algorithm because server did something different");
        }
        return typeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void closeCollection(int n) throws DfException {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            int outOfBandData;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                void collectionId;
                int sequenceNumber = this.getNextSequenceNumber();
                NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 57);
                NetwiseProtocol.serializeString(buffer, this.m_sessionId);
                NetwiseProtocol.serializeInteger(buffer, (int)collectionId);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                NetwiseProtocol.deserializeString(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, true, false);
            Object var8_8 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(var8_8, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized ITypedData[] multiNext(int n, ILiteType iLiteType, int n2, BooleanHolder booleanHolder, boolean bl) throws DfException {
        int n3 = n;
        ILiteType iLiteType2 = iLiteType;
        int n4 = n2;
        BooleanHolder booleanHolder2 = booleanHolder;
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            void type;
            ITypedData[] iTypedDataArray;
            ITypedData[] iTypedDataArray2;
            void maybeMoreHolder;
            void throwErrors;
            int outOfBandData;
            boolean valid;
            boolean maybeMore;
            int count;
            byte[] resultBytes;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n3), iLiteType2, Conversions.intObject((int)n4), booleanHolder2, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                void maximumItems;
                void collectionId;
                int sequenceNumber = this.getNextSequenceNumber();
                NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 56);
                NetwiseProtocol.serializeString(buffer, this.m_sessionId);
                NetwiseProtocol.serializeInteger(buffer, (int)collectionId);
                NetwiseProtocol.serializeInteger(buffer, (int)maximumItems);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                resultBytes = NetwiseProtocol.deserializeByteArray(buffer, true);
                count = NetwiseProtocol.deserializeInteger(buffer);
                maybeMore = NetwiseProtocol.deserializeBoolean(buffer);
                valid = NetwiseProtocol.deserializeBoolean(buffer);
                outOfBandData = NetwiseProtocol.deserializeInteger(buffer);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            this.checkForDeadlock(outOfBandData);
            this.checkForMessages(outOfBandData, (boolean)throwErrors, false);
            if (!valid) {
                throw this.getLastChanceException("MultiNext", null, null);
            }
            if (NetwiseDocbaseRpcClient.isMoreResultIndicated(outOfBandData)) {
                resultBytes = this.getCompleteResultBytes(resultBytes);
            }
            if (maybeMoreHolder != null) {
                maybeMoreHolder.value = maybeMore;
            }
            String resultString = NetwiseProtocol.toString(resultBytes);
            ITypedData[] iTypedDataArray3 = iTypedDataArray2 = (iTypedDataArray = this.getObjectProtocol().deserializeObjects(resultString, (ILiteType)type, count));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n3), iLiteType2, Conversions.intObject((int)n4), booleanHolder2, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(iTypedDataArray2, joinPoint);
            }
            return iTypedDataArray;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n3), iLiteType2, Conversions.intObject((int)n4), booleanHolder2, Conversions.booleanObject((boolean)bl2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private DfException getLastChanceException(String rpcName, IDfId id, ITypedData arguments) {
        DfException e = this.getMessageManager().getException();
        if (e != null) {
            return e;
        }
        return new UnknownServerResponseException(rpcName, id, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized byte[] getBlock(int n, int n2, BooleanHolder booleanHolder) throws DfException {
        int n3 = n;
        int n4 = n2;
        BooleanHolder booleanHolder2 = booleanHolder;
        JoinPoint joinPoint = null;
        try {
            byte[] byArray;
            byte[] byArray2;
            void lastBlockHolder;
            byte[] block;
            boolean isLastBlock;
            int length;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n3), Conversions.intObject((int)n4), booleanHolder2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                void blockNumber;
                void pullerHandle;
                int sequenceNumber = this.getNextSequenceNumber();
                NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 6);
                NetwiseProtocol.serializeInteger(buffer, (int)pullerHandle);
                NetwiseProtocol.serializeInteger(buffer, (int)blockNumber);
                this.sendMessage(buffer);
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                length = NetwiseProtocol.deserializeInteger(buffer);
                isLastBlock = NetwiseProtocol.deserializeBoolean(buffer);
                block = NetwiseProtocol.deserializeByteArray(buffer, false);
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            if (length != block.length) {
                throw new DfCriticalException("The RPC length field does not seem right");
            }
            if (lastBlockHolder != null) {
                lastBlockHolder.value = isLastBlock;
            }
            byte[] byArray3 = byArray2 = (byArray = block);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n3), Conversions.intObject((int)n4), booleanHolder2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(byArray2, joinPoint);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.intObject((int)n3), Conversions.intObject((int)n4), booleanHolder2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public synchronized long doPush(int n, InputStream inputStream) throws DfException {
        int n2 = n;
        InputStream inputStream2 = inputStream;
        JoinPoint joinPoint = null;
        try {
            long l;
            boolean result;
            long numberOfBytesTransferred;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)inputStream2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            ByteBuffer buffer = this.getByteBuffer();
            try {
                void pusherHandle;
                int sequenceNumber = this.getNextSequenceNumber();
                NetwiseDocbaseRpcClient.serializeRequestHeader(buffer, sequenceNumber, 27);
                NetwiseProtocol.serializeString(buffer, this.m_sessionId);
                NetwiseProtocol.serializeInteger(buffer, (int)pusherHandle);
                this.sendMessage(buffer);
                try {
                    void inputStream3;
                    numberOfBytesTransferred = this.handleGetBlockCallbacks(buffer, (InputStream)inputStream3);
                }
                finally {
                    this.receiveMessage(buffer);
                    NetwiseDocbaseRpcClient.validateResponseHeader(buffer, sequenceNumber);
                    result = NetwiseProtocol.deserializeBoolean(buffer);
                }
            }
            finally {
                this.releaseByteBuffer(buffer);
            }
            if (!result && numberOfBytesTransferred != 0L) {
                this.getMessageManager().flushMessages();
                if (this.getMessageManager().importMessagesFromServer()) {
                    throw this.getMessageManager().getException();
                }
                throw new UnknownServerResponseException("DO_PUSH", null, null);
            }
            long l2 = numberOfBytesTransferred;
            long l3 = l = l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)inputStream2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(object, joinPoint);
            }
            return l2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2), (Object)inputStream2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long handleGetBlockCallbacks(ByteBuffer byteBuffer, InputStream inputStream) throws DfException {
        ByteBuffer byteBuffer2 = byteBuffer;
        InputStream inputStream2 = inputStream;
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)byteBuffer2, (Object)inputStream2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$13$afef4320(joinPoint);
            }
            long numberOfBytesTransferred = 0L;
            IntHolder sequenceNumber = new IntHolder();
            IntHolder rpcId = new IntHolder();
            Exception savedException = null;
            do {
                int blockSize;
                ByteBuffer buffer;
                this.receiveMessage(buffer);
                NetwiseDocbaseRpcClient.deserializeRequestHeader(buffer, sequenceNumber, rpcId);
                this.releaseByteBuffer(buffer);
                buffer = this.getByteBuffer();
                NetwiseProtocol.serializeResponseHeader(buffer, sequenceNumber.value, 0);
                try {
                    switch (rpcId.value) {
                        case 2: {
                            void inputStream3;
                            blockSize = this.serializeBlock(buffer, (InputStream)inputStream3, 256);
                            break;
                        }
                        case 3: {
                            void inputStream3;
                            blockSize = this.serializeBlock(buffer, (InputStream)inputStream3, 1024);
                            break;
                        }
                        case 4: {
                            void inputStream3;
                            blockSize = this.serializeBlock(buffer, (InputStream)inputStream3, 4096);
                            break;
                        }
                        case 1: 
                        case 5: {
                            void inputStream3;
                            blockSize = this.serializeBlock(buffer, (InputStream)inputStream3, 16384);
                            break;
                        }
                        case 6: {
                            void inputStream3;
                            blockSize = this.serializeBlock(buffer, (InputStream)inputStream3, 63000);
                            break;
                        }
                        case 17023: {
                            blockSize = 0;
                            break;
                        }
                        default: {
                            throw new ProtocolException("Unsupported RPC callback");
                        }
                    }
                }
                catch (Exception e) {
                    savedException = e;
                    blockSize = 0;
                }
                this.sendMessage(buffer);
                numberOfBytesTransferred += (long)blockSize;
            } while (rpcId.value != 17023);
            if (savedException != null) {
                throw DfException.convert(savedException);
            }
            long l3 = l2 = (l = numberOfBytesTransferred);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)byteBuffer2, (Object)inputStream2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$14$afef4320(object, joinPoint);
            }
            return l;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)byteBuffer2, (Object)inputStream2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$15$afef4320(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static void deserializeRequestHeader(ByteBuffer buffer, IntHolder sequenceNumberHolder, IntHolder rpcIdHolder) throws ProtocolException {
        NetwiseProtocol.deserializeRequestHeader(buffer, sequenceNumberHolder, rpcIdHolder, null, null, null);
    }

    private int readFully(InputStream is, byte[] buf) throws IOException {
        int bytesThisTime;
        int bytesToRead = buf.length;
        do {
            if ((bytesThisTime = is.read(buf, buf.length - bytesToRead, bytesToRead)) != -1) continue;
            return buf.length - bytesToRead;
        } while ((bytesToRead -= bytesThisTime) != 0);
        return buf.length;
    }

    private int serializeBlock(ByteBuffer buffer, InputStream inputStream, int maximumLength) throws Exception {
        int actualLength;
        byte[] bytes;
        boolean lastBlock = false;
        Exception savedException = null;
        try {
            bytes = new byte[maximumLength];
            actualLength = this.readFully(inputStream, bytes);
            if (actualLength < maximumLength) {
                lastBlock = true;
            }
        }
        catch (Exception e) {
            actualLength = 0;
            bytes = new byte[]{};
            savedException = e;
        }
        NetwiseProtocol.serializeInteger(buffer, actualLength);
        NetwiseProtocol.serializeInteger(buffer, lastBlock || savedException != null ? 1 : 0);
        NetwiseProtocol.serializeByteArray(buffer, bytes, actualLength);
        if (savedException != null) {
            throw savedException;
        }
        return actualLength;
    }

    @Override
    public void setUserIdentifyingObject(IUserIdentifyingObject userIdentifyingObject) {
        this.m_userIdentifyingObject = userIdentifyingObject;
    }

    @Override
    public String[] getUsersForTracing() {
        return this.m_userIdentifyingObject != null ? this.m_userIdentifyingObject.getUsersForTracing() : null;
    }

    @Override
    public IUserTracingInfo getUserTracingInfo(String userArgIgnored) {
        return this.m_userIdentifyingObject != null ? this.m_userIdentifyingObject.getUserTracingInfo(userArgIgnored) : null;
    }

    private NetwiseDocbaseRpcClient asContainer() {
        return this;
    }

    static {
        Factory factory = new Factory("NetwiseDocbaseRpcClient.java", Class.forName("com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "newSessionByAddr", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "int:java.lang.String:[I:com.documentum.fc.impl.util.holders.ObjectHolder:java.lang.String:", "docbaseId:username:clientVersion:serverVersionHolder:sessionIdHint:", "com.documentum.fc.common.DfException:", "java.lang.String"), 81);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForBool", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "boolean"), 328);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applyForString", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "java.lang.String"), 729);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForTime", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfTime"), 779);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "fetchType", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:int:", "typeName:cacheVStamp:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.typeddata.ILiteType"), 820);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "closeSession", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "com.documentum.fc.common.IDfId:", "closeSessionId:", "com.documentum.fc.common.DfException:", "java.lang.String"), 828);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "closeCollection", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "int:", "collectionId:", "com.documentum.fc.common.DfException:", "void"), 918);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "multiNext", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "int:com.documentum.fc.client.impl.typeddata.ILiteType:int:com.documentum.fc.impl.util.holders.BooleanHolder:boolean:", "collectionId:type:maximumItems:maybeMoreHolder:throwErrors:", "com.documentum.fc.common.DfException:", "[Lcom.documentum.fc.client.impl.typeddata.ITypedData;"), 948);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getBlock", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "int:int:com.documentum.fc.impl.util.holders.BooleanHolder:", "pullerHandle:blockNumber:lastBlockHolder:", "com.documentum.fc.common.DfException:", "[B"), 1005);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "doPush", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "int:java.io.InputStream:", "pusherHandle:inputStream:", "com.documentum.fc.common.DfException:", "long"), 1040);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleGetBlockCallbacks", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.nio.ByteBuffer:java.io.InputStream:", "buffer:inputStream:", "com.documentum.fc.common.DfException:", "long"), 1090);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForByteArray", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "[B"), 361);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForCollection", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:int:boolean:boolean:", "methodName:id:arguments:batchHint:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.typeddata.ITypedDataIterator"), 396);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForDouble", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "double"), 483);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForId", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfId"), 518);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForInt", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "int"), 553);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForLong", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "long"), 588);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "applyForObject", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "java.lang.String:com.documentum.fc.common.IDfId:com.documentum.fc.client.impl.typeddata.ITypedData:boolean:boolean:", "methodName:id:arguments:throwErrors:flushOldMessages:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.typeddata.ITypedData"), 623);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "getNextPiece", "com.documentum.fc.client.impl.connection.docbase.netwise.NetwiseDocbaseRpcClient", "com.documentum.fc.impl.util.holders.BooleanHolder:", "moreHolder:", "com.documentum.fc.common.DfException:", "[B"), 695);
        NULL_METHOD_MAP = new HashMap<String, Integer>();
    }

    private class TypedDataIterator
    implements IBatchedTypedDataIterator,
    ITraceString {
        private boolean m_isOpen = true;
        private int m_collectionId;
        private ILiteType m_type;
        private boolean m_maybeMore;
        private ITypedData[] m_currentBatch;
        private int m_cursor;
        private int m_batchHint;
        private int m_innerGenerationId;

        TypedDataIterator(int collectionId, int generationId, ILiteType type, boolean maybeMore, int batchHint) {
            this.m_collectionId = collectionId;
            this.m_innerGenerationId = generationId;
            this.m_type = type;
            this.m_maybeMore = maybeMore;
            this.m_batchHint = batchHint;
            this.m_currentBatch = new TypedData[0];
        }

        public boolean hasNext() throws DfException {
            return this.m_cursor < this.m_currentBatch.length || this.getNextBatch();
        }

        private boolean getNextBatch() throws DfException {
            if (this.m_maybeMore) {
                try {
                    BooleanHolder maybeMoreHolder = new BooleanHolder();
                    this.m_currentBatch = NetwiseDocbaseRpcClient.this.multiNext(this.m_collectionId, this.m_type, this.m_batchHint, maybeMoreHolder, false);
                    this.m_maybeMore = maybeMoreHolder.value;
                    this.m_cursor = 0;
                    DfException exception = NetwiseDocbaseRpcClient.this.getMessageManager().getException();
                    if (exception != null) {
                        throw exception;
                    }
                }
                catch (DfException e) {
                    this.close();
                    throw e;
                }
                if (this.m_currentBatch.length == 0) {
                    this.close();
                    return false;
                }
                return true;
            }
            return false;
        }

        public ITypedData next() throws DfException, NoSuchElementException {
            if (!this.isGenerationStillValid()) {
                throw DfException.newQuerySessionClosedException();
            }
            if (this.m_cursor >= this.m_currentBatch.length && !this.getNextBatch()) {
                throw new NoSuchElementException();
            }
            return this.m_currentBatch[this.m_cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.m_isOpen) {
                try {
                    if (this.m_maybeMore) {
                        NetwiseDocbaseRpcClient.this.closeCollection(this.m_collectionId);
                    }
                }
                catch (DfException e) {
                    DfLogger.warn((Object)this, "Failed to close collection, collection={0}", new Object[]{this.m_collectionId}, (Throwable)e);
                }
                finally {
                    this.m_isOpen = false;
                    this.m_maybeMore = false;
                }
            }
        }

        public ILiteType getType() {
            return this.m_type;
        }

        public boolean isValid() {
            return NetwiseDocbaseRpcClient.this.m_generationId == NetwiseDocbaseRpcClient.this.m_generationId;
        }

        public ITypedData[] getBatch() throws DfException {
            if (this.hasNext()) {
                int resultLength = this.m_currentBatch.length - this.m_cursor;
                ITypedData[] result = new TypedData[resultLength];
                System.arraycopy(this.m_currentBatch, this.m_cursor, result, 0, resultLength);
                this.m_cursor += resultLength;
                return result;
            }
            return new TypedData[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isGenerationStillValid() {
            NetwiseDocbaseRpcClient netwiseDocbaseRpcClient = NetwiseDocbaseRpcClient.this.asContainer();
            synchronized (netwiseDocbaseRpcClient) {
                return this.m_innerGenerationId == NetwiseDocbaseRpcClient.this.m_generationId;
            }
        }

        public String toTraceString(boolean verbose) {
            StringBuilder b = new StringBuilder(64);
            b.append("TypedDataIterator{");
            b.append("collectionId=").append(this.m_collectionId);
            b.append(", open=").append(this.m_isOpen);
            b.append(", maybeMore=").append(this.m_maybeMore);
            b.append("}");
            return b.toString();
        }
    }
}

