/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase;

import com.documentum.fc.client.impl.typeddata.ITypedData;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerInfo {
    private ITypedData m_data;
    private int[] m_options;
    private Map<String, Integer> m_methodMap;

    public ServerInfo(ITypedData serverInfoData, int[] options) {
        this.m_data = serverInfoData;
        this.m_options = options;
        this.m_methodMap = ServerInfo.extractMethodMap(serverInfoData);
    }

    private static Map<String, Integer> extractMethodMap(ITypedData serverInfoData) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int count = serverInfoData.getValueCount("name");
        for (int i = 0; i < count; ++i) {
            String name = serverInfoData.getRepeatingString("name", i);
            int number = serverInfoData.getRepeatingInt("pos", i);
            if (name.equals("z")) continue;
            map.put(name, number);
        }
        serverInfoData.removeAll("name");
        serverInfoData.removeAll("pos");
        return map;
    }

    public Map<String, Integer> getMethodMap() {
        return this.m_methodMap;
    }

    public String getSecurityMode() {
        switch (this.m_options[1]) {
            case 1: {
                return "none";
            }
            case 2: {
                return "document";
            }
            case 3: {
                return "cabinet";
            }
            case 4: {
                return "combined";
            }
        }
        return "acl";
    }

    public int getClientCacheSize() {
        return this.m_options[2];
    }

    public boolean getNfsEnabled() {
        return this.m_options[3] != 0;
    }

    public String getMacProtocol() {
        switch (this.m_options[4]) {
            case 0: {
                return "none";
            }
            case 1: {
                return "ushare";
            }
            case 2: {
                return "test";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "nt";
            }
        }
        return "none";
    }

    public boolean getEventsDefault() {
        return this.m_options[5] != 0;
    }

    public int getSessionRecordHint() {
        return this.m_options[6];
    }

    public int getSerializationVersion() {
        return this.m_options[7];
    }

    public boolean getTzAware() {
        return (this.m_options[9] & 1) != 0;
    }

    public int getAclConversion() {
        return this.m_data.getInt("i_acl_conversion");
    }

    public boolean getFourDigitYear() {
        return this.m_data.getBoolean("four_digit_year");
    }

    public String getServerVersion() {
        return this.m_data.getString("server_version");
    }

    public boolean getPersCacheDisabled() {
        return this.m_data.getBoolean("pers_cache_disabled");
    }

    public int getPersCacheChangeCnt() {
        return this.m_data.getInt("pers_cache_change_cnt");
    }

    public int getTypeChangeCount() {
        return this.m_data.getInt("type_change_count");
    }

    public int getDdChangeCount() {
        return this.m_data.getInt("dd_change_count");
    }
}

