/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase;

import com.documentum.fc.client.impl.connection.docbase.DocbaseConnectionProtocol;
import com.documentum.fc.client.impl.docbase.IDocbaseSpec;
import com.documentum.fc.internal.util.SoftwareVersion;

public final class ServerEntry {
    private int m_proximity;
    private IDocbaseSpec m_docbaseSpec;
    private Object m_address;
    private Object m_address_ipv6;
    private int m_docbaseId;
    private SoftwareVersion m_serverVersion;
    private DocbaseConnectionProtocol m_connectProtocol;

    ServerEntry(IDocbaseSpec docbaseSpec, int docbaseId, int proximity, Object[] addresses, SoftwareVersion serverVersion) {
        this.m_docbaseSpec = docbaseSpec;
        this.m_docbaseId = docbaseId;
        this.m_proximity = proximity;
        this.m_address = addresses[0];
        this.m_address_ipv6 = addresses[1];
        this.m_serverVersion = serverVersion;
        this.m_connectProtocol = null;
    }

    public int getProximity() {
        return this.m_proximity;
    }

    public int getServerProximity() {
        return this.m_proximity % 1000;
    }

    public String getHostName() {
        return this.m_docbaseSpec.getHost();
    }

    public String getServerName() {
        return this.m_docbaseSpec.getServer();
    }

    public SoftwareVersion getServerVersion() {
        return this.m_serverVersion;
    }

    public Object getAddress() {
        return this.m_address;
    }

    public IDocbaseSpec getDocbaseSpec() {
        return this.m_docbaseSpec;
    }

    public int getDocbaseId() {
        return this.m_docbaseId;
    }

    public Object getAddressIPV6() {
        return this.m_address_ipv6;
    }

    public void setconnectionProtocol(DocbaseConnectionProtocol protocol) {
        this.m_connectProtocol = protocol;
    }

    public DocbaseConnectionProtocol getProtocol() {
        return this.m_connectProtocol;
    }
}

