/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbase;

import com.documentum.fc.client.DfAuthenticationException;
import com.documentum.fc.client.DfOutOfSessionsException;
import com.documentum.fc.client.impl.connection.docbase.ClientInfo;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnectionFactory;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnectionManager;
import com.documentum.fc.client.impl.docbase.IDocbaseSpec;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfLoginInfo;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.security.action.AddShutdownHookAction;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class DocbaseConnectionManager
implements IDocbaseConnectionManager {
    private Map m_unusedConnections;
    private Map m_orderedUnusedConnections;
    private int m_maximumConnections = DfPreferences.access().getMaximumSessionCount();
    private int m_usedConnectionCount = 0;
    private int m_unusedConnectionCount = 0;
    private final Object m_poolMutex;
    private IDocbaseConnectionFactory m_connectionFactory;
    private static boolean s_poolingEnabled;
    private static int s_sessionReuseLimit;
    private static boolean s_purgeFarConnections;
    private static long s_periodicAuthenticationInterval;
    private static final int SESSION_MAP_SIZE = 1001;
    private static final int DOCBASE_COUNT = 23;

    public DocbaseConnectionManager(IDocbaseConnectionFactory connectionFactory) {
        this.m_unusedConnections = new HashMap(23);
        this.m_orderedUnusedConnections = new LinkedHashMap(23);
        this.m_poolMutex = new Object();
        this.m_connectionFactory = connectionFactory;
        AccessController.doPrivileged(new AddShutdownHookAction(new ShutdownHook()));
    }

    public IDocbaseConnection getDocbaseConnection(IDocbaseSpec docbaseSpec, IDfLoginInfo loginInfo, ClientInfo clientInfo) throws DfException {
        assert (docbaseSpec != null);
        assert (loginInfo != null);
        assert (clientInfo != null);
        ConnectionEntry entry = this.getConnectionFromPool(docbaseSpec, loginInfo);
        if (entry != null) {
            try {
                IDocbaseConnection connection = this.authenticateConnection(entry, loginInfo, clientInfo);
                connection.incrementReuseCount();
                ++this.m_usedConnectionCount;
                return connection;
            }
            catch (DfAuthenticationException e) {
                this.closeConnection(entry.getConnection());
                throw e;
            }
            catch (DfException e) {
                this.closeConnection(entry.getConnection());
            }
        }
        if (this.m_usedConnectionCount + this.m_unusedConnectionCount >= this.m_maximumConnections && this.m_unusedConnectionCount > 0) {
            this.discardOneUnusedConnection();
        }
        if (this.m_usedConnectionCount + this.m_unusedConnectionCount >= this.m_maximumConnections) {
            throw new DfOutOfSessionsException();
        }
        IDocbaseConnection connection = this.m_connectionFactory.newDocbaseConnection(docbaseSpec, loginInfo, clientInfo);
        connection.setConnectionManager(this);
        ++this.m_usedConnectionCount;
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "{0} created", new Object[]{connection}, null);
        }
        return connection;
    }

    public void release(IDocbaseConnection connection) {
        if (this.shouldPoolConnection(connection)) {
            this.returnSessionToPool(connection);
        } else {
            this.closeConnection(connection);
            this.updateUsedConnectionCount(-1);
        }
    }

    private boolean shouldPoolConnection(IDocbaseConnection connection) {
        return s_poolingEnabled && !connection.isRestricted() && connection.getReuseCount() < s_sessionReuseLimit && this.isNearConnection(connection);
    }

    private boolean isNearConnection(IDocbaseConnection connection) {
        return !s_purgeFarConnections || connection.getServerProximity() < 9000 && connection.getServerProximity() != -1;
    }

    private void discardOneUnusedConnection() {
        ConnectionEntry connectionEntry = this.findConnectionForRecycle();
        if (connectionEntry != null) {
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "{0} discarded", new Object[]{connectionEntry.getConnection()}, null);
            }
            this.closeConnection(connectionEntry.getConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeUnusedConnections() {
        Object object = this.m_poolMutex;
        synchronized (object) {
            Set docbaseConnectionsSet = this.m_unusedConnections.entrySet();
            Iterator it = docbaseConnectionsSet.iterator();
            while (it.hasNext()) {
                Map.Entry docbaseEntry = it.next();
                Map docbaseConnections = (Map)docbaseEntry.getValue();
                DocbaseConnectionsIterator entryIterator = new DocbaseConnectionsIterator(docbaseConnections);
                while (entryIterator.hasNext()) {
                    ConnectionEntry entry = entryIterator.nextConnectionEntry();
                    this.closeConnection(entry.getConnection());
                    this.m_orderedUnusedConnections.remove(entry);
                    --this.m_unusedConnectionCount;
                }
                it.remove();
            }
        }
    }

    private void closeConnection(IDocbaseConnection connection) {
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "{0} closed", new Object[]{connection}, null);
        }
        connection.close();
    }

    private IDocbaseConnection authenticateConnection(ConnectionEntry connectionEntry, IDfLoginInfo loginInfo, ClientInfo clientInfo) throws DfException {
        IDocbaseConnection connection = connectionEntry.getConnection();
        if (loginInfo.matches(connectionEntry.getLoginInfo())) {
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "{0} is an exact match", new Object[]{connection}, null);
            }
            if (loginInfo.getForceAuthentication() || loginInfo.getPeriodicAuthentication() && this.isTimeForPeriodicAuthentication(connection)) {
                connection.authenticate(loginInfo, clientInfo, true, false, true);
            } else {
                connection.setLoginInfo(loginInfo);
                connection.setClientInfo(clientInfo, false);
            }
            return connection;
        }
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "{0} is a best match. Authentication required.", new Object[]{connection}, null);
        }
        connection.authenticate(loginInfo, clientInfo, true, false, true);
        return connection;
    }

    private boolean isTimeForPeriodicAuthentication(IDocbaseConnection connection) {
        return System.currentTimeMillis() > connection.getTimeOfLastAuthenticate() + s_periodicAuthenticationInterval;
    }

    private Map getDocbaseConnections(String docbaseKey, boolean create) {
        HashMap docbaseConnections = (HashMap)this.m_unusedConnections.get(docbaseKey);
        if (docbaseConnections == null && create) {
            docbaseConnections = new HashMap(1001);
            this.m_unusedConnections.put(docbaseKey, docbaseConnections);
        }
        return docbaseConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionEntry getConnectionFromPool(IDocbaseSpec docbaseSpec, IDfLoginInfo loginInfo) {
        Object object = this.m_poolMutex;
        synchronized (object) {
            if (this.m_unusedConnectionCount > 0) {
                return this.getBestMatchConnection(docbaseSpec, loginInfo);
            }
            return null;
        }
    }

    private ConnectionEntry getBestMatchConnection(IDocbaseSpec docbaseSpec, IDfLoginInfo loginInfo) {
        String docbaseKey = this.generateDocbaseKey(docbaseSpec, loginInfo);
        Map docbaseConnections = this.getDocbaseConnections(docbaseKey, false);
        ConnectionEntry connectionEntry = null;
        if (docbaseConnections != null && (connectionEntry = this.getExactMatchConnection(docbaseConnections, loginInfo, docbaseSpec)) == null) {
            connectionEntry = this.getClosestMatchConnection(docbaseSpec, docbaseConnections);
        }
        return connectionEntry;
    }

    private ConnectionEntry getExactMatchConnection(Map docbaseConnections, IDfLoginInfo loginInfo, IDocbaseSpec docbaseSpec) {
        String userKey = this.generateUserKey(loginInfo);
        IConnectEntryIter iterator = this.getConnectEntryIter(docbaseConnections, userKey);
        int matchIndex = -1;
        int diffPasswordIndex = -1;
        if (!iterator.hasNext()) {
            return null;
        }
        int i = 0;
        while (iterator.hasNext()) {
            ConnectionEntry entry = iterator.nextConnectionEntry();
            if (entry.getDocbaseSpec().matches(docbaseSpec)) {
                diffPasswordIndex = i;
                if (entry.matchPasswords(loginInfo)) {
                    matchIndex = i;
                    break;
                }
            }
            ++i;
        }
        if (matchIndex == -1) {
            matchIndex = diffPasswordIndex;
        }
        if (matchIndex != -1) {
            return iterator.removeAt(matchIndex);
        }
        return null;
    }

    private ConnectionEntry getClosestMatchConnection(IDocbaseSpec docbaseSpec, Map docbaseConnections) {
        DocbaseConnectionsIterator iterator = new DocbaseConnectionsIterator(docbaseConnections);
        while (iterator.hasNext()) {
            ConnectionEntry entry = iterator.nextConnectionEntry();
            if (!entry.getDocbaseSpec().matches(docbaseSpec)) continue;
            iterator.remove();
            return entry;
        }
        return null;
    }

    private ConnectionEntry findConnectionForRecycle() {
        Set entries = this.m_orderedUnusedConnections.keySet();
        Iterator iterator = entries.iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("Logical error. Did not find a connection in the non-empty pool.");
        }
        ConnectionEntry entry = (ConnectionEntry)iterator.next();
        IDfLoginInfo loginInfo = entry.getLoginInfo();
        String docbaseKey = this.generateDocbaseKey(entry.getDocbaseSpec(), loginInfo);
        Map docbaseConnections = this.getDocbaseConnections(docbaseKey, false);
        IConnectEntryIter userConnectionIterator = this.getConnectEntryIter(docbaseConnections, this.generateUserKey(loginInfo));
        while (userConnectionIterator.hasNext()) {
            ConnectionEntry connectionEntry = (ConnectionEntry)userConnectionIterator.next();
            if (connectionEntry != entry) continue;
            userConnectionIterator.remove();
            this.m_orderedUnusedConnections.remove(entry);
            break;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnSessionToPool(IDocbaseConnection docbaseConnection) {
        docbaseConnection.flushMessages();
        docbaseConnection.quiesce();
        Object object = this.m_poolMutex;
        synchronized (object) {
            IDfLoginInfo loginInfo = docbaseConnection.getLoginInfo();
            IDocbaseSpec docbaseSpec = docbaseConnection.getDocbaseSpec();
            String docbaseKey = this.generateDocbaseKey(docbaseSpec, loginInfo);
            Map docbaseConnections = this.getDocbaseConnections(docbaseKey, true);
            ConnectionEntry connectionEntry = this.putConnectionIntoUserPool(docbaseConnections, docbaseConnection);
            this.m_orderedUnusedConnections.put(connectionEntry, Boolean.TRUE);
            this.updateUsedConnectionCount(-1);
            ++this.m_unusedConnectionCount;
        }
    }

    private ConnectionEntry putConnectionIntoUserPool(Map docbaseConnections, IDocbaseConnection docbaseConnection) {
        String userKey = this.generateUserKey(docbaseConnection.getLoginInfo());
        Object existingConnectionEntry = docbaseConnections.get(userKey);
        ConnectionEntry connectionEntry = new ConnectionEntry(docbaseConnection, docbaseConnection.getLoginInfo());
        if (existingConnectionEntry == null) {
            docbaseConnections.put(userKey, connectionEntry);
        } else if (existingConnectionEntry instanceof List) {
            ((List)existingConnectionEntry).add(connectionEntry);
        } else if (existingConnectionEntry instanceof ConnectionEntry) {
            ArrayList<Object> connections = new ArrayList<Object>();
            connections.add(existingConnectionEntry);
            connections.add(connectionEntry);
            docbaseConnections.put(userKey, connections);
        } else {
            throw new RuntimeException("Logical error. Unexpected class: " + existingConnectionEntry.getClass().getName());
        }
        return connectionEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUsedConnectionCount(int value) {
        Object object = this.m_poolMutex;
        synchronized (object) {
            this.m_usedConnectionCount += value;
        }
    }

    private IConnectEntryIter getConnectEntryIter(Map docbaseConnections, String userKey) {
        IConnectEntryIter iterator;
        Object slot = docbaseConnections.get(userKey);
        if (slot == null) {
            iterator = new EmptyConnectionEntry();
        } else if (slot instanceof List) {
            iterator = new ConnectionEntryListIterator(docbaseConnections, userKey, (List)slot);
        } else if (slot instanceof ConnectionEntry) {
            iterator = new ConnectionEntryIterator(docbaseConnections, userKey, (ConnectionEntry)slot);
        } else {
            throw new RuntimeException("Logical error. Unexpected class: " + slot.getClass().getName());
        }
        return iterator;
    }

    private String generateDocbaseKey(IDocbaseSpec docbaseSpec, IDfLoginInfo loginInfo) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(docbaseSpec.getDocbase()).append('\n');
        buffer.append(loginInfo.getSecurityMode()).append('\n');
        return buffer.toString();
    }

    private String generateUserKey(IDfLoginInfo loginInfo) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(loginInfo.getDomain()).append('\n');
        buffer.append(loginInfo.getUser()).append('\n');
        return buffer.toString();
    }

    static {
        s_periodicAuthenticationInterval = 300000L;
        new PreferencesObserver();
    }

    private static class PreferencesObserver
    implements IPreferencesObserver {
        public PreferencesObserver() {
            DfPreferences.getInstance().addObserver(this);
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences preferences, String preferenceName) {
            s_poolingEnabled = ((DfPreferences)preferences).isSessionPoolEnabled() && ((DfPreferences)preferences).getSessionPoolMode().equals("level2");
            s_sessionReuseLimit = ((DfPreferences)preferences).getSessionReuseLimit();
            s_periodicAuthenticationInterval = ((DfPreferences)preferences).getSessionPoolReauthenticateInterval() * 1000;
            s_purgeFarConnections = DfPreferences.getInstance().getPurgeFarConnections();
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            DocbaseConnectionManager.this.disposeUnusedConnections();
        }
    }

    final class ConnectionEntryListIterator
    implements IConnectEntryIter {
        private Map m_docbaseConnections;
        private String m_userKey;
        private List m_list;
        private Iterator m_iterator;
        private ConnectionEntry m_curentEntry;

        public ConnectionEntryListIterator(Map docbaseConnections, String userKey, List currentList) {
            this.m_docbaseConnections = docbaseConnections;
            this.m_userKey = userKey;
            this.m_list = currentList;
            this.m_iterator = currentList.listIterator();
            this.m_curentEntry = null;
        }

        public void remove() {
            this.m_iterator.remove();
            this.updateIndexes(this.m_curentEntry);
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            this.m_curentEntry = (ConnectionEntry)this.m_iterator.next();
            return this.m_curentEntry;
        }

        public ConnectionEntry nextConnectionEntry() {
            return (ConnectionEntry)this.next();
        }

        public ConnectionEntry removeAt(int index) {
            ConnectionEntry entry = (ConnectionEntry)this.m_list.remove(index);
            this.updateIndexes(entry);
            return entry;
        }

        private void updateIndexes(ConnectionEntry entry) {
            DocbaseConnectionManager.this.m_orderedUnusedConnections.remove(entry);
            if (this.m_list.size() == 0) {
                this.m_docbaseConnections.remove(this.m_userKey);
            }
            DocbaseConnectionManager.this.m_unusedConnectionCount--;
        }
    }

    final class ConnectionEntryIterator
    implements IConnectEntryIter {
        private Map m_docbaseConnections;
        private String m_userKey;
        private ConnectionEntry m_initialEntry;
        private ConnectionEntry m_curentEntry;

        public ConnectionEntryIterator(Map docbaseConnections, String userKey, ConnectionEntry entry) {
            this.m_docbaseConnections = docbaseConnections;
            this.m_userKey = userKey;
            this.m_initialEntry = entry;
            this.m_curentEntry = entry;
        }

        public void remove() {
            DocbaseConnectionManager.this.m_orderedUnusedConnections.remove(this.m_initialEntry);
            this.m_docbaseConnections.remove(this.m_userKey);
            DocbaseConnectionManager.this.m_unusedConnectionCount--;
        }

        public boolean hasNext() {
            return this.m_curentEntry != null;
        }

        public Object next() {
            ConnectionEntry entry = this.m_curentEntry;
            this.m_curentEntry = null;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry;
        }

        public ConnectionEntry nextConnectionEntry() {
            return (ConnectionEntry)this.next();
        }

        public ConnectionEntry removeAt(int index) {
            if (index > 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.remove();
            return this.m_initialEntry;
        }
    }

    final class DocbaseConnectionsIterator
    implements IConnectEntryIter {
        private Map m_docbaseConnections;
        private Iterator m_userConnectionsIterator;
        private IConnectEntryIter m_iterator;

        public DocbaseConnectionsIterator(Map docbaseConnections) {
            this.m_docbaseConnections = docbaseConnections;
            this.m_userConnectionsIterator = docbaseConnections.keySet().iterator();
            this.switchToNextUser();
        }

        public void remove() {
            this.m_iterator.remove();
        }

        public boolean hasNext() {
            if (this.m_iterator == null) {
                return false;
            }
            if (!this.m_iterator.hasNext()) {
                if (this.switchToNextUser()) {
                    return this.hasNext();
                }
                return false;
            }
            return this.m_iterator.hasNext();
        }

        public Object next() {
            Object value = this.m_iterator.next();
            if (value == null) {
                value = this.hasNext() ? this.next() : null;
            }
            return value;
        }

        public ConnectionEntry nextConnectionEntry() {
            return (ConnectionEntry)this.next();
        }

        public ConnectionEntry removeAt(int index) {
            DocbaseConnectionsIterator iterator = new DocbaseConnectionsIterator(this.m_docbaseConnections);
            int i = 0;
            while (iterator.hasNext()) {
                ConnectionEntry entry = iterator.nextConnectionEntry();
                if (i++ != index) continue;
                iterator.remove();
                return entry;
            }
            throw new IllegalArgumentException("Wrong index");
        }

        private boolean switchToNextUser() {
            if (this.m_userConnectionsIterator.hasNext()) {
                String userKey = (String)this.m_userConnectionsIterator.next();
                this.m_iterator = DocbaseConnectionManager.this.getConnectEntryIter(this.m_docbaseConnections, userKey);
                return true;
            }
            this.m_iterator = null;
            return false;
        }
    }

    final class EmptyConnectionEntry
    implements IConnectEntryIter {
        EmptyConnectionEntry() {
        }

        public void remove() {
            throw new RuntimeException("Illegal operation");
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public ConnectionEntry nextConnectionEntry() {
            return null;
        }

        public ConnectionEntry removeAt(int index) {
            throw new RuntimeException("Illigal operation");
        }
    }

    static interface IConnectEntryIter
    extends Iterator {
        public ConnectionEntry nextConnectionEntry();

        public ConnectionEntry removeAt(int var1);
    }

    static final class ConnectionEntry {
        private IDocbaseConnection m_connection;
        private IDfLoginInfo m_loginInfo;

        ConnectionEntry(IDocbaseConnection connection, IDfLoginInfo loginInfo) {
            this.m_connection = connection;
            this.m_loginInfo = loginInfo;
        }

        IDocbaseConnection getConnection() {
            return this.m_connection;
        }

        IDocbaseSpec getDocbaseSpec() {
            return this.m_connection.getDocbaseSpec();
        }

        IDfLoginInfo getLoginInfo() {
            return this.m_loginInfo;
        }

        boolean matchPasswords(IDfLoginInfo loginInfo) {
            return DfUtil.isEqual(loginInfo.getPassword(), this.getLoginInfo().getPassword());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionEntry)) {
                return false;
            }
            ConnectionEntry connectionEntry = (ConnectionEntry)o;
            return this.m_connection.equals(connectionEntry.m_connection);
        }

        public int hashCode() {
            return this.m_connection.hashCode();
        }
    }
}

