/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection;

import com.documentum.fc.client.impl.connection.LiteTypeKey;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.connection.docbase.ServerInfo;
import com.documentum.fc.client.impl.typeddata.AggregateLiteType;
import com.documentum.fc.client.impl.typeddata.AspectedLiteType;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.LiteType;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LiteTypeManager {
    private int m_cacheVStamp = 0;
    private long m_lastCacheRefreshTime;
    private volatile boolean m_insideConsistencyCheck = false;
    private boolean m_serverSupportsDynamicTypes;
    private final Map<LiteTypeKey, ILiteType> m_typeMap = Collections.synchronizedMap(new LRUCache());
    private final Map<LiteTypeKey, ILiteType> m_extendedTypeMap = Collections.synchronizedMap(new LRUCache());
    private static Hashtable<String, LiteTypeManager> s_knownTypeManagers = new Hashtable();
    private static int s_typeCacheConsistencyInterval;
    private static int s_typeCacheMaxSize;
    private static final String TYPE_NAME = "type_name";
    private static final String TYPE_CHANGE_COUNT = "type_change_count";

    public static synchronized LiteTypeManager getInstance(String docbaseName) {
        LiteTypeManager typeManager = s_knownTypeManagers.get(docbaseName);
        if (typeManager == null) {
            typeManager = new LiteTypeManager();
            s_knownTypeManagers.put(docbaseName, typeManager);
        }
        return typeManager;
    }

    private LiteTypeManager() {
        this.m_lastCacheRefreshTime = System.currentTimeMillis();
    }

    public void updateFromServerInfo(ServerInfo serverInfo) {
        if (this.m_cacheVStamp == 0) {
            this.m_cacheVStamp = serverInfo.getTypeChangeCount();
            this.m_serverSupportsDynamicTypes = serverInfo.getMethodMap().containsKey("GET_TYPES_CHANGED");
        }
    }

    public ILiteType getType(String typeName, IDocbaseConnection connection) throws DfException {
        return this.getType(typeName, null, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILiteType getType(String typeName, List<String> aspectTypeNameList, IDocbaseConnection connection) throws DfException {
        ILiteType rawType;
        LiteTypeKey key;
        ILiteType typeWithAspect;
        if (this.m_serverSupportsDynamicTypes) {
            this.synchronizeWithServer(connection);
        }
        if ((typeWithAspect = this.m_typeMap.get(key = new LiteTypeKey(typeName, aspectTypeNameList))) == null && !(rawType = this.getRawType(typeName, connection)).equals(typeWithAspect = this.applyAspectToType(rawType, aspectTypeNameList, connection))) {
            Map<LiteTypeKey, ILiteType> map = this.m_typeMap;
            synchronized (map) {
                ILiteType typeRecentlyCreatedByAnotherThread = this.m_typeMap.get(key);
                if (typeRecentlyCreatedByAnotherThread != null) {
                    typeWithAspect = typeRecentlyCreatedByAnotherThread;
                } else {
                    this.m_typeMap.put(key, typeWithAspect);
                }
            }
        }
        return typeWithAspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILiteType getRawType(String typeName, IDocbaseConnection connection) throws DfException {
        LiteTypeKey key = new LiteTypeKey(typeName, null);
        ILiteType type = this.m_typeMap.get(key);
        if (type == null) {
            type = connection.fetchType(typeName, true);
            type.setReadOnly(true);
            String parentTypeName = type.getDeclaredParentTypeName();
            if (!StringUtil.isEmptyOrNull(parentTypeName)) {
                ILiteType parentType = this.getType(parentTypeName, connection);
                ILiteType childType = type;
                ILiteType superType = childType.getSuperType();
                if (superType != null) {
                    superType = this.getType(childType.getSuperType().getName(), connection);
                    ILiteType childTypeForSuper = ((AggregateLiteType)superType).getChildType();
                    childType = new LiteType(type.getName(), childTypeForSuper);
                    ((LiteType)childType).copyTypeInfoFrom(type);
                }
                type = new AggregateLiteType(parentType, childType, (AggregateLiteType)superType);
            }
            Map<LiteTypeKey, ILiteType> map = this.m_typeMap;
            synchronized (map) {
                ILiteType typeRecentlyCreatedByAnotherThread = this.m_typeMap.get(key);
                if (typeRecentlyCreatedByAnotherThread != null) {
                    type = typeRecentlyCreatedByAnotherThread;
                } else {
                    this.m_typeMap.put(key, type);
                }
            }
        }
        return type;
    }

    private ILiteType applyAspectToType(ILiteType srcType, List<String> aspectTypeNames, IDocbaseConnection connection) throws DfException {
        if (aspectTypeNames == null) {
            return srcType;
        }
        ILiteType type = srcType;
        for (String aspectTypeName : aspectTypeNames) {
            if (StringUtil.isEmptyOrNull(aspectTypeName)) continue;
            ILiteType origAspectType = this.getType(aspectTypeName, connection);
            if (type instanceof AggregateLiteType) {
                AggregateLiteType aggType = (AggregateLiteType)type;
                ILiteType parentType = aggType.getParentType().getUnextendedType();
                ILiteType childType = aggType.getChildType().getUnextendedType();
                parentType = new AspectedLiteType(parentType, origAspectType);
                ((LiteType)parentType).copyTypeInfoFrom(origAspectType);
                if (!origAspectType.isAspectDataShareable()) {
                    childType = new AspectedLiteType(childType, origAspectType);
                    String origDeclaredParentTypeName = childType.getDeclaredParentTypeName();
                    ((LiteType)childType).copyTypeInfoFrom(origAspectType);
                    ((LiteType)childType).setDeclaredParentTypeName(origDeclaredParentTypeName);
                }
                type = new AggregateLiteType(parentType, childType, (AggregateLiteType)type.getSuperType());
                continue;
            }
            type = new AspectedLiteType(type, origAspectType);
            ((LiteType)type).copyTypeInfoFrom(origAspectType);
        }
        return type;
    }

    public void registerExtendedType(String typeName, List<String> aspectTypeNames, ILiteType type) {
        this.m_extendedTypeMap.put(new LiteTypeKey(typeName, aspectTypeNames), type);
    }

    public ILiteType getExtendedType(String typeName, List<String> aspectTypeNames) {
        return this.m_extendedTypeMap.get(new LiteTypeKey(typeName, aspectTypeNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ILiteType> getCachedTypes() {
        Map<LiteTypeKey, ILiteType> map = this.m_typeMap;
        synchronized (map) {
            return this.m_typeMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(String typeName) {
        LiteTypeKey key;
        Iterator<LiteTypeKey> it;
        Map<LiteTypeKey, ILiteType> map = this.m_typeMap;
        synchronized (map) {
            it = this.m_typeMap.keySet().iterator();
            while (it.hasNext()) {
                key = it.next();
                if (!key.referencesType(typeName)) continue;
                it.remove();
            }
        }
        map = this.m_extendedTypeMap;
        synchronized (map) {
            it = this.m_extendedTypeMap.keySet().iterator();
            while (it.hasNext()) {
                key = it.next();
                if (!key.referencesType(typeName)) continue;
                it.remove();
            }
        }
        if (DfLogger.isInfoEnabled(this)) {
            DfLogger.info((Object)this, "Flush type {0} from maps.", new Object[]{typeName}, null);
        }
    }

    public int getCacheVStamp() {
        return this.m_cacheVStamp;
    }

    public void requestConsistencyCheck() {
        this.m_lastCacheRefreshTime = 0L;
    }

    public ILiteType refreshTypeIfNeeded(ILiteType type, int typeCacheVStamp, IDocbaseConnection connection) {
        int vStampInCache = type.getUnextendedType().getCacheVStamp();
        if (vStampInCache < typeCacheVStamp) {
            if (DfLogger.isInfoEnabled(this)) {
                DfLogger.info((Object)this, "Server is fresher ({0}, {1})", new Object[]{vStampInCache, typeCacheVStamp}, null);
            }
            try {
                this.flush(type.getName());
                return this.getType(type.getName(), this.extractAspectTypeNames(type), connection);
            }
            catch (DfException e) {
                return type;
            }
        }
        if (vStampInCache > typeCacheVStamp && DfLogger.isInfoEnabled(this)) {
            DfLogger.info((Object)this, "DFC is fresher ({0}, {1})", new Object[]{vStampInCache, typeCacheVStamp}, null);
        }
        return type;
    }

    private List<String> extractAspectTypeNames(ILiteType type) {
        ArrayList<String> result = null;
        if ((type = type.getUnextendedType()) instanceof AggregateLiteType) {
            type = ((AggregateLiteType)type).getParentType();
        }
        while (type != null && type instanceof AspectedLiteType) {
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(((AspectedLiteType)type).getOriginalAspectLiteType().getName());
            type = type.getSuperType();
        }
        return result;
    }

    boolean needsConsistencyCheck() {
        if (this.m_insideConsistencyCheck) {
            return false;
        }
        long delta = System.currentTimeMillis() - this.m_lastCacheRefreshTime;
        return delta > (long)(s_typeCacheConsistencyInterval * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizeWithServer(IDocbaseConnection connection) {
        LiteTypeManager liteTypeManager = this;
        synchronized (liteTypeManager) {
            if (!this.needsConsistencyCheck()) {
                return;
            }
            this.m_insideConsistencyCheck = true;
        }
        try {
            ITypedData result = connection.getDocbaseApi().getTypesChanged(this.m_cacheVStamp);
            Map<LiteTypeKey, ILiteType> map = this.m_typeMap;
            synchronized (map) {
                block17: {
                    this.m_cacheVStamp = result.getInt(TYPE_CHANGE_COUNT);
                    this.m_lastCacheRefreshTime = System.currentTimeMillis();
                    if (result.hasAttr(TYPE_NAME)) break block17;
                    return;
                }
                int numTypesToFlush = result.getValueCount(TYPE_NAME);
                for (int i = 0; i < numTypesToFlush; ++i) {
                    this.flush(result.getRepeatingString(TYPE_NAME, i));
                }
            }
            if (DfLogger.isInfoEnabled(this)) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < result.getValueCount(TYPE_NAME); ++i) {
                    buf.append(result.getRepeatingString(TYPE_NAME, i)).append(',');
                }
                DfLogger.info((Object)this, "Type cache refresh: {0}", new Object[]{buf.toString()}, null);
            }
        }
        catch (DfException e) {
            DfLogger.error((Object)this, "Error trying to get changed types", null, (Throwable)e);
        }
        finally {
            this.m_insideConsistencyCheck = false;
        }
    }

    static {
        DfPreferences.getInstance().addObserver(new PreferencesObserver());
    }

    private static class PreferencesObserver
    implements IPreferencesObserver {
        public PreferencesObserver() {
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences typedPreferences, String preferenceName) {
            DfPreferences preferences = (DfPreferences)typedPreferences;
            s_typeCacheConsistencyInterval = preferences.getTypeCurrencyCheckInterval();
            s_typeCacheMaxSize = preferences.getTypeCacheSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LRUCache
    extends LinkedHashMap<LiteTypeKey, ILiteType> {
        LRUCache() {
            super(301, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > s_typeCacheMaxSize;
        }
    }
}

