/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection;

import com.documentum.fc.impl.util.StringUtil;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteTypeKey {
    private String m_typeName;
    private List<String> m_aspectTypeNames;
    private String m_key;

    public LiteTypeKey(String typeName, List<String> aspectNames) {
        this.m_typeName = typeName;
        this.m_aspectTypeNames = aspectNames;
        if (this.m_aspectTypeNames != null) {
            Collections.sort(this.m_aspectTypeNames);
        }
        this.buildKey();
    }

    public LiteTypeKey(String typeName) {
        this(typeName, null);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LiteTypeKey)) {
            return false;
        }
        return this.m_key.equals(((LiteTypeKey)obj).m_key);
    }

    public int hashCode() {
        int result = 17;
        return 29 * result + this.m_key.hashCode();
    }

    public String toString() {
        return this.m_key;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public List<String> getAspectTypeNames() {
        return this.m_aspectTypeNames;
    }

    public boolean referencesType(String typeName) {
        return this.m_typeName.equals(typeName) || this.m_aspectTypeNames != null && this.m_aspectTypeNames.contains(typeName);
    }

    private void buildKey() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.m_typeName);
        int aspectCount = this.m_aspectTypeNames == null ? 0 : this.m_aspectTypeNames.size();
        for (int i = 0; i < aspectCount; ++i) {
            String aspectTypeName = this.m_aspectTypeNames.get(i);
            if (StringUtil.isEmptyOrNull(aspectTypeName)) continue;
            buf.append(',').append(aspectTypeName);
        }
        this.m_key = buf.toString();
    }
}

