/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.acs.impl.common.config.cache.location;

import com.documentum.fc.client.DfQuery;
import com.documentum.fc.client.IDfCollection;
import com.documentum.fc.client.IDfNetworkLocationEntry;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.acs.impl.common.config.cache.common.BaseConfigLoader;
import com.documentum.fc.client.acs.impl.common.config.cache.location.DfNetworkLocationEntry;
import com.documentum.fc.client.acs.impl.common.config.cache.location.IPRange;
import com.documentum.fc.client.acs.impl.common.config.cache.location.IPv4Format;
import com.documentum.fc.client.acs.impl.common.config.cache.location.IPv6Format;
import com.documentum.fc.client.acs.impl.common.config.object.DfIpAddressRange;
import com.documentum.fc.client.acs.impl.common.util.EnumerationFactory;
import com.documentum.fc.client.impl.session.ISession;
import com.documentum.fc.common.DfException;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DfAllNetworkLocations
extends BaseConfigLoader {
    private static final DfNetworkLocationEntry[] EMPTY_NETWORK_LOCATION_ARRAY;
    private static final IDfNetworkLocationEntry[] EMPTY_I_NETWORK_LOCATION_ARRAY;
    private static final String NETLOC_IDENT = "netloc_ident";
    private static final String NETLOC_DISPLAY_NAME = "netloc_display_name";
    private static final String DEFAULT_NETLOC = "default_netloc";
    private static final String BEGIN_NEAR_IP_ADDRESS = "begin_near_ip_address";
    private static final String END_NEAR_IP_ADDRESS = "end_near_ip_address";
    private static final String IP_ADDR_RANGE = "ip_address_range";
    private static final String QUERY_STRING_BASIC_ATTRS;
    private static final String QUERY_STRING_EXTENDED_ATTRS = ",ip_address_range";
    private static final String FROM_CLAUSE;
    private DfNetworkLocationEntry[] m_allNetworkLocations;
    private IDfNetworkLocationEntry[] m_defaultNetworkLocations;
    private Map<String, IDfNetworkLocationEntry> m_networkLocationMap;
    private String m_defaultNetworkLocationsToString;
    private boolean m_hasIPRange;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;

    static DfAllNetworkLocations getInstance(List<DfNetworkLocationEntry> list) {
        List<DfNetworkLocationEntry> list2 = list;
        JoinPoint joinPoint = null;
        try {
            DfAllNetworkLocations dfAllNetworkLocations;
            DfAllNetworkLocations dfAllNetworkLocations2;
            List<DfNetworkLocationEntry> array;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, list2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfAllNetworkLocations allNetworkLocations = new DfAllNetworkLocations();
            allNetworkLocations.set(array);
            DfAllNetworkLocations dfAllNetworkLocations3 = dfAllNetworkLocations2 = (dfAllNetworkLocations = allNetworkLocations);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, list2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfAllNetworkLocations2, joinPoint);
            }
            return dfAllNetworkLocations;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, list2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static DfAllNetworkLocations getInstance(IDfSession iDfSession) throws DfException {
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            DfAllNetworkLocations dfAllNetworkLocations;
            DfAllNetworkLocations dfAllNetworkLocations2;
            IDfSession session;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfAllNetworkLocations allNetworkLocations = new DfAllNetworkLocations();
            allNetworkLocations.load(session);
            DfAllNetworkLocations dfAllNetworkLocations3 = dfAllNetworkLocations2 = (dfAllNetworkLocations = allNetworkLocations);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfAllNetworkLocations2, joinPoint);
            }
            return dfAllNetworkLocations;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private DfAllNetworkLocations() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_hasIPRange = false;
            this.m_allNetworkLocations = EMPTY_NETWORK_LOCATION_ARRAY;
            this.m_defaultNetworkLocations = EMPTY_I_NETWORK_LOCATION_ARRAY;
            this.m_networkLocationMap = new HashMap<String, IDfNetworkLocationEntry>();
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    IDfNetworkLocationEntry getLocationById(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void networkLocationId;
            IDfNetworkLocationEntry iDfNetworkLocationEntry;
            IDfNetworkLocationEntry iDfNetworkLocationEntry2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfNetworkLocationEntry iDfNetworkLocationEntry3 = iDfNetworkLocationEntry2 = (iDfNetworkLocationEntry = this.m_networkLocationMap.get(networkLocationId));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfNetworkLocationEntry2, joinPoint);
            }
            return iDfNetworkLocationEntry;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    List<IDfNetworkLocationEntry> getNetworkLocations(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            ArrayList<IDfNetworkLocationEntry> arrayList;
            ArrayList<IDfNetworkLocationEntry> arrayList2;
            void ipAddress;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ArrayList<IDfNetworkLocationEntry> list = new ArrayList<IDfNetworkLocationEntry>(this.m_allNetworkLocations.length);
            String ip = ipAddress.contains(":") ? IPv6Format.getIPv6String((String)ipAddress) : IPv4Format.getIPString((String)ipAddress, false);
            if (ip != null) {
                for (DfNetworkLocationEntry networkLocationEntry : this.m_allNetworkLocations) {
                    if (!networkLocationEntry.inRange(ip)) continue;
                    list.add(networkLocationEntry);
                }
            }
            ArrayList<IDfNetworkLocationEntry> arrayList3 = arrayList2 = (arrayList = list);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(arrayList2, joinPoint);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    Enumeration<IDfNetworkLocationEntry> getAllNetworkLocations() {
        JoinPoint joinPoint = null;
        try {
            Enumeration<IDfNetworkLocationEntry> enumeration;
            Enumeration<IDfNetworkLocationEntry> enumeration2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Enumeration<IDfNetworkLocationEntry> enumeration3 = enumeration2 = (enumeration = EnumerationFactory.getEnumeration((IDfNetworkLocationEntry[])this.m_allNetworkLocations));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(enumeration2, joinPoint);
            }
            return enumeration;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    List<DfNetworkLocationEntry> getAllNetworkLocationsAsList() {
        JoinPoint joinPoint = null;
        try {
            List<DfNetworkLocationEntry> list;
            List<DfNetworkLocationEntry> list2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            List<DfNetworkLocationEntry> list3 = list2 = (list = Arrays.asList(this.m_allNetworkLocations));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(list2, joinPoint);
            }
            return list;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    Enumeration<IDfNetworkLocationEntry> getDefaultNetworkLocations() {
        JoinPoint joinPoint = null;
        try {
            Enumeration<IDfNetworkLocationEntry> enumeration;
            Enumeration<IDfNetworkLocationEntry> enumeration2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Enumeration<IDfNetworkLocationEntry> enumeration3 = enumeration2 = (enumeration = EnumerationFactory.getEnumeration(this.m_defaultNetworkLocations));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(enumeration2, joinPoint);
            }
            return enumeration;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    String getDefaultNetworkLocationsToString() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = this.m_defaultNetworkLocationsToString);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void load(IDfSession iDfSession) throws DfException {
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            void session;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String queryString = this.hasIPRangeAttr((ISession)session) ? QUERY_STRING_BASIC_ATTRS + QUERY_STRING_EXTENDED_ATTRS + FROM_CLAUSE : QUERY_STRING_BASIC_ATTRS + FROM_CLAUSE;
            DfQuery query = new DfQuery();
            query.setDQL(queryString);
            IDfCollection collection = query.execute((IDfSession)session, 0);
            try {
                List<DfNetworkLocationEntry> allNetworkLocations = this.process(collection);
                this.set(allNetworkLocations);
            }
            finally {
                collection.close();
            }
            Object var9_9 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var9_9, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<DfNetworkLocationEntry> process(IDfCollection iDfCollection) throws DfException {
        IDfCollection iDfCollection2 = iDfCollection;
        JoinPoint joinPoint = null;
        try {
            ArrayList<DfNetworkLocationEntry> arrayList;
            ArrayList<DfNetworkLocationEntry> arrayList2;
            void collection;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iDfCollection2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ArrayList<DfNetworkLocationEntry> allNetworkLocations = new ArrayList<DfNetworkLocationEntry>();
            while (collection.next()) {
                int i;
                String id = collection.getString(NETLOC_IDENT);
                String name = collection.getString(NETLOC_DISPLAY_NAME);
                boolean isDefault = collection.getBoolean(DEFAULT_NETLOC);
                int size = collection.getValueCount(BEGIN_NEAR_IP_ADDRESS);
                int rangeSize = 0;
                if (this.m_hasIPRange) {
                    rangeSize = collection.getValueCount(IP_ADDR_RANGE);
                }
                ArrayList<IPRange> ipRangeList = new ArrayList<IPRange>(size + rangeSize);
                for (i = 0; i < size; ++i) {
                    String endIP;
                    String beginIP = collection.getRepeatingString(BEGIN_NEAR_IP_ADDRESS, i);
                    IPRange ipRange = IPRange.getIPRange(beginIP, endIP = collection.getRepeatingString(END_NEAR_IP_ADDRESS, i));
                    if (ipRange == null) continue;
                    ipRangeList.add(ipRange);
                }
                for (i = 0; i < rangeSize; ++i) {
                    DfIpAddressRange range = DfIpAddressRange.getIpAddressRange(collection.getRepeatingString(IP_ADDR_RANGE, i));
                    IPRange ipRange = IPRange.getIPRange(range.getBeginAddress(), range.getEndAddress());
                    if (ipRange == null) continue;
                    ipRangeList.add(ipRange);
                }
                DfNetworkLocationEntry networkLocationEntry = DfNetworkLocationEntry.getNetworkLocationEntry(id, name, isDefault, ipRangeList);
                if (networkLocationEntry == null) continue;
                allNetworkLocations.add(networkLocationEntry);
            }
            ArrayList<DfNetworkLocationEntry> arrayList3 = arrayList2 = (arrayList = allNetworkLocations);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iDfCollection2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(arrayList2, joinPoint);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iDfCollection2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void set(List<DfNetworkLocationEntry> list) {
        List<DfNetworkLocationEntry> list2 = list;
        JoinPoint joinPoint = null;
        try {
            void list3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, list2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_allNetworkLocations = list3.toArray(EMPTY_NETWORK_LOCATION_ARRAY);
            Arrays.sort(this.m_allNetworkLocations, new NetworkLocationComparatorByName(null));
            this.m_defaultNetworkLocations = DfAllNetworkLocations.getDefaultNetworkLocationsImpl(this.m_allNetworkLocations);
            this.m_networkLocationMap = DfAllNetworkLocations.getNetworkLocationMapImpl(this.m_allNetworkLocations);
            this.m_defaultNetworkLocationsToString = DfAllNetworkLocations.networkLocationArrayToString(this.m_defaultNetworkLocations);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, list2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, list2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static IDfNetworkLocationEntry[] getDefaultNetworkLocationsImpl(IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray) {
        IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray2 = iDfNetworkLocationEntryArray;
        JoinPoint joinPoint = null;
        try {
            IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray3;
            IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray4;
            IDfNetworkLocationEntry[] array;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ArrayList<IDfNetworkLocationEntry> list = new ArrayList<IDfNetworkLocationEntry>(array.length);
            for (IDfNetworkLocationEntry networkLocationEntry : array) {
                if (!networkLocationEntry.isDefault()) continue;
                list.add(networkLocationEntry);
            }
            IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray5 = iDfNetworkLocationEntryArray4 = (iDfNetworkLocationEntryArray3 = list.toArray(EMPTY_I_NETWORK_LOCATION_ARRAY));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfNetworkLocationEntryArray4, joinPoint);
            }
            return iDfNetworkLocationEntryArray3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Map<String, IDfNetworkLocationEntry> getNetworkLocationMapImpl(IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray) {
        IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray2 = iDfNetworkLocationEntryArray;
        JoinPoint joinPoint = null;
        try {
            HashMap<String, IDfNetworkLocationEntry> hashMap;
            HashMap<String, IDfNetworkLocationEntry> hashMap2;
            IDfNetworkLocationEntry[] array;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            HashMap<String, IDfNetworkLocationEntry> map = new HashMap<String, IDfNetworkLocationEntry>(array.length);
            for (IDfNetworkLocationEntry networkLocationEntry : array) {
                map.put(networkLocationEntry.getId(), networkLocationEntry);
            }
            HashMap<String, IDfNetworkLocationEntry> hashMap3 = hashMap2 = (hashMap = map);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(hashMap2, joinPoint);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static String networkLocationArrayToString(IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray) {
        IDfNetworkLocationEntry[] iDfNetworkLocationEntryArray2 = iDfNetworkLocationEntryArray;
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            IDfNetworkLocationEntry[] array;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int size = array.length;
            StringBuffer sb = new StringBuffer(array.length * 25);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                IDfNetworkLocationEntry networkLocation = array[i];
                sb.append("id=").append(networkLocation.getId()).append(" name=").append(networkLocation.getName());
            }
            String string3 = string2 = (string = sb.toString());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)iDfNetworkLocationEntryArray2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasIPRangeAttr(ISession iSession) throws DfException {
        ISession iSession2 = iSession;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            void session;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)iSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (session.getLiteType("dm_network_location_map").hasAttr(IP_ADDR_RANGE)) {
                this.m_hasIPRange = true;
            }
            boolean bl3 = bl2 = (bl = this.m_hasIPRange);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)iSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)iSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfAllNetworkLocations.java", Class.forName("com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "getInstance", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "java.util.List:", "array:", "", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "getInstance", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "com.documentum.fc.client.IDfSession:", "session:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations"), 47);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "set", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "java.util.List:", "list:", "", "void"), 182);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getDefaultNetworkLocationsImpl", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "[Lcom.documentum.fc.client.IDfNetworkLocationEntry;:", "array:", "", "[Lcom.documentum.fc.client.IDfNetworkLocationEntry;"), 191);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getNetworkLocationMapImpl", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "[Lcom.documentum.fc.client.IDfNetworkLocationEntry;:", "array:", "", "java.util.Map"), 204);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "networkLocationArrayToString", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "[Lcom.documentum.fc.client.IDfNetworkLocationEntry;:", "array:", "", "java.lang.String"), 214);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "hasIPRangeAttr", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "com.documentum.fc.client.impl.session.ISession:", "session:", "com.documentum.fc.common.DfException:", "boolean"), 231);
        ajc$tjp_15 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "", "", ""), 268);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getLocationById", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "java.lang.String:", "networkLocationId:", "", "com.documentum.fc.client.IDfNetworkLocationEntry"), 61);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getNetworkLocations", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "java.lang.String:", "ipAddress:", "", "java.util.List"), 68);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getAllNetworkLocations", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "", "", "", "java.util.Enumeration"), 88);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getAllNetworkLocationsAsList", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "", "", "", "java.util.List"), 93);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getDefaultNetworkLocations", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "", "", "", "java.util.Enumeration"), 98);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getDefaultNetworkLocationsToString", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "", "", "", "java.lang.String"), 103);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "load", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "com.documentum.fc.client.IDfSession:", "session:", "com.documentum.fc.common.DfException:", "void"), 112);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "process", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations", "com.documentum.fc.client.IDfCollection:", "collection:", "com.documentum.fc.common.DfException:", "java.util.List"), 132);
        EMPTY_NETWORK_LOCATION_ARRAY = new DfNetworkLocationEntry[0];
        EMPTY_I_NETWORK_LOCATION_ARRAY = new IDfNetworkLocationEntry[0];
        QUERY_STRING_BASIC_ATTRS = "SELECT " + R_OBJECT_ID + "," + NETLOC_IDENT + "," + NETLOC_DISPLAY_NAME + "," + DEFAULT_NETLOC + "," + BEGIN_NEAR_IP_ADDRESS + "," + END_NEAR_IP_ADDRESS;
        FROM_CLAUSE = " FROM dm_network_location_map WHERE FOLDER('/System/NetworkLocation')" + ORDER_BY_STRING;
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NetworkLocationComparatorByName
    implements Comparator<IDfNetworkLocationEntry> {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private NetworkLocationComparatorByName() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(IDfNetworkLocationEntry iDfNetworkLocationEntry, IDfNetworkLocationEntry iDfNetworkLocationEntry2) {
            IDfNetworkLocationEntry iDfNetworkLocationEntry3 = iDfNetworkLocationEntry;
            IDfNetworkLocationEntry iDfNetworkLocationEntry4 = iDfNetworkLocationEntry2;
            JoinPoint joinPoint = null;
            try {
                void object2;
                void object;
                int n;
                int n2;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfNetworkLocationEntry3, (Object)iDfNetworkLocationEntry4);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                int n3 = n2 = (n = object.getName().compareTo(object2.getName()));
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    Object object3 = Conversions.intObject((int)n2);
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfNetworkLocationEntry3, (Object)iDfNetworkLocationEntry4);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object3, joinPoint);
                }
                return n;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDfNetworkLocationEntry3, (Object)iDfNetworkLocationEntry4);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /* synthetic */ NetworkLocationComparatorByName(1 x0) {
            NetworkLocationComparatorByName networkLocationComparatorByName = this;
            1 var4_3 = x0;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("DfAllNetworkLocations.java", Class.forName("com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations$NetworkLocationComparatorByName"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compare", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations$NetworkLocationComparatorByName", "com.documentum.fc.client.IDfNetworkLocationEntry:com.documentum.fc.client.IDfNetworkLocationEntry:", "object:object2:", "", "int"), 240);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations$NetworkLocationComparatorByName", "", "", ""), 236);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations$NetworkLocationComparatorByName", "com.documentum.fc.client.acs.impl.common.config.cache.location.DfAllNetworkLocations$1:", "x0:", ""), 236);
        }
    }
}

