/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.acs.impl.common.config.cache.common;

import com.documentum.fc.client.acs.impl.AcsGlobalRegistryImpl;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfInterProcessLockFactory;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfInterProcessLock;
import com.documentum.fc.common.impl.FileSystemCacheNamespaceManager;
import com.documentum.fc.impl.security.action.GetResourceAsStreamAction;
import com.documentum.fc.internal.xml.IXMLParserFactory;
import com.documentum.fc.internal.xml.IXMLSerializer;
import com.documentum.fc.internal.xml.XMLUtilsFactory;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import javax.xml.parsers.DocumentBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IOHandler {
    private IDfInterProcessLock m_lock;
    private long m_lastModified;
    private long m_lastSize;
    private File m_xmlFile;
    private String m_lockFilePath;
    private final String m_schemaLocation;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    /*
     * WARNING - void declaration
     */
    public static IOHandler getInstance(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            IOHandler iOHandler;
            IOHandler iOHandler2;
            void packageName;
            String prefix;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String contentFileName = prefix + ".xml";
            String contentLockFileName = prefix + ".lck";
            String schemaLocation = (String)packageName + prefix + ".xsd";
            String docbaseName = AcsGlobalRegistryImpl.getInstance().getDocbaseName();
            File docbaseDir = FileSystemCacheNamespaceManager.getCacheNamespaceForAcs().getDocbaseRoot(docbaseName);
            IOHandler iOHandler3 = iOHandler2 = (iOHandler = new IOHandler(docbaseDir, contentFileName, contentLockFileName, schemaLocation));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iOHandler2, joinPoint);
            }
            return iOHandler;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private IOHandler(File dir, String contentFileName, String contentLockFileName, String schemaLocation) {
        this.m_schemaLocation = schemaLocation;
        if (!dir.exists() && !dir.mkdirs()) {
            DfLogger.warn((Object)this, "Unable to create directory '" + dir.getAbsolutePath() + "'", null, null);
        }
        this.m_xmlFile = new File(dir, contentFileName);
        this.m_lockFilePath = dir.getAbsolutePath() + File.separator + contentLockFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document load() throws DfException {
        JoinPoint joinPoint = null;
        try {
            Document document;
            Document document2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Document document3 = null;
            if (!this.m_xmlFile.exists() || this.m_xmlFile.length() == 0L) {
                this.m_lastModified = 0L;
                this.m_lastSize = 0L;
            } else if (this.m_lastModified != this.m_xmlFile.lastModified() || this.m_lastSize != this.m_xmlFile.length()) {
                try {
                    this.acquireLock();
                    this.m_lastModified = this.m_xmlFile.lastModified();
                    this.m_lastSize = this.m_xmlFile.length();
                    document3 = this.loadImpl();
                }
                finally {
                    this.releaseLock();
                }
            }
            Document document4 = document2 = (document = document3);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(document2, joinPoint);
            }
            return document;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Document loadImpl() {
        JoinPoint joinPoint = null;
        try {
            Document document;
            Document document2;
            boolean isFileCorrupted;
            Document document3;
            block16: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                document3 = null;
                FileInputStream inputStream = null;
                isFileCorrupted = false;
                try {
                    IXMLParserFactory factory = new XMLUtilsFactory().getParserFactory();
                    DocumentBuilder parser = factory.getDOMParser(true);
                    parser.setErrorHandler(new CacheContentErrorHandler(null));
                    parser.setEntityResolver(new CacheSchemaEntityResolver(this.m_schemaLocation));
                    inputStream = new FileInputStream(this.m_xmlFile);
                    document3 = parser.parse(inputStream);
                    this.close(inputStream);
                }
                catch (SAXException e) {
                    isFileCorrupted = true;
                }
                catch (IOException e2) {
                    isFileCorrupted = true;
                    DfLogger.warn((Object)this, "DFC_ACS_IO_EXCEPTION", null, (Throwable)e2);
                    break block16;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.close(inputStream);
                }
            }
            if (isFileCorrupted) {
                this.deleteFile();
            }
            Document document4 = document2 = (document = document3);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(document2, joinPoint);
            }
            return document;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void serialize(Document document) throws DfException {
        Document document2 = document;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)document2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                void document3;
                this.acquireLock();
                this.serializeDocument((Document)document3);
            }
            finally {
                this.releaseLock();
            }
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)document2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)document2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void serializeDocument(Document document) throws DfException {
        Document document2 = document;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)document2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            FileOutputStream outputStream = null;
            IOException ioe = null;
            try {
                void document3;
                outputStream = new FileOutputStream(this.m_xmlFile);
                IXMLSerializer serializer = new XMLUtilsFactory().getXMLSerializer();
                serializer.setOutputStream(outputStream);
                serializer.serialize((Document)document3);
                this.m_lastModified = this.m_xmlFile.lastModified();
                this.m_lastSize = this.m_xmlFile.length();
                this.close(outputStream);
            }
            catch (IOException e) {
                try {
                    ioe = e;
                    this.close(outputStream);
                }
                catch (Throwable throwable) {
                    this.close(outputStream);
                    throw throwable;
                }
            }
            if (ioe != null) {
                this.deleteFile();
                throw new DfException(ioe);
            }
            Object var8_9 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)document2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var8_9, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)document2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void deleteFile() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                if (this.m_xmlFile.delete()) {
                    this.m_lastModified = 0L;
                    this.m_lastSize = 0L;
                } else {
                    this.m_lastModified = this.m_xmlFile.lastModified();
                    this.m_lastSize = this.m_xmlFile.length();
                }
            }
            catch (Exception e) {
                DfLogger.warn((Object)this, "Can not delete file '{0}'", new String[]{this.m_xmlFile.getAbsolutePath()}, (Throwable)e);
            }
            Object var3_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var3_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void close(OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)outputStream2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                void outputStream3;
                if (outputStream3 != null) {
                    outputStream3.close();
                }
            }
            catch (IOException e) {
                DfLogger.warn((Object)this, "DFC_ACS_IO_EXCEPTION", null, (Throwable)e);
            }
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)outputStream2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)outputStream2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void close(InputStream inputStream) {
        InputStream inputStream2 = inputStream;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)inputStream2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                void inputStream3;
                if (inputStream3 != null) {
                    inputStream3.close();
                }
            }
            catch (IOException e) {
                DfLogger.warn((Object)this, "DFC_ACS_IO_EXCEPTION", null, (Throwable)e);
            }
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)inputStream2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)inputStream2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void acquireLock() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_lock == null) {
                this.m_lock = DfInterProcessLockFactory.getInstance().getNewLock(this.m_lockFilePath);
            }
            if (this.m_lock.getLockCount() == 0) {
                this.m_lock.acquire();
            }
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void releaseLock() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_lock != null && this.m_lock.getLockCount() == 1) {
                this.m_lock.release();
            }
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("IOHandler.java", Class.forName("com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getInstance", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "java.lang.String:java.lang.String:", "prefix:packageName:", "", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "load", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "", "", "com.documentum.fc.common.DfException:", "org.w3c.dom.Document"), 72);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadImpl", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "", "", "", "org.w3c.dom.Document"), 106);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "serialize", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "org.w3c.dom.Document:", "document:", "com.documentum.fc.common.DfException:", "void"), 152);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "serializeDocument", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "org.w3c.dom.Document:", "document:", "com.documentum.fc.common.DfException:", "void"), 170);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteFile", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "", "", "", "void"), 204);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "close", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "java.io.OutputStream:", "outputStream:", "", "void"), 225);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "close", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "java.io.InputStream:", "inputStream:", "", "void"), 240);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "acquireLock", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "", "", "com.documentum.fc.common.DfException:", "void"), 256);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "releaseLock", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler", "", "", "", "void"), 271);
    }

    static class 1 {
    }

    private static class CacheContentErrorHandler
    implements ErrorHandler {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

        private CacheContentErrorHandler() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void error(SAXParseException sAXParseException) throws SAXException {
            SAXParseException sAXParseException2 = sAXParseException;
            JoinPoint joinPoint = null;
            try {
                void exception;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.handleError((SAXParseException)exception);
                Object var4_4 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            SAXParseException sAXParseException2 = sAXParseException;
            JoinPoint joinPoint = null;
            try {
                void exception;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.handleError((SAXParseException)exception);
                Object var4_4 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void warning(SAXParseException sAXParseException) throws SAXException {
            SAXParseException sAXParseException2 = sAXParseException;
            JoinPoint joinPoint = null;
            try {
                void exception;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.handleError((SAXParseException)exception);
                Object var4_4 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleError(SAXParseException sAXParseException) throws SAXException {
            SAXParseException sAXParseException2 = sAXParseException;
            JoinPoint joinPoint = null;
            try {
                void exception;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                DfLogger.warn((Object)this, "Unable to parse cache content file, system will abandon old file", null, (Throwable)exception);
                throw new SAXException((Exception)exception);
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)sAXParseException2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /* synthetic */ CacheContentErrorHandler(1 x0) {
            CacheContentErrorHandler cacheContentErrorHandler = this;
            1 var4_3 = x0;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("IOHandler.java", Class.forName("com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheContentErrorHandler"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "error", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheContentErrorHandler", "org.xml.sax.SAXParseException:", "exception:", "org.xml.sax.SAXException:", "void"), 312);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "fatalError", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheContentErrorHandler", "org.xml.sax.SAXParseException:", "exception:", "org.xml.sax.SAXException:", "void"), 318);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "warning", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheContentErrorHandler", "org.xml.sax.SAXParseException:", "exception:", "org.xml.sax.SAXException:", "void"), 323);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleError", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheContentErrorHandler", "org.xml.sax.SAXParseException:", "exception:", "org.xml.sax.SAXException:", "void"), 329);
            ajc$tjp_4 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheContentErrorHandler", "", "", ""), 308);
            ajc$tjp_5 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheContentErrorHandler", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$1:", "x0:", ""), 308);
        }
    }

    private static class CacheSchemaEntityResolver
    implements EntityResolver {
        private final String m_schemaLocation;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public CacheSchemaEntityResolver(String schmaLocation) {
            String string = schmaLocation;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_schemaLocation = schmaLocation;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            String string3 = string;
            String string4 = string2;
            JoinPoint joinPoint = null;
            try {
                InputSource inputSource;
                InputSource inputSource2;
                InputStream in;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if ((in = AccessController.doPrivileged(new GetResourceAsStreamAction(this.getClass().getClassLoader(), this.m_schemaLocation))) == null) {
                    DfLogger.error((Object)this, "Unable to locate schema file '" + this.m_schemaLocation + "' in the classpath.", null, null);
                    throw new IOException("Unable to find schema file at " + this.m_schemaLocation);
                }
                InputSource inputSource3 = inputSource2 = (inputSource = new InputSource(in));
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(inputSource2, joinPoint);
                }
                return inputSource;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("IOHandler.java", Class.forName("com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheSchemaEntityResolver"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveEntity", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheSchemaEntityResolver", "java.lang.String:java.lang.String:", "publicId:systemId:", "org.xml.sax.SAXException:java.io.IOException:", "org.xml.sax.InputSource"), 296);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.acs.impl.common.config.cache.common.IOHandler$CacheSchemaEntityResolver", "java.lang.String:", "schmaLocation:", ""), 290);
        }
    }
}

