/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client;

import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.client.impl.typeddata.NoSuchAttributeException;
import com.documentum.fc.client.impl.typeddata.ValueIndexException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.impl.documentation.Visibility;
import com.documentum.fc.common.impl.documentation.VisibilityType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@Visibility(visibility=VisibilityType.PUBLIC)
public class DfTypedObjectException
extends DfException {
    private transient IDfTypedObject m_typedObject;
    private final String m_id;

    public static DfTypedObjectException newBadAttrIndexException(IDfTypedObject object, String name, int valueIndex) {
        return new DfTypedObjectException("DM_API_E_BADATTRINDX", object, new Object[]{name, Integer.toString(valueIndex)});
    }

    public static DfTypedObjectException newBadAttrIndexException(IDfTypedObject object, ValueIndexException e) {
        DfTypedObjectException result = DfTypedObjectException.newBadAttrIndexException(object, e.getAttributeName(), e.getValueIndex());
        result.setStackTrace(e.getStackTrace());
        return result;
    }

    public static DfTypedObjectException newBadAttrNameException(IDfTypedObject object, String name) {
        return new DfTypedObjectException("DM_API_E_BADATTRNAME", object, new Object[]{name});
    }

    public static DfTypedObjectException newBadAttrNameException(IDfTypedObject object, NoSuchAttributeException e) {
        DfTypedObjectException result = DfTypedObjectException.newBadAttrNameException(object, e.getAttributeName());
        result.setStackTrace(e.getStackTrace());
        return result;
    }

    protected DfTypedObjectException(String message, IDfTypedObject object, Object[] arguments) {
        this(message, object, arguments, null);
    }

    protected DfTypedObjectException(String message, IDfTypedObject object, Object[] arguments, Throwable cause) {
        super(message, arguments, cause);
        if (object == null) {
            throw new IllegalArgumentException("null object not allowed");
        }
        this.m_typedObject = object;
        IDfId objectId = null;
        try {
            objectId = object.getObjectId();
        }
        catch (DfException dfe) {
            objectId = DfId.DF_NULLID;
            DfLogger.warn((Object)this, "DFC_CORE_EXCEPTION_IGNORED", null, (Throwable)dfe);
        }
        this.m_id = objectId.getId();
    }

    protected static IDfId getObjectId(IDfTypedObject object) {
        try {
            return object.getObjectId();
        }
        catch (DfException e) {
            DfLogger.warn(DfTypedObjectException.class, "Failed to obtain object ID for exception", null, (Throwable)e);
            return DfId.DF_NULLID;
        }
    }

    @Deprecated
    public IDfTypedObject getTypedObject() {
        if (this.m_typedObject == null) {
            throw new IllegalStateException("Typed object not available for unserialized values.");
        }
        return this.m_typedObject;
    }

    public IDfId getObjectId() {
        return new DfId(this.m_id);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.m_typedObject = null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }
}

