/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client;

import com.documentum.fc.client.DfTypedObjectException;
import com.documentum.fc.client.IDfSysObject;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.impl.util.StringUtil;

public class DfSysObjectException
extends DfTypedObjectException {
    protected DfSysObjectException(String message, IDfSysObject object, Object[] arguments) {
        super(message, object, arguments);
    }

    protected DfSysObjectException(String message, IDfSysObject object, Object[] arguments, Throwable cause) {
        super(message, object, arguments, cause);
    }

    public static DfSysObjectException newBadFormat(IDfSysObject object, String formatName) {
        return new DfSysObjectException("DM_CONTENT_E_BAD_FORMAT", object, new Object[]{formatName});
    }

    public static DfSysObjectException newCantAccessException(IDfSysObject object, String path, Throwable cause) {
        return new DfSysObjectException("DM_SYSOBJECT_E_CANT_ACCESS", object, new Object[]{path}, cause);
    }

    public static DfSysObjectException newNoContentTypeSpecifiedException(IDfSysObject object) {
        return new DfSysObjectException("DM_SYSOBJECT_E_NO_CONTENT_TYPE", object, new Object[]{DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newInvalidPageNumberException(IDfSysObject object, int page) {
        return new DfSysObjectException("DM_SYSOBJECT_E_INVALID_PAGE_NUM", object, new Object[]{page, DfSysObjectException.getObjectName(object), DfSysObjectException.getPageCount(object)});
    }

    public static DfSysObjectException newRenditionFormatSameAs(IDfSysObject object) {
        return new DfSysObjectException("DM_SYSOBJECT_E_RENDITION_FMT_SAMEAS", object, new Object[]{DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newNotRetentionEnabledException(IDfSysObject object, String storeName) {
        return new DfSysObjectException("DM_SYSOBJECT_E_STORE_NOT_RETENTION_ENABLED", object, new Object[]{storeName});
    }

    public static DfSysObjectException newImproperStateException(IDfSysObject object) {
        return new DfSysObjectException("DM_SYSOBJECT_E_IMPROPER_STATE", object, new Object[]{DfSysObjectException.getObjectId(object)});
    }

    public static DfSysObjectException newRetainerAlreadyAttachedException(IDfSysObject object, IDfId retainerId) {
        return new DfSysObjectException("DM_SYSOBJECT_E_RETAINER_ALREADY_ATTACHED", object, new Object[]{DfSysObjectException.getObjectName(object), retainerId});
    }

    public static DfSysObjectException newRetainerNotAttachedException(IDfSysObject object, IDfId retainerId) {
        return new DfSysObjectException("DM_SYSOBJECT_E_RETAINER_NOT_ATTACHED", object, new Object[]{DfSysObjectException.getObjectName(object), retainerId});
    }

    public static DfSysObjectException alreadyCallSwapRetainerException(IDfSysObject object, IDfId oldRetainerId, IDfId newRetainerId) {
        return new DfSysObjectException("DFC_SYSOBJECT_SWAP_RETAINER_ALREADY_CALLED", object, new Object[]{DfSysObjectException.getObjectName(object), oldRetainerId, newRetainerId});
    }

    public static DfSysObjectException newNotSupportedException(IDfSysObject object, String operationName) {
        return new DfSysObjectException("DM_SYSOBJECT_E_NOT_SUPPORTED", object, new Object[]{operationName});
    }

    public static DfSysObjectException newInvalidSourceException(IDfSysObject object, String aclTypeName) {
        return new DfSysObjectException("DM_SYSOBJECT_E_INVALID_SOURCE", object, new Object[]{aclTypeName, DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newCantHaveContentException(IDfSysObject object) {
        return new DfSysObjectException("DFC_SYSOBJECT_CANT_HAVE_CONTENT", object, new Object[]{DfSysObjectException.getObjectName(object), DfSysObjectException.getTypeName(object)});
    }

    public static DfSysObjectException newAlreadyLinkedException(IDfSysObject object, String folderSpec) {
        return new DfSysObjectException("DM_SYSOBJECT_E_ALREADY_LINKED", object, new Object[]{DfSysObjectException.getObjectName(object), folderSpec});
    }

    public static DfSysObjectException newInvalidTypeForOperationException(IDfSysObject object, String operationName) {
        return new DfSysObjectException("DM_SYSOBJECT_E_INVALID_TYPE_FOR_OPERATION", object, new Object[]{operationName, DfSysObjectException.getObjectName(object), DfSysObjectException.getTypeName(object)});
    }

    public static DfSysObjectException newCircularLinkException(IDfSysObject object) {
        return new DfSysObjectException("DM_FOLDER_E_CIRC_LINK", object, new Object[]{DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newNotLinkedException(IDfSysObject object, String folderSpec) {
        return new DfSysObjectException("DM_SYSOBJECT_E_NOT_LINKED", object, new Object[]{DfSysObjectException.getObjectName(object), folderSpec});
    }

    public static DfSysObjectException newObjectNotCheckedOutException(IDfSysObject object, String operationName) {
        return new DfSysObjectException("DM_SYSOBJECT_E_OBJECT_NOT_CHECKEDOUT", object, new Object[]{DfSysObjectException.getObjectName(object), operationName});
    }

    public static DfSysObjectException newCantCheckoutNewException(IDfSysObject object) {
        return new DfSysObjectException("DM_SYSOBJECT_E_CANT_CHECKOUTNEW", object, new Object[]{DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newNotCheckedOutException(IDfSysObject object) {
        return new DfSysObjectException("DM_SYSOBJECT_E_NOT_CHECKEDOUT", object, new Object[]{DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newCantVersionLockedException(IDfSysObject object, String lockOwner) {
        return new DfSysObjectException("DM_SYSOBJECT_E_CANT_VERSION_LOCKED", object, new Object[]{DfSysObjectException.getObjectName(object), lockOwner});
    }

    public static DfSysObjectException newInternalLabelException(IDfSysObject object, String label) {
        return new DfSysObjectException("DM_SYSOBJECT_E_FIXED_ILABELS", object, new Object[]{label});
    }

    public static DfSysObjectException newCantDropLabelException(IDfSysObject object, String label) {
        return new DfSysObjectException("DM_SYSOBJECT_E_CANT_DROP_LABEL", object, new Object[]{label});
    }

    public static DfSysObjectException newNoSuchLabelException(IDfSysObject object, String label) {
        return new DfSysObjectException("DM_SYSOBJECT_E_NONEXISTENT_LABEL", object, new Object[]{label, DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newMustHaveNameException(IDfSysObject object, String objectTypeDescription) {
        return new DfSysObjectException("DM_SYSOBJECT_E_MUST_HAVE_NAME", object, new Object[]{objectTypeDescription});
    }

    public static DfSysObjectException newCantAccessFileException(IDfSysObject object, String fileName) {
        return new DfSysObjectException("DM_SYSOBJECT_E_CANT_ACCESS_FILE", object, new Object[]{fileName});
    }

    public static DfSysObjectException newNoFileException(IDfSysObject object, String command) {
        return new DfSysObjectException("DM_API_E_NO_FILE", object, new Object[]{command});
    }

    public static DfSysObjectException newNewSaveNewException(IDfSysObject object) {
        return new DfSysObjectException("DM_SYSOBJECT_E_NEW_SAVENEW", object, new Object[0]);
    }

    public static DfSysObjectException newParentNotLockedException(IDfSysObject object, String operationName) {
        return new DfSysObjectException("DFC_VDM_PARENT_NOT_LOCKED", object, new Object[]{DfSysObjectException.getObjectName(object), operationName});
    }

    public static DfSysObjectException newAssemblyParentLockedException(IDfSysObject object, String operationName) {
        return new DfSysObjectException("DFC_VDM_ASSEMBLY_DOCUMENT_LOCKED", object, new Object[]{DfSysObjectException.getObjectName(object), operationName});
    }

    public static DfSysObjectException newMigrateContentFailed(IDfSysObject object, String serverMessage) {
        return new DfSysObjectException("DFC_SYSOBJECT_MIGRATE_CONTENT_FAILED", object, new Object[]{serverMessage});
    }

    public static DfSysObjectException newCausesCycleException(IDfSysObject object, String childObjectName) {
        return new DfSysObjectException("DFC_VDM_CHILD_CAUSES_CYCLE", object, new Object[]{DfSysObjectException.getObjectName(object), childObjectName});
    }

    public static DfSysObjectException newCompoundDocumentEditException(IDfSysObject object) {
        return new DfSysObjectException("DFC_VDM_CANNOT_EDIT_COMPOUND_DOCUMENT", object, new Object[]{DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newSaveASNewStoreMismatchException(IDfSysObject object, String sourceDocbaseName, String targetDocbaseName, String storeName) {
        return new DfSysObjectException("DFC_SYSOBJECT_SAVEASNEW_STORE_MISMATCH", object, new Object[]{DfSysObjectException.getObjectName(object), sourceDocbaseName, targetDocbaseName, storeName});
    }

    public static DfSysObjectException newBindFileOfReplicaSourceUnsupported(IDfSysObject object, IDfId sourceId) {
        return new DfSysObjectException("DFC_SYSOBJECT_BIND_FILE_OF_REPLICA_SOURCE_UNSUPPORTED", object, new Object[]{DfSysObjectException.getObjectName(object), sourceId});
    }

    public static DfSysObjectException newCantRemoveRendition(IDfSysObject object, int page, String format) {
        return new DfSysObjectException("DM_SYSOBJECT_E_CANT_REMOVE_RENDITION", object, new Object[]{new Integer(page), format, DfSysObjectException.getObjectName(object)});
    }

    public static DfSysObjectException newCantRemoveRendition2(IDfSysObject object, int page) {
        return new DfSysObjectException("DM_SYSOBJECT_E_CANT_REMOVE_RENDITION2", object, new Object[]{new Integer(page), DfSysObjectException.getObjectName(object)});
    }

    protected static String getObjectName(IDfSysObject object) {
        try {
            String objectStr = object.getObjectName();
            if (StringUtil.isEmptyOrNull(objectStr)) {
                objectStr = object.getObjectId().getId();
            }
            return objectStr;
        }
        catch (DfException e) {
            DfLogger.warn(DfTypedObjectException.class, "Failed to obtain object name/id for exception", null, (Throwable)e);
            return "";
        }
    }

    protected static String getTypeName(IDfSysObject object) {
        try {
            return object.getTypeName();
        }
        catch (DfException e) {
            DfLogger.warn(DfTypedObjectException.class, "Failed to obtain type name for exception", null, (Throwable)e);
            return "<unknown>";
        }
    }

    private static int getPageCount(IDfSysObject object) {
        try {
            return object.getPageCount();
        }
        catch (DfException e) {
            DfLogger.warn(DfTypedObjectException.class, "Failed to obtain page count for exception", null, (Throwable)e);
            return 0;
        }
    }

    @Deprecated
    public IDfSysObject getSysObject() {
        return (IDfSysObject)this.getTypedObject();
    }
}

