/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client;

import com.documentum.fc.common.DfException;
import com.documentum.fc.common.impl.MessageHelper;
import com.documentum.fc.common.impl.documentation.Visibility;
import com.documentum.fc.common.impl.documentation.VisibilityType;
import java.util.PropertyResourceBundle;

@Visibility(visibility=VisibilityType.PUBLIC)
public class DfServiceException
extends DfException {
    public static final int DM_VEL_ERROR = 6400;
    public static final int DM_VEL_SERVICE_NOT_FOUND = 6401;
    public static final int DM_VEL_INSTANTIATION_ERROR = 6402;
    public static final int DM_VEL_DBOR_IO_ERROR = 6403;
    public static final int DM_VEL_PRINCIPAL_ERROR = 6404;
    public static final int DM_VEL_CANNOT_AUTHENTICATE = 6405;
    public static final int DM_VEL_IDENTITY_ERROR = 6406;
    public static final int DM_VEL_DBOR_NOT_FOUND = 6407;

    public static DfServiceException newDuplicateIdentityException(String docbaseName, String userName) {
        return new DfServiceException("DFC_SESSION_DUPLICATE_IDENTITY", new Object[]{docbaseName, userName});
    }

    public static DfServiceException convertToServiceException(Exception e) {
        if (e instanceof DfServiceException) {
            return (DfServiceException)e;
        }
        if (e instanceof DfException && ((DfException)e).getMessageId() != null) {
            return new DfServiceException((DfException)e);
        }
        return new DfServiceException(e.getMessage(), (Throwable)e);
    }

    public static DfServiceException newNoDocbrokersException() {
        return new DfServiceException("DM_DOCBROKER_E_NO_DOCBROKERS");
    }

    public DfServiceException() {
    }

    public DfServiceException(Throwable cause) {
        super(cause);
    }

    private DfServiceException(DfException originalException) {
        super(originalException);
    }

    public DfServiceException(String message) {
        super(message);
    }

    public DfServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public DfServiceException(String message, Object[] arguments) {
        super(message, arguments);
    }

    public DfServiceException(String message, Object[] arguments, Throwable cause) {
        super(message, arguments, cause);
    }

    public DfServiceException(MessageHelper messageHelper) {
        super(messageHelper);
    }

    public DfServiceException(MessageHelper messageHelper, Throwable cause) {
        super(messageHelper, cause);
    }

    DfServiceException(int errorCode) {
        super(errorCode);
    }

    public DfServiceException(int errorCode, String message) {
        super(errorCode, message);
    }

    public DfServiceException(Object resource, String errorCode) {
        super(6400);
        String name = null;
        name = resource instanceof String ? (String)resource : (resource instanceof Class ? ((Class)resource).getName() : resource.getClass().getName());
        try {
            this.setMessage(PropertyResourceBundle.getBundle(name).getString(errorCode));
        }
        catch (Throwable t) {
            this.setMessage(errorCode);
        }
    }
}

