/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client;

import com.documentum.fc.client.DfServiceException;

public class DfDocbrokerException
extends DfServiceException {
    private String m_hostName;
    private int m_portNumber;

    public static DfDocbrokerException newRequestFailedException(String hostName, int portNumber, Throwable cause) {
        return new DfDocbrokerException("DFC_DOCBROKER_REQUEST_FAILED", hostName, portNumber, new Object[]{hostName, portNumber}, cause);
    }

    public static DfDocbrokerException newNoPrivilegeException(String docbase, String userName) {
        return new DfDocbrokerException("DFC_DOCBROKER_NO_PRIVILEGE", null, 0, new Object[]{docbase, userName}, null);
    }

    protected DfDocbrokerException(String messageId, String hostName, int portNumber, Object[] additionalArgs, Throwable cause) {
        super(messageId, DfDocbrokerException.createMessageArguments(hostName, portNumber, additionalArgs), cause);
        this.m_hostName = hostName;
        this.m_portNumber = portNumber;
    }

    private static Object[] createMessageArguments(String hostName, int portNumber, Object[] additionalArgs) {
        int additionalLength = additionalArgs != null ? additionalArgs.length : 0;
        Object[] arguments = new Object[2 + additionalLength];
        if (additionalLength > 0) {
            System.arraycopy(additionalArgs, 0, arguments, 2, additionalLength);
        }
        arguments[0] = hostName;
        arguments[1] = new Integer(portNumber);
        return arguments;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public int getPortNumber() {
        return this.m_portNumber;
    }
}

