/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client;

import com.documentum.fc.client.DfTypedObjectException;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.impl.util.StringUtil;

public class DfAttributeValueException
extends DfTypedObjectException {
    private final String m_attributeName;
    private final String m_value;

    public static DfAttributeValueException newBadAttrValueException(IDfTypedObject object, String attributeName, String value, IllegalArgumentException cause) {
        assert (cause != null);
        String messageBody = cause instanceof NumberFormatException ? cause.toString() : cause.getMessage();
        if (StringUtil.isEmptyOrNull(messageBody) || messageBody.equals(attributeName)) {
            messageBody = "Bad value \"" + value + "\" for attribute \"" + attributeName + "\"";
        }
        DfAttributeValueException result = new DfAttributeValueException("DFC_OBJECT_BADATTRVALUE", object, attributeName, value, new Object[]{messageBody});
        result.setStackTrace(cause.getStackTrace());
        return result;
    }

    protected DfAttributeValueException(String message, IDfTypedObject object, String attributeName, String value, Object[] arguments) {
        super(message, object, arguments);
        this.m_attributeName = attributeName;
        this.m_value = value;
    }

    protected DfAttributeValueException(String message, IDfTypedObject object, String attributeName, String value, Object[] arguments, Throwable cause) {
        super(message, object, arguments, cause);
        this.m_attributeName = attributeName;
        this.m_value = value;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public String getValue() {
        return this.m_value;
    }
}

