/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.djcb;

import com.documentum.djcb.InterfaceDepth;
import com.documentum.djcb.dfcstubs.GenericStub;
import com.documentum.fc.client.IDfModule;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.IBaseComBridgeObj;
import com.documentum.tracing.core.Parameter;
import com.documentum.tracing.tracer.DfTracer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ComJavaHelper {
    static final int s_IndexShift = 10;
    public static final String DJCB_CATEGORY = "djcb";

    public static int getMethodId(Object obj, String strName) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        int methodId = -1;
        for (int i = 0; i < methods.length; ++i) {
            if (!strName.equalsIgnoreCase(methods[i].getName())) continue;
            methodId = i + 10;
            break;
        }
        if (DfTracer.isEnabled()) {
            DfTracer.message(DJCB_CATEGORY, "getMethodId (" + clazz.getName() + "@" + Integer.toHexString(obj.hashCode()) + ", " + strName + ") " + methodId);
        }
        return methodId;
    }

    public static String getObjectClassName(Object obj) {
        return obj.getClass().getName();
    }

    public static Object invokeMethod(Object obj, int iMethodIndex, Object[] args) throws Throwable, IllegalAccessException, DfException {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        if (iMethodIndex == 0) {
            return ComJavaHelper.invokeToString(clazz, obj);
        }
        Method method = methods[iMethodIndex - 10];
        Throwable throwable = null;
        Object result = null;
        try {
            Class[] overloadParams;
            String methodName;
            Method[] overloaded;
            Method choice;
            if (DfTracer.isEnabled()) {
                int parCount = args == null ? 0 : args.length;
                Parameter[] aparameter = new Parameter[parCount];
                for (int i = 0; i < parCount; ++i) {
                    Object par = args[i];
                    aparameter[i] = new Parameter(par == null ? "<null>" : par.toString());
                }
                DfTracer.traceMethodEntrance(method.getName(), 1, aparameter, clazz, obj, method.getReturnType().getName());
            }
            if ((choice = ComJavaHelper.chooseMethod(overloaded = ComJavaHelper.findMethodsByName(methodName = method.getName(), methods), overloadParams = ComJavaHelper.getParamsClass(args))) == null) {
                throw new DfException("Requested method is not found");
            }
            try {
                result = choice.invoke(obj, args);
            }
            catch (IllegalAccessException e) {
                Method specialChoice = null;
                Class[] interfaces = ComJavaHelper.getAllInterfaces(new Class[]{clazz});
                if (interfaces != null) {
                    specialChoice = ComJavaHelper.matchInterfaceToMethod(interfaces, choice);
                } else {
                    for (Class<?> superclass = clazz.getSuperclass(); superclass != null && ((interfaces = ComJavaHelper.getAllInterfaces(new Class[]{superclass})) == null || (specialChoice = ComJavaHelper.matchInterfaceToMethod(interfaces, choice)) == null); superclass = superclass.getSuperclass()) {
                    }
                }
                if (interfaces == null) {
                    throw e;
                }
                if (specialChoice == null) {
                    throw e;
                }
                result = specialChoice.invoke(obj, args);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Throwable throwable1) {
            try {
                if (throwable1 instanceof InvocationTargetException) {
                    throw ((InvocationTargetException)throwable1).getTargetException();
                }
                throw throwable1;
            }
            catch (Throwable throwable2) {
                if (DfTracer.isEnabled()) {
                    DfTracer.traceMethodExit(method.getName(), 1, clazz, obj, throwable, result);
                }
                throw throwable2;
            }
        }
        if (DfTracer.isEnabled()) {
            DfTracer.traceMethodExit(method.getName(), 1, clazz, obj, throwable, result);
        }
        return result;
    }

    public static boolean isReturnedString(Object obj, int iMethodIndex, Object[] args) throws Throwable {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        if (iMethodIndex == 0) {
            return true;
        }
        Method method = methods[iMethodIndex - 10];
        Throwable throwable = null;
        Object result = null;
        try {
            Class[] overloadParams;
            String methodName;
            Method[] overloaded;
            Method choice;
            if (DfTracer.isEnabled()) {
                int parCount = args == null ? 0 : args.length;
                Parameter[] aparameter = new Parameter[parCount];
                for (int i = 0; i < parCount; ++i) {
                    Object par = args[i];
                    aparameter[i] = new Parameter(par == null ? "<null>" : par.toString());
                }
                DfTracer.traceMethodEntrance(method.getName(), 1, aparameter, clazz, obj, method.getReturnType().getName());
            }
            if ((choice = ComJavaHelper.chooseMethod(overloaded = ComJavaHelper.findMethodsByName(methodName = method.getName(), methods), overloadParams = ComJavaHelper.getParamsClass(args))) == null) {
                throw new DfException("Requested method is not found");
            }
            Class<?> retType = choice.getReturnType();
            String retClassName = retType.getName();
            boolean bl = retClassName.equals("java.lang.String");
            return bl;
        }
        catch (Throwable throwable1) {
            throwable = throwable1;
            if (throwable1 instanceof InvocationTargetException) {
                throw ((InvocationTargetException)throwable1).getTargetException();
            }
            if (throwable1 instanceof DfException) {
                throw (DfException)throwable1;
            }
            if (throwable1 instanceof Error) {
                throw (Error)throwable1;
            }
            throw (RuntimeException)throwable1;
        }
        finally {
            if (DfTracer.isEnabled()) {
                DfTracer.traceMethodExit(method.getName(), 1, clazz, obj, throwable, result);
            }
        }
    }

    private static Method matchInterfaceToMethod(Class[] interfaces, Method choice) {
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] existingMethods = interfaces[i].getMethods();
            for (int j = 0; j < existingMethods.length; ++j) {
                Class<?>[] origParams;
                Class<?>[] replacementParams;
                if (!existingMethods[j].getName().equals(choice.getName()) || (replacementParams = existingMethods[j].getParameterTypes()).length != (origParams = choice.getParameterTypes()).length) continue;
                boolean foundMethod = true;
                for (int k = 0; k < replacementParams.length; ++k) {
                    if (replacementParams[k].getName().equals(origParams[k].getName())) continue;
                    foundMethod = false;
                    break;
                }
                if (!foundMethod) continue;
                return existingMethods[j];
            }
        }
        return null;
    }

    private static Object invokeToString(Class clazz, Object obj) throws DfException {
        Throwable throwable = null;
        String result = null;
        try {
            Parameter[] aparameter;
            if (DfTracer.isEnabled()) {
                aparameter = new Parameter[]{};
                DfTracer.traceMethodEntrance("toString", 1, aparameter, clazz, obj, "String");
            }
            result = obj.toString();
            aparameter = result;
            return aparameter;
        }
        catch (Throwable throwable1) {
            throwable = throwable1;
            if (throwable1 instanceof DfException) {
                throw (DfException)throwable1;
            }
            if (throwable1 instanceof Error) {
                throw (Error)throwable1;
            }
            throw (RuntimeException)throwable1;
        }
        finally {
            if (DfTracer.isEnabled()) {
                DfTracer.traceMethodExit("toString", 1, clazz, obj, throwable, result);
            }
        }
    }

    private static Class[] getParamsClass(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        Class[] argsClass = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> instance;
            argsClass[i] = args[i] == null ? null : ((instance = args[i].getClass()).equals(Boolean.class) ? Boolean.TYPE : (instance.equals(Integer.class) ? Integer.TYPE : (instance.equals(Double.class) ? Double.TYPE : instance)));
        }
        return argsClass;
    }

    private static Method[] findMethodsByName(String methodName, Method[] allMethods) {
        Method[] tmpContainer = new Method[allMethods.length];
        int top = 0;
        for (int i = 0; i < allMethods.length; ++i) {
            if (!methodName.equals(allMethods[i].getName())) continue;
            tmpContainer[top++] = allMethods[i];
        }
        if (top == 0) {
            return null;
        }
        Method[] retMethods = new Method[top];
        for (int i = 0; i < top; ++i) {
            retMethods[i] = tmpContainer[i];
        }
        return retMethods;
    }

    private static Method chooseMethod(Method[] methods, Class[] args) throws DfException {
        if (methods == null || methods.length == 0) {
            return null;
        }
        if (methods.length == 1) {
            return methods[0];
        }
        Method[] tmpContainer = new Method[methods.length];
        int top = 0;
        if (args == null) {
            args = new Class[]{};
        }
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            tmpContainer[top++] = methods[i];
        }
        if (top < 1) {
            return null;
        }
        if (top == 1) {
            return tmpContainer[0];
        }
        int[][] scores = new int[top][args.length];
        int[] results = new int[top];
        int minValue = -1;
        int chosenIndex = -1;
        boolean duplicates = false;
        for (int i = 0; i < top; ++i) {
            results[i] = ComJavaHelper.calcScores(scores[i], tmpContainer[i].getParameterTypes(), args);
            if (results[i] == 0) {
                return tmpContainer[i];
            }
            if (results[i] == -1) continue;
            if (minValue == -1) {
                minValue = results[i];
                chosenIndex = i;
                continue;
            }
            if (minValue < results[i]) {
                minValue = results[i];
                chosenIndex = i;
                duplicates = false;
                continue;
            }
            if (minValue != results[i]) continue;
            duplicates = true;
        }
        if (chosenIndex == -1) {
            throw new DfException("Method not found");
        }
        if (duplicates) {
            throw new DfException("Ambiguous Method");
        }
        return tmpContainer[chosenIndex];
    }

    private static int calcScores(int[] scores, Class[] reqTypes, Class[] actualTypes) {
        boolean isUndefined = false;
        for (int i = 0; i < reqTypes.length; ++i) {
            if (actualTypes[i] == null) {
                if (reqTypes[i].equals(Boolean.TYPE) || reqTypes[i].equals(Integer.TYPE) || reqTypes[i].equals(Double.TYPE) || reqTypes[i].equals(Character.TYPE) || reqTypes[i].equals(Float.TYPE) || reqTypes[i].equals(Long.TYPE)) {
                    scores[i] = -1;
                    return -1;
                }
                scores[i] = 0;
                isUndefined = true;
                continue;
            }
            if (reqTypes[i].equals(actualTypes[i])) {
                scores[i] = 0;
                continue;
            }
            boolean isDerived = false;
            if (reqTypes[i].isInterface()) {
                Class[] foundInterfaces = ComJavaHelper.getAllInterfaces(actualTypes[i].getInterfaces());
                if (foundInterfaces == null || foundInterfaces.length == 0) {
                    scores[i] = -1;
                    return -1;
                }
                for (int j = 0; j < foundInterfaces.length; ++j) {
                    if (!foundInterfaces[j].equals(reqTypes[i])) continue;
                    scores[i] = j + 1;
                    isDerived = true;
                    break;
                }
                if (isDerived) continue;
                scores[i] = -1;
                return -1;
            }
            Class parent = actualTypes[i];
            int depth = 0;
            while ((parent = parent.getSuperclass()) != null) {
                ++depth;
                if (!parent.equals(reqTypes[i])) continue;
                scores[i] = depth;
                isDerived = true;
                break;
            }
            if (isDerived) continue;
            scores[i] = -1;
            return -1;
        }
        int summaryResult = 0;
        for (int i = 0; i < scores.length; ++i) {
            summaryResult += scores[i];
        }
        if (isUndefined) {
            summaryResult += 10;
        }
        return summaryResult;
    }

    private static Class[] getAllInterfaces(Class[] clazz) {
        Class[][] allInterfaces = new Class[clazz.length][];
        ArrayList<Class[]> list = new ArrayList<Class[]>();
        int summaryLength = 0;
        for (int i = 0; i < clazz.length; ++i) {
            Class[] additionalInterfaces;
            Class<?>[] interfs = clazz[i].getInterfaces();
            allInterfaces[i] = interfs;
            summaryLength += interfs.length;
            if (allInterfaces[i] == null || allInterfaces[i].length <= 0 || (additionalInterfaces = ComJavaHelper.getAllInterfaces(allInterfaces[i])) == null || additionalInterfaces.length <= 0) continue;
            list.add(additionalInterfaces);
            summaryLength += additionalInterfaces.length;
        }
        if (summaryLength == 0) {
            return null;
        }
        int index = 0;
        Class[] foundInterfaces = new Class[summaryLength];
        for (int i = 0; i < clazz.length; ++i) {
            for (int j = 0; j < allInterfaces[i].length; ++j) {
                foundInterfaces[index++] = allInterfaces[i][j];
            }
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Class[] children = (Class[])list.get(i);
            if (children == null) continue;
            for (int j = 0; j < children.length; ++j) {
                foundInterfaces[index++] = children[j];
            }
        }
        return foundInterfaces;
    }

    public static String[] getObjectInterface(Object obj) {
        return ComJavaHelper.getObjectInterface(obj.getClass());
    }

    public static String[] getObjectInterface(Class clazz) {
        Map checker = ComJavaHelper.getObjectInterfaceMap(clazz);
        int size = checker.size();
        if (size == 0) {
            return null;
        }
        Set keys = checker.keySet();
        LinkedList<InterfaceDepth> sortedList = new LinkedList<InterfaceDepth>();
        for (String interfName : keys) {
            int depth = (Integer)checker.get(interfName);
            int ind = interfName.lastIndexOf(46);
            String stripped = ind > 0 ? interfName.substring(ind + 1) : interfName;
            sortedList.add(new InterfaceDepth(depth, stripped));
        }
        Collections.sort(sortedList, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (((InterfaceDepth)o1).getDepth() > ((InterfaceDepth)o2).getDepth()) {
                    return 1;
                }
                if (((InterfaceDepth)o1).getDepth() == ((InterfaceDepth)o2).getDepth()) {
                    return 0;
                }
                return -1;
            }
        });
        String[] result = new String[size];
        int resultInd = 0;
        for (InterfaceDepth elem : sortedList) {
            result[resultInd++] = elem.getInterface();
        }
        return result;
    }

    public static String getMostDerivedInterfaceName(Object obj, String interfaceName) throws ClassNotFoundException {
        return ComJavaHelper.getMostDerivedInterfaceName(obj.getClass(), interfaceName);
    }

    public static String getMostDerivedInterfaceName(Class clazz, String interfaceName) throws ClassNotFoundException {
        Map checker = ComJavaHelper.getObjectInterfaceMap(clazz);
        for (Map.Entry entry : checker.entrySet()) {
            String currInterfaceName = (String)entry.getKey();
            int currInterfaceDepth = (Integer)entry.getValue();
            if (currInterfaceDepth != 0) continue;
            Class<?> currInterfaceClass = null;
            currInterfaceClass = Class.forName(currInterfaceName);
            if (!ComJavaHelper.isDerivedFromInterface(currInterfaceClass, interfaceName)) continue;
            return ComJavaHelper.getShortClassName(currInterfaceName);
        }
        return "";
    }

    private static boolean isDerivedFromInterface(Class childClass, String superInterfaceName) {
        HashMap currChecker = new HashMap(7);
        ComJavaHelper.processInterface(childClass, currChecker, 0);
        for (String s : currChecker.keySet()) {
            String interfacePart = ComJavaHelper.getShortClassName(s);
            if (!interfacePart.equals(superInterfaceName)) continue;
            return true;
        }
        return false;
    }

    private static String getShortClassName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return fullClassName.substring(index + 1);
    }

    private static Map getObjectInterfaceMap(Class clazz) {
        Class superclass;
        HashMap checker = new HashMap();
        Class<?>[] interf = clazz.getInterfaces();
        if (interf != null && interf.length > 0) {
            for (int i = 0; i < interf.length; ++i) {
                ComJavaHelper.processInterface(interf[i], checker, 0);
            }
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            ComJavaHelper.processSuperclass(superclass, checker, 0);
        }
        return checker;
    }

    private static void processInterface(Class interf, Map checker, int indexer) {
        if (checker.containsKey(interf.getName())) {
            return;
        }
        if (IDfTypedObject.class.isAssignableFrom(interf)) {
            checker.put(interf.getName(), new Integer(indexer - 10));
        } else if (IDfModule.class.isAssignableFrom(interf)) {
            checker.put(interf.getName(), new Integer(indexer + 10));
        } else {
            checker.put(interf.getName(), new Integer(indexer));
        }
        Class<?>[] children = interf.getInterfaces();
        if (children == null || children.length == 0) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (checker.containsKey(children[i].getName())) continue;
            ComJavaHelper.processInterface(children[i], checker, indexer + 1);
        }
    }

    private static void processSuperclass(Class superclass, Map checker, int indexer) {
        Class superSuperclass;
        Class<?>[] interf = superclass.getInterfaces();
        if (interf != null && interf.length > 0) {
            for (int i = 0; i < interf.length; ++i) {
                ComJavaHelper.processInterface(interf[i], checker, indexer);
            }
        }
        if ((superSuperclass = superclass.getSuperclass()) != null) {
            ComJavaHelper.processSuperclass(superSuperclass, checker, indexer);
        }
    }

    public static void verifyClassLoader() {
        Thread current = Thread.currentThread();
        if (current.getContextClassLoader() == null) {
            current.setContextClassLoader(ComJavaHelper.class.getClassLoader());
        }
    }

    public static final Object createComWrapper(int iComImp, String interfaceName) throws ClassNotFoundException {
        GenericStub handler = new GenericStub(iComImp);
        Class<?> selectedInterface = Class.forName(interfaceName);
        return Proxy.newProxyInstance(selectedInterface.getClassLoader(), new Class[]{selectedInterface, IBaseComBridgeObj.class}, (InvocationHandler)handler);
    }

    public static final Object saveObject(Object elem) {
        return elem;
    }
}

