/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.utils;

import com.ledger.lib.LedgerException;
import com.ledger.lib.SWException;
import com.ledger.lib.WrongApplicationException;
import com.ledger.lib.transport.LedgerDevice;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class ApduExchange {
    public static ApduResponse exchangeApdu(LedgerDevice device, byte[] apdu) throws LedgerException {
        return new ApduResponse(device.exchange(apdu));
    }

    public static ApduResponse exchangeApdu(LedgerDevice device, int cla, int ins, int p1, int p2) throws LedgerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(cla);
        out.write(ins);
        out.write(p1);
        out.write(p2);
        out.write(0);
        return ApduExchange.exchangeApdu(device, out.toByteArray());
    }

    public static ApduResponse exchangeApdu(LedgerDevice device, int cla, int ins, int p1, int p2, int length) throws LedgerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(cla);
        out.write(ins);
        out.write(p1);
        out.write(p2);
        out.write(length);
        return ApduExchange.exchangeApdu(device, out.toByteArray());
    }

    public static ApduResponse exchangeApdu(LedgerDevice device, int cla, int ins, int p1, int p2, byte[] data) throws LedgerException {
        if (data == null) {
            throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Data is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(cla);
        out.write(ins);
        out.write(p1);
        out.write(p2);
        out.write(data.length);
        out.write(data, 0, data.length);
        return ApduExchange.exchangeApdu(device, out.toByteArray());
    }

    public static class ApduResponse {
        private byte[] response;
        private int sw;

        ApduResponse(byte[] responseSW) {
            if (responseSW.length < 2) {
                throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Truncated response");
            }
            this.sw = (responseSW[responseSW.length - 2] & 0xFF) << 8 | responseSW[responseSW.length - 1] & 0xFF;
            this.response = Arrays.copyOfRange(responseSW, 0, responseSW.length);
        }

        public byte[] getResponse() {
            return this.response;
        }

        public int getSW() {
            return this.sw;
        }

        public void checkSW() throws LedgerException {
            if (this.sw != 36864) {
                switch (this.sw) {
                    case 27392: 
                    case 27904: 
                    case 28160: {
                        throw new WrongApplicationException();
                    }
                }
                throw new SWException(this.sw);
            }
        }

        public void checkSW(int[] acceptedSW) throws LedgerException {
            for (int SW2 : acceptedSW) {
                if (this.sw != SW2) continue;
                return;
            }
            throw new SWException(this.sw);
        }
    }
}

