/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.eth;

import com.ledger.lib.LedgerException;
import com.ledger.lib.apps.LedgerApplication;
import com.ledger.lib.apps.common.ECDSADeviceSignature;
import com.ledger.lib.apps.common.WalletAddress;
import com.ledger.lib.apps.eth.Erc20Cache;
import com.ledger.lib.transport.LedgerDevice;
import com.ledger.lib.utils.ApduExchange;
import com.ledger.lib.utils.BIP32Helper;
import com.ledger.lib.utils.SerializeHelper;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class Eth
extends LedgerApplication {
    private static final int ETH_CLA = 224;
    private static final int INS_GET_PUBLIC_ADDRESS = 2;
    private static final int INS_SIGN_TRANSACTION = 4;
    private static final int INS_GET_APPLICATION_CONFIGURATION = 6;
    private static final int INS_SIGN_PERSONAL_MESSAGE = 8;
    private static final int INS_PROVIDE_ERC20_TOKEN_INFORMATION = 10;
    private static final int P1_NO_DISPLAY = 0;
    private static final int P1_DISPLAY = 1;
    private static final int P2_NO_CHAINCODE = 0;
    private static final int P2_CHAINCODE = 1;
    private static final int P1_FIRST_BLOCK = 0;
    private static final int P1_NEXT_BLOCK = 128;
    private static final int MAX_BLOCK_SIZE = 255;

    public Eth(LedgerDevice device) {
        super(device);
    }

    public WalletAddress getWalletAddress(String bip32Path, boolean verify) throws LedgerException {
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 2, verify ? 1 : 0, 1, convertedPath);
        response.checkSW();
        return SerializeHelper.readWalletAddress(response.getResponse());
    }

    private ECDSADeviceSignature signMessageOrTransaction(int ins, String bip32Path, byte[] rawTransaction, boolean signMsg) throws LedgerException {
        int blockSize;
        byte[] convertedPath = BIP32Helper.splitPath(bip32Path);
        int extra = signMsg ? 4 : 0;
        ApduExchange.ApduResponse response = null;
        for (int offset = 0; offset != rawTransaction.length; offset += blockSize) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int maxBlockSize = offset == 0 ? 255 - convertedPath.length - extra : 255;
            int n = blockSize = offset + maxBlockSize > rawTransaction.length ? rawTransaction.length - offset : maxBlockSize;
            if (offset == 0) {
                out.write(convertedPath, 0, convertedPath.length);
                if (signMsg) {
                    SerializeHelper.writeUint32BE(out, rawTransaction.length);
                }
            }
            out.write(Arrays.copyOfRange(rawTransaction, offset, offset + blockSize), 0, blockSize);
            response = ApduExchange.exchangeApdu(this.device, 224, ins, offset == 0 ? 0 : 128, 0, out.toByteArray());
            response.checkSW();
        }
        byte[] responseData = response.getResponse();
        return new ECDSADeviceSignature(responseData[0] & 0xFF, Arrays.copyOfRange(responseData, 1, 33), Arrays.copyOfRange(responseData, 33, 65));
    }

    public ECDSADeviceSignature signTransaction(String bip32Path, byte[] rawTransaction) throws LedgerException {
        return this.signMessageOrTransaction(4, bip32Path, rawTransaction, false);
    }

    public ECDSADeviceSignature signErc20Transaction(String bip32Path, byte[] rawTransaction, byte[] tokenInformation) throws LedgerException {
        if (tokenInformation != null) {
            ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 10, 0, 0, tokenInformation);
            response.checkSW();
        }
        return this.signTransaction(bip32Path, rawTransaction);
    }

    public byte[] getErc20TokenInformation(String contractAddress) {
        return Erc20Cache.lookup(contractAddress);
    }

    public ECDSADeviceSignature signPersonalMessage(String bip32Path, byte[] message) throws LedgerException {
        return this.signMessageOrTransaction(8, bip32Path, message, true);
    }

    public EthConfiguration getConfiguration() throws LedgerException {
        ApduExchange.ApduResponse response = ApduExchange.exchangeApdu(this.device, 224, 6, 0, 0);
        response.checkSW();
        return new EthConfiguration(response.getResponse());
    }

    public class EthConfiguration {
        public static final int FLAG_DATA_ALLOWED = 1;
        public static final int FLAG_EXTERNAL_TOKEN_NEEDED = 2;
        private int flags;

        EthConfiguration(byte[] response) {
            int offset = 0;
            this.flags = response[offset++] & 0xFF;
        }

        public int getFlags() {
            return this.flags;
        }

        public String flagsToString() {
            String result = "";
            if ((this.flags & 1) != 0) {
                result = result + "Data signing allowed,";
            }
            if ((this.flags & 2) != 0) {
                result = result + "External ERC 20 information required,";
            }
            if (result.length() == 0) {
                return result;
            }
            return result.substring(0, result.length() - 1);
        }

        public String toString() {
            return this.flagsToString();
        }
    }
}

