/*
 * Decompiled with CFR 0.152.
 */
package com.ledger.lib.apps.btc;

import com.ledger.lib.LedgerException;
import com.ledger.lib.utils.Dump;
import com.ledger.lib.utils.SerializeHelper;
import com.ledger.lib.utils.VarintUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class BtcTransaction {
    private byte[] version;
    private Vector<BtcInput> inputs;
    private Vector<BtcOutput> outputs;
    private byte[] lockTime;
    private byte[] witness;
    private static final int BIP141_MARKER = 1;

    public BtcTransaction(byte[] txData) throws LedgerException {
        ByteArrayInputStream data = new ByteArrayInputStream(txData);
        boolean segwit = false;
        this.inputs = new Vector();
        this.outputs = new Vector();
        try {
            long i;
            this.version = new byte[4];
            data.read(this.version);
            if (txData[4] == 0 && txData[5] != 0) {
                if (txData[5] != 1) {
                    throw new LedgerException(LedgerException.ExceptionReason.INVALID_PARAMETER, "Unsupported transaction marker " + (txData[5] & 0xFF));
                }
                segwit = true;
                data.skip(2L);
            }
            long numberItems = VarintUtils.read(data);
            for (i = 0L; i < numberItems; ++i) {
                this.inputs.add(new BtcInput(data));
            }
            numberItems = VarintUtils.read(data);
            for (i = 0L; i < numberItems; ++i) {
                this.outputs.add(new BtcOutput(data));
            }
            if (segwit) {
                this.witness = new byte[data.available() - 4];
                data.read(this.witness);
            }
            this.lockTime = new byte[4];
            data.read(this.lockTime);
        }
        catch (Exception e) {
            throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public BtcTransaction() {
        this.version = new byte[0];
        this.inputs = new Vector();
        this.outputs = new Vector();
        this.lockTime = new byte[0];
    }

    public byte[] serialize(boolean skipOutputLockTime, boolean skipWitness) throws LedgerException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SerializeHelper.writeBuffer(output, this.version);
        if (this.witness != null && !skipWitness) {
            output.write(0);
            output.write(1);
        }
        VarintUtils.write(output, this.inputs.size());
        for (BtcInput input : this.inputs) {
            input.serialize(output);
        }
        if (!skipOutputLockTime) {
            VarintUtils.write(output, this.outputs.size());
            for (BtcOutput outputItem : this.outputs) {
                outputItem.serialize(output);
            }
            if (this.witness != null && !skipWitness) {
                SerializeHelper.writeBuffer(output, this.witness);
            }
            SerializeHelper.writeBuffer(output, this.lockTime);
        }
        return output.toByteArray();
    }

    public byte[] serializeOutputs() throws LedgerException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        VarintUtils.write(output, this.outputs.size());
        for (BtcOutput outputItem : this.outputs) {
            outputItem.serialize(output);
        }
        return output.toByteArray();
    }

    public byte[] getVersion() {
        return this.version;
    }

    public Vector<BtcInput> getInputs() {
        return this.inputs;
    }

    public Vector<BtcOutput> getOutputs() {
        return this.outputs;
    }

    public byte[] getLockTime() {
        return this.lockTime;
    }

    public byte[] getWitness() {
        return this.witness;
    }

    public void setVersion(byte[] version) {
        this.version = version;
    }

    public void addInput(BtcInput input) {
        this.inputs.add(input);
    }

    public void addOutput(BtcOutput output) {
        this.outputs.add(output);
    }

    public void setLockTime(byte[] lockTime) {
        this.lockTime = lockTime;
    }

    public void setWitness(byte[] witness) {
        this.witness = witness;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Version ").append(Dump.dump(this.version)).append('\r').append('\n');
        int index = 1;
        for (BtcInput input : this.inputs) {
            buffer.append("Input #").append(index).append('\r').append('\n');
            buffer.append(input.toString());
            ++index;
        }
        index = 1;
        for (BtcOutput output : this.outputs) {
            buffer.append("Output #").append(index).append('\r').append('\n');
            buffer.append(output.toString());
            ++index;
        }
        if (this.witness != null) {
            buffer.append("Witness ").append(Dump.dump(this.witness)).append('\r').append('\n');
        }
        buffer.append("LockTime ").append(Dump.dump(this.lockTime)).append('\r').append('\n');
        return buffer.toString();
    }

    public class BtcOutput {
        private byte[] amount;
        private byte[] script;

        public BtcOutput(ByteArrayInputStream data) throws LedgerException {
            try {
                this.amount = new byte[8];
                data.read(this.amount);
                long scriptSize = VarintUtils.read(data);
                this.script = new byte[(int)scriptSize];
                data.read(this.script);
            }
            catch (Exception e) {
                throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, (Throwable)e);
            }
        }

        public BtcOutput() {
            this.amount = new byte[0];
            this.script = new byte[0];
        }

        public void serialize(ByteArrayOutputStream output) throws LedgerException {
            SerializeHelper.writeBuffer(output, this.amount);
            VarintUtils.write(output, this.script.length);
            SerializeHelper.writeBuffer(output, this.script);
        }

        public byte[] getAmount() {
            return this.amount;
        }

        public byte[] getScript() {
            return this.script;
        }

        public void setAmount(byte[] amount) {
            this.amount = amount;
        }

        public void setScript(byte[] script) {
            this.script = script;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Amount ").append(Dump.dump(this.amount)).append('\r').append('\n');
            buffer.append("Script ").append(Dump.dump(this.script)).append('\r').append('\n');
            return buffer.toString();
        }
    }

    public class BtcInput {
        private byte[] prevHash;
        private long prevIndex;
        private byte[] script;
        private byte[] sequence;

        public BtcInput(ByteArrayInputStream data) throws LedgerException {
            try {
                byte[] prevIndexSerialized = new byte[4];
                this.prevHash = new byte[32];
                data.read(this.prevHash);
                data.read(prevIndexSerialized);
                this.prevIndex = SerializeHelper.readUint32LE(prevIndexSerialized, 0);
                long scriptSize = VarintUtils.read(data);
                this.script = new byte[(int)scriptSize];
                data.read(this.script);
                this.sequence = new byte[4];
                data.read(this.sequence);
            }
            catch (Exception e) {
                throw new LedgerException(LedgerException.ExceptionReason.INTERNAL_ERROR, (Throwable)e);
            }
        }

        public BtcInput() {
            this.prevHash = new byte[0];
            this.prevIndex = 0L;
            this.script = new byte[0];
            this.sequence = new byte[0];
        }

        public void serialize(ByteArrayOutputStream output) throws LedgerException {
            SerializeHelper.writeBuffer(output, this.prevHash);
            SerializeHelper.writeUint32LE(output, this.prevIndex);
            VarintUtils.write(output, this.script.length);
            SerializeHelper.writeBuffer(output, this.script);
            SerializeHelper.writeBuffer(output, this.sequence);
        }

        public byte[] getPrevHash() {
            return this.prevHash;
        }

        public long getPrevIndex() {
            return this.prevIndex;
        }

        public byte[] getScript() {
            return this.script;
        }

        public byte[] getSequence() {
            return this.sequence;
        }

        public void setPrevHash(byte[] prevHash) {
            this.prevHash = prevHash;
        }

        public void setPrevIndex(long prevIndex) {
            this.prevIndex = prevIndex;
        }

        public void setScript(byte[] script) {
            this.script = script;
        }

        public void setSequence(byte[] sequence) {
            this.sequence = sequence;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Prevout ").append(Dump.dump(this.prevHash)).append(':').append(this.prevIndex).append('\r').append('\n');
            buffer.append("Script ").append(Dump.dump(this.script)).append('\r').append('\n');
            buffer.append("Sequence ").append(Dump.dump(this.sequence)).append('\r').append('\n');
            return buffer.toString();
        }
    }
}

