/*
 * Decompiled with CFR 0.152.
 */
package com.laztdev.module.nfc.stream;

import android.nfc.tech.IsoDep;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.nfc.tech.NfcF;
import android.nfc.tech.NfcV;
import android.nfc.tech.TagTechnology;
import com.laztdev.module.nfc.stream.NfcCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NfcStream {
    private final TagTechnology mBasicTag;
    private final int timeout;
    private byte[] startData = new byte[0];
    private byte[] endData = new byte[0];
    private List<byte[]> transferData = new ArrayList<byte[]>();
    private boolean autoDisconnect = true;
    private boolean bypassError = false;
    private NfcCallback nfcCallback;

    public NfcStream(TagTechnology basicTag, int timeout) {
        this.mBasicTag = basicTag;
        this.bypassError = false;
        this.autoDisconnect = true;
        this.timeout = timeout;
    }

    public NfcStream startWith(byte[] buffer) {
        this.startData = new byte[0];
        if (buffer == null || buffer.length == 0) {
            return this;
        }
        this.startData = (byte[])buffer.clone();
        return this;
    }

    public NfcStream endWith(byte[] buffer) {
        this.endData = new byte[0];
        if (buffer == null || buffer.length == 0) {
            return this;
        }
        this.endData = (byte[])buffer.clone();
        return this;
    }

    public NfcStream data(byte[] ... buffer) {
        this.transferData.clear();
        return this.add(buffer);
    }

    public NfcStream add(byte[] ... buffer) {
        if (buffer == null || buffer.length == 0) {
            return this;
        }
        Collections.addAll(this.transferData, buffer);
        return this;
    }

    public NfcStream bypassError(boolean bypassError) {
        this.bypassError = bypassError;
        return this;
    }

    public NfcStream autoDisconnect(boolean disconnect) {
        this.autoDisconnect = disconnect;
        return this;
    }

    public void stream() {
        if (this.startData != null && this.startData.length > 0) {
            this.transferData.add(0, this.startData);
        }
        if (this.endData != null && this.endData.length > 0) {
            this.transferData.add(this.endData);
        }
        try {
            if (!this.mBasicTag.isConnected()) {
                this.mBasicTag.connect();
            }
            if (this.mBasicTag instanceof NfcA) {
                this.streamNfcA(this.transferData);
            } else if (this.mBasicTag instanceof NfcB) {
                this.streamNfcB(this.transferData);
            } else if (this.mBasicTag instanceof NfcF) {
                this.streamNfcF(this.transferData);
            } else if (this.mBasicTag instanceof IsoDep) {
                this.streamIsoDep(this.transferData);
            } else if (this.mBasicTag instanceof NfcV) {
                this.streamNfcV(this.transferData);
            }
            if (this.autoDisconnect) {
                this.mBasicTag.close();
            }
        }
        catch (Exception e) {
            this.nfcCallback.OnError(e);
        }
    }

    private void streamNfcA(List<byte[]> transferData) throws Exception {
        NfcA nfc = (NfcA)this.mBasicTag;
        nfc.setTimeout(this.timeout);
        for (byte[] send : transferData) {
            byte[] recv;
            block3: {
                recv = new byte[]{};
                try {
                    recv = nfc.transceive(send);
                }
                catch (Exception e) {
                    if (this.bypassError) break block3;
                    throw new Exception(e);
                }
            }
            this.nfcCallback.OnReceive(send, recv);
        }
        this.nfcCallback.OnComplete();
    }

    private void streamNfcB(List<byte[]> transferData) throws Exception {
        NfcB nfc = (NfcB)this.mBasicTag;
        for (byte[] send : transferData) {
            byte[] recv;
            block3: {
                recv = new byte[]{};
                try {
                    recv = nfc.transceive(send);
                }
                catch (Exception e) {
                    if (this.bypassError) break block3;
                    throw new Exception(e);
                }
            }
            this.nfcCallback.OnReceive(send, recv);
        }
        this.nfcCallback.OnComplete();
    }

    private void streamNfcF(List<byte[]> transferData) throws Exception {
        NfcF nfc = (NfcF)this.mBasicTag;
        nfc.setTimeout(this.timeout);
        for (byte[] send : transferData) {
            byte[] recv;
            block3: {
                recv = new byte[]{};
                try {
                    recv = nfc.transceive(send);
                }
                catch (Exception e) {
                    if (this.bypassError) break block3;
                    throw new Exception(e);
                }
            }
            this.nfcCallback.OnReceive(send, recv);
        }
        this.nfcCallback.OnComplete();
    }

    private void streamIsoDep(List<byte[]> transferData) throws Exception {
        IsoDep nfc = (IsoDep)this.mBasicTag;
        nfc.setTimeout(this.timeout);
        for (byte[] send : transferData) {
            byte[] recv;
            block3: {
                recv = new byte[]{};
                try {
                    recv = nfc.transceive(send);
                }
                catch (Exception e) {
                    if (this.bypassError) break block3;
                    throw new Exception(e);
                }
            }
            this.nfcCallback.OnReceive(send, recv);
        }
        this.nfcCallback.OnComplete();
    }

    private void streamNfcV(List<byte[]> transferData) throws Exception {
        NfcV nfc = (NfcV)this.mBasicTag;
        for (byte[] send : transferData) {
            byte[] recv;
            block3: {
                recv = new byte[]{};
                try {
                    recv = nfc.transceive(send);
                }
                catch (Exception e) {
                    if (this.bypassError) break block3;
                    throw new Exception(e);
                }
            }
            this.nfcCallback.OnReceive(send, recv);
        }
        this.nfcCallback.OnComplete();
    }

    public NfcStream callback(NfcCallback nfcCallback) {
        this.nfcCallback = nfcCallback;
        return this;
    }
}

