/*
 * Decompiled with CFR 0.152.
 */
package com.laztdev.module.nfc.info;

import android.content.Context;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class TagTypePlatform {
    private static final String TAG = TagTypePlatform.class.getSimpleName();
    private static TagTypePlatform instance;
    private List<Metadata> metadata;

    public static TagTypePlatform getInstance() {
        if (instance == null) {
            instance = new TagTypePlatform();
        }
        return instance;
    }

    public void init(Context context) {
        this.metadata = this.getMetaData();
    }

    public String getCompliantFormTagType(int type) {
        if (this.checkParameter(type)) {
            return "Unknown";
        }
        return this.metadata.get(type + 1).getCompliant();
    }

    public String getOperationSpecificationFormTagType(int type) {
        if (this.checkParameter(type)) {
            return "Unknown";
        }
        return this.metadata.get(type + 1).getBase();
    }

    private boolean checkParameter(int type) {
        if (this.metadata == null) {
            Log.e((String)TAG, (String)"Please init first!!");
            return true;
        }
        return type < 1 || type > this.metadata.size();
    }

    public List<Metadata> getMetaData() {
        ArrayList<Metadata> data = new ArrayList<Metadata>();
        data.add(new Metadata("Type 1", "NFC-A", "ISO/IEC 14443-3 A", "106 kbit/sec", "454 Bytes", "Read/Write", "Low", "Broadcom Topaz"));
        data.add(new Metadata("Type 2", "NFC-A", "ISO/IEC 14443-3 A", "106 kbit/sec", "48/128/144/504/888/1904 bytes", "Read/Write or Read-only", "Low", "NXP Mifare Ultralight, NXP Mifare Ultralight C, NXP NTAG 21s (F), NXP NTAG I2C"));
        data.add(new Metadata("Type 3", "NFC-F", "JIS 6319-4", "212 kbit/sec", "1/4/9 KBytes", "Read/Write or Read-only", "High", "Sony Felica"));
        data.add(new Metadata("Type 4", "NFC-A/B", "ISO/IEC 14443-4 Smart Card", "106 - 424 kbit/sec", "2/4/8/106/144 KBytes", "Read/Write or Read-only", "Medium/High", "NXP DESfire, NXP SmartMX with JCOP, ST Microelectronics"));
        data.add(new Metadata("Type 5", "NFC-V", "ISO/IEC 15693", "6.62 - 26.48 kbit/sec", "32/112/128/160/256 KBytes", "Read/Write", "Low/Medium", "NXP ICODE SLI(x), Texas Instruments Tag-It, HF-I, EM423x, ST Microelectronics"));
        return data;
    }

    private class Metadata {
        private String format;
        private String compliant;
        private String base;
        private String speed;
        private String spec;
        private String access;
        private String price;
        private String products;

        public Metadata(String format, String compliant, String base, String speed, String spec, String access, String price, String products) {
            this.format = format;
            this.compliant = compliant;
            this.base = base;
            this.speed = speed;
            this.spec = spec;
            this.access = access;
            this.price = price;
            this.products = products;
        }

        public String getFormat() {
            return this.format;
        }

        public String getCompliant() {
            return this.compliant;
        }

        public String getBase() {
            return this.base;
        }

        public String getSpeed() {
            return this.speed;
        }

        public String getSpec() {
            return this.spec;
        }

        public String getAccess() {
            return this.access;
        }

        public String getPrice() {
            return this.price;
        }

        public String getProducts() {
            return this.products;
        }
    }
}

