/*
 * Decompiled with CFR 0.152.
 */
package com.laztdev.module.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.os.Build;
import android.util.Log;
import com.laztdev.module.nfc.info.RegistrationAuthority;
import com.laztdev.module.nfc.info.TagTypePlatform;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public abstract class NfcWrapper {
    private static final String TAG = NfcWrapper.class.getSimpleName();
    protected Tag tag;
    private NfcAdapter mNfcAdapter;
    private Set<Class> mNfcClasses = new HashSet<Class>();
    private IntentFilter[] mIntentFilters;
    private String[][] mTechLists;

    protected NfcWrapper() {
    }

    public void init(Context context) {
        this.init(context, new IntentFilter[]{new IntentFilter("android.nfc.action.TAG_DISCOVERED"), new IntentFilter("android.nfc.action.TECH_DISCOVERED")}, (String[][])null);
    }

    public void init(Context context, Class<?> ... nfcClasses) {
        this.initRegister(context);
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)context);
        Collections.addAll(this.mNfcClasses, nfcClasses);
        this.initTechLists(this.mNfcClasses);
        this.initIntentFilters();
    }

    public void init(Context context, IntentFilter[] intentFilters, String[][] techLists) {
        this.initRegister(context);
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)context);
        this.mIntentFilters = intentFilters;
        this.mTechLists = techLists;
    }

    public void terminate() {
        this.tag = null;
        this.mNfcAdapter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Activity activity) {
        if (this.mNfcAdapter != null) {
            NfcWrapper nfcWrapper = this;
            synchronized (nfcWrapper) {
                this.installNfcHandler(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Activity activity) {
        if (this.mNfcAdapter != null) {
            NfcWrapper nfcWrapper = this;
            synchronized (nfcWrapper) {
                this.mNfcAdapter.disableForegroundDispatch(activity);
            }
        }
    }

    public void onNewIntent(Activity activity, Intent intent) {
        this.tag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        if (this.tag == null) {
            this.disable(activity);
        }
    }

    public void callNfcSetting(Context context) {
        if (context != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                Intent intent = new Intent("android.settings.NFC_SETTINGS");
                intent.addFlags(0x10000000);
                context.startActivity(intent);
            } else {
                Intent intent = new Intent("android.settings.WIRELESS_SETTINGS");
                intent.addFlags(0x10000000);
                context.startActivity(intent);
            }
        }
    }

    public boolean isNfcActivated() {
        if (this.mNfcAdapter == null) {
            Log.e((String)TAG, (String)"NfcWrapper implementation not available.");
            return false;
        }
        return this.mNfcAdapter.isEnabled();
    }

    public byte[] getUid() {
        if (this.tag == null) {
            return null;
        }
        return this.tag.getId();
    }

    private void initRegister(Context context) {
        RegistrationAuthority.getInstance().init(context);
        TagTypePlatform.getInstance().init(context);
    }

    private void initTechLists(Set<Class> mNfcClasses) {
        this.mTechLists = new String[mNfcClasses.size()][];
        Enumeration<Class> e = new Vector<Class>(mNfcClasses).elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.mTechLists[i] = new String[]{e.nextElement().getClass().getName()};
            ++i;
        }
    }

    private void initIntentFilters() {
        this.mIntentFilters = new IntentFilter[]{new IntentFilter("android.nfc.action.TAG_DISCOVERED")};
    }

    private void installNfcHandler(Activity activity) {
        Intent activityIntent = new Intent((Context)activity, activity.getClass());
        activityIntent.addFlags(0x20000000);
        PendingIntent intent = PendingIntent.getActivity((Context)activity, (int)0, (Intent)activityIntent, (int)0x10000000);
        this.mNfcAdapter.enableForegroundDispatch(activity, intent, this.mIntentFilters, this.mTechLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(Activity activity) {
        NfcWrapper nfcWrapper = this;
        synchronized (nfcWrapper) {
            block7: {
                try {
                    this.mNfcAdapter.disableForegroundDispatch(activity);
                }
                catch (IllegalStateException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                }
                catch (NullPointerException e) {
                    Log.e((String)TAG, (String)"Your phone is not support a NFC Technology.");
                }
                catch (Exception e) {
                    if (e.getMessage() == null) break block7;
                    Log.e((String)TAG, (String)e.getMessage());
                }
            }
        }
    }
}

