/*
 * Decompiled with CFR 0.152.
 */
package com.laztdev.module.nfc;

import android.app.Activity;
import android.content.Intent;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.IsoDep;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.MifareUltralight;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.nfc.tech.NfcBarcode;
import android.nfc.tech.NfcF;
import android.nfc.tech.NfcV;
import android.nfc.tech.TagTechnology;
import android.os.Build;
import android.util.Log;
import com.laztdev.module.nfc.NfcWrapper;
import com.laztdev.module.nfc.info.RegistrationAuthority;
import com.laztdev.module.nfc.stream.NfcStream;
import com.laztdev.module.utils.TagStatus;
import java.io.IOException;
import java.util.HashMap;

public class Nfc
extends NfcWrapper {
    private static Nfc instance;
    private HashMap<String, TagTechnology> mMandatoryTags = new HashMap();
    private HashMap<String, TagTechnology> mOptionalTags = new HashMap();
    private String tagSelector;
    private TagStatus status;
    private int timeout;

    public static Nfc getInstance() {
        if (instance == null) {
            instance = new Nfc();
        }
        return instance;
    }

    protected Nfc() {
    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {
        super.onNewIntent(activity, intent);
        if (this.isFoundTag()) {
            this.initBasicTag();
            this.initOptionalTag();
        }
    }

    public String[] getRfTechnology() {
        return this.tag == null ? null : this.tag.getTechList();
    }

    @Override
    public byte[] getUid() {
        return this.tag == null ? null : this.tag.getId();
    }

    public String getManufacturer() {
        byte[] uid = this.getUid();
        if (uid == null || uid.length <= 0) {
            return "Unknown";
        }
        return RegistrationAuthority.getInstance().getManufacturerFormId(uid[0]);
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getMandatoryTagsLength() {
        return this.mMandatoryTags.size();
    }

    public int getOptionalTagsLength() {
        return this.mOptionalTags.size();
    }

    public String getTagSelector() {
        return this.tagSelector;
    }

    public void setTagSelector(String tagSelector) {
        if (this.mMandatoryTags.containsKey(tagSelector)) {
            this.tagSelector = tagSelector;
        }
    }

    public void setTagSelectorByIndex(int i) {
        if (this.tag != null && this.mMandatoryTags.containsKey(this.tag.getTechList()[i])) {
            this.tagSelector = this.tag.getTechList()[i];
        }
    }

    public TagStatus getStatus() {
        return this.status;
    }

    protected void setStatus(TagStatus status) {
        this.status = status;
    }

    public void exception() throws IOException {
        switch (this.status) {
            case DISAPPEAR: {
                throw new TagLostException();
            }
            case RESP_FAIL: {
                throw new IOException();
            }
        }
    }

    public boolean isFoundTag() {
        return this.tag != null;
    }

    public boolean isTagExists() {
        try {
            boolean isConnected = this.mMandatoryTags.get(this.tagSelector).isConnected();
            if (isConnected) {
                this.mMandatoryTags.get(this.tagSelector).close();
            }
            this.mMandatoryTags.get(this.tagSelector).connect();
            if (!isConnected) {
                this.mMandatoryTags.get(this.tagSelector).close();
            }
        }
        catch (Exception e) {
            this.status = TagStatus.DISAPPEAR;
        }
        return this.status != TagStatus.DISAPPEAR;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxTransceiveLength() {
        return this.getNfcMaxTransceiveLength();
    }

    public void close() {
        try {
            if (this.mMandatoryTags.get(this.tagSelector).isConnected()) {
                this.mMandatoryTags.get(this.tagSelector).close();
            }
        }
        catch (Exception e) {
            this.status = TagStatus.DISAPPEAR;
        }
    }

    public byte[] autoTransceive(byte[] send_data) {
        return this.autoTransceive(true, send_data);
    }

    public synchronized byte[] autoTransceive(boolean disconnect, byte[] send_data) {
        byte[] recv = null;
        try {
            if (!this.mMandatoryTags.get(this.tagSelector).isConnected()) {
                this.mMandatoryTags.get(this.tagSelector).connect();
            }
            this.setNfcTimeout(this.timeout);
            recv = this.transceive(send_data);
            if (disconnect) {
                this.mMandatoryTags.get(this.tagSelector).close();
            }
            this.status = TagStatus.EXCHANGE;
        }
        catch (IOException e) {
            this.status = e.getMessage().contains("Transceive failed") ? TagStatus.RESP_FAIL : TagStatus.DISAPPEAR;
        }
        catch (Exception e) {
            this.status = e.getMessage() == null ? TagStatus.DISAPPEAR : TagStatus.EXCHANGE;
        }
        return recv;
    }

    public NfcStream begin() {
        return new NfcStream(this.mMandatoryTags.get(this.tagSelector), this.timeout);
    }

    protected int getNfcMaxTransceiveLength() {
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcA) {
            return ((NfcA)this.mMandatoryTags.get(this.tagSelector)).getMaxTransceiveLength();
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcB) {
            return ((NfcB)this.mMandatoryTags.get(this.tagSelector)).getMaxTransceiveLength();
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcF) {
            return ((NfcF)this.mMandatoryTags.get(this.tagSelector)).getMaxTransceiveLength();
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof IsoDep) {
            return ((IsoDep)this.mMandatoryTags.get(this.tagSelector)).getMaxTransceiveLength();
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcV) {
            return ((NfcV)this.mMandatoryTags.get(this.tagSelector)).getMaxTransceiveLength();
        }
        return 0;
    }

    protected byte[] transceive(byte[] data) throws IOException {
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcA) {
            return ((NfcA)this.mMandatoryTags.get(this.tagSelector)).transceive(data);
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcB) {
            return ((NfcB)this.mMandatoryTags.get(this.tagSelector)).transceive(data);
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcF) {
            return ((NfcF)this.mMandatoryTags.get(this.tagSelector)).transceive(data);
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof IsoDep) {
            return ((IsoDep)this.mMandatoryTags.get(this.tagSelector)).transceive(data);
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcV) {
            return ((NfcV)this.mMandatoryTags.get(this.tagSelector)).transceive(data);
        }
        return null;
    }

    protected void setNfcTimeout(int timeout) {
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcA) {
            ((NfcA)this.mMandatoryTags.get(this.tagSelector)).setTimeout(timeout);
        } else if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcF) {
            ((NfcF)this.mMandatoryTags.get(this.tagSelector)).setTimeout(timeout);
        } else if (this.mMandatoryTags.get(this.tagSelector) instanceof IsoDep) {
            ((IsoDep)this.mMandatoryTags.get(this.tagSelector)).setTimeout(timeout);
        } else {
            Log.w((String)this.getClass().getSimpleName(), (String)"Timeout can't be set, please choose the Mandatory Tag as NfcA, NfcF or IsoDep.");
        }
    }

    protected int getNfcTimeout() {
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcA) {
            return ((NfcA)this.mMandatoryTags.get(this.tagSelector)).getTimeout();
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof NfcF) {
            return ((NfcF)this.mMandatoryTags.get(this.tagSelector)).getTimeout();
        }
        if (this.mMandatoryTags.get(this.tagSelector) instanceof IsoDep) {
            return ((IsoDep)this.mMandatoryTags.get(this.tagSelector)).getTimeout();
        }
        return this.timeout;
    }

    private void initBasicTag() {
        this.timeout = 0;
        this.mMandatoryTags.clear();
        this.tagSelector = this.tag.getTechList()[0];
        String[] stringArray = this.tag.getTechList();
        int n = stringArray.length;
        block16: for (int i = 0; i < n; ++i) {
            String tech;
            switch (tech = stringArray[i]) {
                case "android.nfc.tech.NfcA": {
                    this.mMandatoryTags.put(tech, (TagTechnology)NfcA.get((Tag)this.tag));
                    this.timeout = this.getNfcTimeout();
                    continue block16;
                }
                case "android.nfc.tech.NfcB": {
                    this.mMandatoryTags.put(tech, (TagTechnology)NfcB.get((Tag)this.tag));
                    this.timeout = this.getNfcTimeout();
                    continue block16;
                }
                case "android.nfc.tech.NfcF": {
                    this.mMandatoryTags.put(tech, (TagTechnology)NfcF.get((Tag)this.tag));
                    this.timeout = this.getNfcTimeout();
                    continue block16;
                }
                case "android.nfc.tech.IsoDep": {
                    this.mMandatoryTags.put(tech, (TagTechnology)IsoDep.get((Tag)this.tag));
                    this.timeout = this.getNfcTimeout();
                    continue block16;
                }
                case "android.nfc.tech.NfcV": {
                    this.mMandatoryTags.put(tech, (TagTechnology)NfcV.get((Tag)this.tag));
                    this.timeout = this.getNfcTimeout();
                    continue block16;
                }
                case "android.nfc.tech.Ndef": {
                    this.mMandatoryTags.put(tech, (TagTechnology)Ndef.get((Tag)this.tag));
                    this.timeout = this.getNfcTimeout();
                    continue block16;
                }
            }
        }
    }

    private void initOptionalTag() {
        this.mOptionalTags.clear();
        String[] stringArray = this.tag.getTechList();
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String tech;
            switch (tech = stringArray[i]) {
                case "android.nfc.tech.MifareClassic": {
                    this.mOptionalTags.put(tech, (TagTechnology)MifareClassic.get((Tag)this.tag));
                    continue block12;
                }
                case "android.nfc.tech.MifareUltralight": {
                    this.mOptionalTags.put(tech, (TagTechnology)MifareUltralight.get((Tag)this.tag));
                    continue block12;
                }
                case "android.nfc.tech.NfcBarcode": {
                    if (Build.VERSION.SDK_INT < 17) continue block12;
                    this.mOptionalTags.put(tech, (TagTechnology)NfcBarcode.get((Tag)this.tag));
                    continue block12;
                }
                case "android.nfc.tech.NdefFormatable": {
                    this.mOptionalTags.put(tech, (TagTechnology)NdefFormatable.get((Tag)this.tag));
                    continue block12;
                }
            }
        }
    }
}

