/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.configuration;

import java.util.ArrayList;
import java.util.List;

public class JMeterProcessJVMSettings {
    private int xms = 512;
    private int xmx = 512;
    private String javaRuntime = "java";
    private List<String> arguments = new ArrayList<String>();
    private static final String RUN_HEADLESS = "-Djava.awt.headless=true";
    private static final String HEADLESS_SETTING = "-Djava.awt.headless=";

    public int getXms() {
        return this.xms;
    }

    public int getXmx() {
        return this.xmx;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public JMeterProcessJVMSettings addArgument(String newArgument) {
        if (this.arguments.stream().noneMatch(argument -> argument.equals(newArgument))) {
            this.arguments.add(newArgument);
        }
        return this;
    }

    public JMeterProcessJVMSettings setHeadlessDefaultIfRequired() {
        if (this.arguments.stream().noneMatch(argument -> argument.contains(HEADLESS_SETTING))) {
            this.addArgument(RUN_HEADLESS);
        }
        return this;
    }

    public String getJavaRuntime() {
        return this.javaRuntime;
    }
}

