/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.util;

import com.lazerycode.jmeter.analyzer.AnalyzeMojo;
import com.lazerycode.jmeter.analyzer.config.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TemplateUtil {
    private static final int Q_QUANTILES = 1000;
    private static final int K_99_PONT_9_PERCENT = 999;
    private static final int K_99_PERCENT = 990;
    private static final int PERCENT_100 = 100;

    public static Map<String, Object> getRootMap(Object self) {
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("self", self);
        rootMap.put("Q_QUANTILES", 1000);
        rootMap.put("K_99_PERCENT", 990);
        rootMap.put("K_99_PONT_9_PERCENT", 999);
        rootMap.put("PERCENT_100", 100);
        rootMap.put("DETAILS", Environment.ENVIRONMENT.isGenerateDetails());
        rootMap.put("CHARTS", Environment.ENVIRONMENT.isGenerateCharts());
        return rootMap;
    }

    public static Template getTemplate(String templateName) throws IOException {
        Template template = null;
        File templateDirectory = Environment.ENVIRONMENT.getTemplateDirectory();
        Configuration configuration = Environment.ENVIRONMENT.getConfiguration();
        if (templateDirectory != null && templateDirectory.isDirectory() && new File(templateDirectory, templateName).exists()) {
            configuration.setDirectoryForTemplateLoading(templateDirectory);
            template = configuration.getTemplate(templateName);
        }
        if (template == null) {
            configuration.setClassForTemplateLoading(AnalyzeMojo.class, "templates");
            template = configuration.getTemplate(templateName);
        }
        return template;
    }
}

