/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.LazyStackTrace;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.logging.LDLogger;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

final class AsyncEventHandler
implements EventHandler {
    private final Executor executor;
    private final EventHandler eventSourceHandler;
    private final LDLogger logger;
    final Semaphore semaphore;

    AsyncEventHandler(Executor executor, EventHandler eventSourceHandler, LDLogger logger, Semaphore semaphore) {
        this.executor = executor;
        this.eventSourceHandler = eventSourceHandler;
        this.logger = logger;
        this.semaphore = semaphore;
    }

    @Override
    public void onOpen() {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onOpen();
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onClosed() {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onClosed();
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onComment(String comment) {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onComment(comment);
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onMessage(String event, MessageEvent messageEvent) {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onMessage(event, messageEvent);
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
            finally {
                messageEvent.close();
            }
        });
    }

    @Override
    public void onError(Throwable error) {
        this.execute(() -> this.onErrorInternal(error));
    }

    private void handleUnexpectedError(Throwable error) {
        this.logger.warn((Object)("Caught unexpected error from EventHandler: " + error.toString()));
        this.logger.debug("Stack trace: {}", (Object)new LazyStackTrace(error));
        this.onErrorInternal(error);
    }

    private void onErrorInternal(Throwable error) {
        try {
            this.eventSourceHandler.onError(error);
        }
        catch (Throwable errorFromErrorHandler) {
            this.logger.warn((Object)("Caught unexpected error from EventHandler.onError(): " + errorFromErrorHandler.toString()));
            this.logger.debug("Stack trace: {}", (Object)new LazyStackTrace(error));
        }
    }

    private void execute(Runnable task) {
        this.acquire();
        try {
            this.executor.execute(() -> {
                try {
                    task.run();
                }
                finally {
                    this.release();
                }
            });
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    private void acquire() {
        if (this.semaphore != null) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Thread interrupted while waiting for event thread semaphore", e);
            }
        }
    }

    private void release() {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }
}

