/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.eventsource.UnsuccessfulResponseException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSource
implements ConnectionHandler,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(EventSource.class);
    private static final long DEFAULT_RECONNECT_TIME_MS = 1000L;
    static final long MAX_RECONNECT_TIME_MS = 30000L;
    private final URI uri;
    private final Headers headers;
    private final ExecutorService executor;
    private volatile long reconnectTimeMs = 0L;
    private volatile String lastEventId;
    private final EventHandler handler;
    private final AtomicReference<ReadyState> readyState;
    private final OkHttpClient client;
    private volatile Call call;
    private final Random jitter = new Random();

    EventSource(Builder builder) {
        this.uri = builder.uri;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.reconnectTimeMs = builder.reconnectTimeMs;
        this.executor = Executors.newCachedThreadPool();
        this.handler = new AsyncEventHandler(this.executor, builder.handler);
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
        this.client = builder.client.newBuilder().readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public void start() {
        if (!this.readyState.compareAndSet(ReadyState.RAW, ReadyState.CONNECTING)) {
            logger.info("Start method called on this already-started EventSource object. Doing nothing");
            return;
        }
        logger.debug("readyState change: " + (Object)((Object)ReadyState.RAW) + " -> " + (Object)((Object)ReadyState.CONNECTING));
        logger.info("Starting EventSource client using URI: " + this.uri);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.connect();
            }
        });
    }

    @Override
    public void close() throws IOException {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.SHUTDOWN));
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        this.executor.shutdownNow();
        if (this.call != null) {
            this.call.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void connect() {
        Response response = null;
        int reconnectAttempts = 0;
        try {
            block9: while (!Thread.currentThread().isInterrupted()) {
                if (this.readyState.get() == ReadyState.SHUTDOWN) return;
                this.maybeWaitWithBackoff(reconnectAttempts++);
                ReadyState currentState = this.readyState.getAndSet(ReadyState.CONNECTING);
                logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CONNECTING));
                try {
                    Request.Builder builder = new Request.Builder().headers(this.headers).url(this.uri.toASCIIString()).get();
                    if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                        builder.addHeader("Last-Event-ID", this.lastEventId);
                    }
                    this.call = this.client.newCall(builder.build());
                    response = this.call.execute();
                    if (response.isSuccessful()) {
                        reconnectAttempts = 0;
                        currentState = this.readyState.getAndSet(ReadyState.OPEN);
                        if (currentState != ReadyState.CONNECTING) {
                            logger.warn("Unexpected readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        } else {
                            logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        }
                        logger.info("Connected to Event Source stream.");
                        BufferedSource bs = Okio.buffer((Source)response.body().source());
                        EventParser parser = new EventParser(this.uri, this.handler, this);
                        while (true) {
                            String line;
                            if (Thread.currentThread().isInterrupted() || (line = bs.readUtf8LineStrict()) == null) continue block9;
                            parser.line(line);
                        }
                    }
                    logger.debug("Unsuccessful Response: " + response);
                    this.handler.onError(new UnsuccessfulResponseException(response.code()));
                }
                catch (EOFException eofe) {
                    logger.warn("Connection unexpectedly closed.");
                }
                catch (IOException ioe) {
                    logger.debug("Connection problem.", (Throwable)ioe);
                    this.handler.onError(ioe);
                }
                finally {
                    currentState = this.readyState.getAndSet(ReadyState.CLOSED);
                    logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CLOSED));
                    if (response != null && response.body() != null) {
                        response.body().close();
                    }
                    if (this.call == null) continue;
                    this.call.cancel();
                }
            }
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void maybeWaitWithBackoff(int reconnectAttempts) {
        if (this.reconnectTimeMs > 0L && reconnectAttempts > 0) {
            try {
                long sleepTimeMs = this.backoffWithJitter(reconnectAttempts);
                logger.info("Waiting " + sleepTimeMs + " milliseconds before reconnecting...");
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    long backoffWithJitter(int reconnectAttempts) {
        long jitterVal = Math.min(30000L, this.reconnectTimeMs * (long)this.pow2(reconnectAttempts));
        return jitterVal / 2L + this.nextLong(this.jitter, jitterVal) / 2L;
    }

    private int pow2(int k) {
        return k < 31 ? 1 << k : Integer.MAX_VALUE;
    }

    private long nextLong(Random rand, long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = rand.nextLong() & Long.MAX_VALUE;
        long m = bound - 1L;
        if ((bound & m) == 0L) {
            r = bound * r >> 63;
        } else {
            long u = r;
            while (u - (r = u % bound) + m < 0L) {
                u = rand.nextLong() & Long.MAX_VALUE;
            }
        }
        return r;
    }

    private static Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        builder.add("Accept", "text/event-stream").add("Cache-Control", "no-cache");
        for (Map.Entry header : custom.toMultimap().entrySet()) {
            for (String value : (List)header.getValue()) {
                builder.add((String)header.getKey(), value);
            }
        }
        return builder.build();
    }

    @Override
    public void setReconnectionTimeMs(long reconnectionTimeMs) {
        this.reconnectTimeMs = reconnectionTimeMs;
    }

    @Override
    public void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public static final class Builder {
        private long reconnectTimeMs = 1000L;
        private final URI uri;
        private final EventHandler handler;
        private Headers headers = Headers.of((String[])new String[0]);
        private OkHttpClient client = new OkHttpClient();

        public Builder(EventHandler handler, URI uri) {
            this.uri = uri;
            this.handler = handler;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMs = reconnectTimeMs;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public EventSource build() {
            return new EventSource(this);
        }
    }
}

