/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.SimpleFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class SimpleLogging
implements LDLogAdapter {
    final LineWriter lineWriter;
    private final String tag;
    private final DateFormat timestampFormat;

    public static SimpleDateFormat getDefaultTimestampFormat() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS zzz");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        return f;
    }

    SimpleLogging(LineWriter lineWriter, String tag, DateFormat timestampFormat) {
        this.lineWriter = lineWriter;
        this.tag = tag;
        this.timestampFormat = timestampFormat;
    }

    public SimpleLogging tag(String tag) {
        return new SimpleLogging(this.lineWriter, tag, this.timestampFormat);
    }

    public SimpleLogging timestampFormat(DateFormat timestampFormat) {
        return new SimpleLogging(this.lineWriter, this.tag, timestampFormat);
    }

    @Override
    public LDLogAdapter.Channel newChannel(String name) {
        return new ChannelImpl(name);
    }

    private final class ChannelImpl
    implements LDLogAdapter.Channel {
        private final String name;

        ChannelImpl(String name) {
            this.name = name;
        }

        @Override
        public boolean isEnabled(LDLogLevel level) {
            return true;
        }

        @Override
        public void log(LDLogLevel level, Object message) {
            this.print(level, message == null ? "" : message.toString());
        }

        @Override
        public void log(LDLogLevel level, String format, Object param) {
            this.print(level, SimpleFormat.format(format, param));
        }

        @Override
        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            this.print(level, SimpleFormat.format(format, param1, param2));
        }

        @Override
        public void log(LDLogLevel level, String format, Object ... params) {
            this.print(level, SimpleFormat.format(format, params));
        }

        private void print(LDLogLevel level, String message) {
            StringBuilder s = new StringBuilder();
            if (SimpleLogging.this.timestampFormat != null) {
                DateFormat clonedFormat = (DateFormat)SimpleLogging.this.timestampFormat.clone();
                s.append(clonedFormat.format(new Date())).append(" ");
            }
            if (SimpleLogging.this.tag != null && !SimpleLogging.this.tag.isEmpty()) {
                s.append("{").append(SimpleLogging.this.tag).append("} ");
            }
            s.append("[").append(this.name).append("] ").append((Object)level).append(": ").append(message);
            SimpleLogging.this.lineWriter.writeLine(s.toString());
        }
    }

    public static interface LineWriter {
        public void writeLine(String var1);
    }
}

