/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.integrations.BigSegmentsConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataStoreFactory;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import com.launchdarkly.sdk.server.interfaces.HttpConfigurationFactory;
import com.launchdarkly.sdk.server.interfaces.LoggingConfigurationFactory;
import java.net.URI;
import java.time.Duration;

public final class LDConfig {
    static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    static final URI DEFAULT_EVENTS_URI = URI.create("https://events.launchdarkly.com");
    static final URI DEFAULT_STREAM_URI = URI.create("https://stream.launchdarkly.com");
    static final Duration DEFAULT_START_WAIT = Duration.ofSeconds(5L);
    protected static final LDConfig DEFAULT = new Builder().build();
    final BigSegmentsConfigurationBuilder bigSegmentsConfigBuilder;
    final DataSourceFactory dataSourceFactory;
    final DataStoreFactory dataStoreFactory;
    final boolean diagnosticOptOut;
    final EventProcessorFactory eventProcessorFactory;
    final HttpConfigurationFactory httpConfigFactory;
    final LoggingConfigurationFactory loggingConfigFactory;
    final boolean offline;
    final Duration startWait;
    final int threadPriority;

    protected LDConfig(Builder builder) {
        if (builder.offline) {
            this.dataSourceFactory = Components.externalUpdatesOnly();
            this.eventProcessorFactory = Components.noEvents();
        } else {
            this.dataSourceFactory = builder.dataSourceFactory == null ? Components.streamingDataSource() : builder.dataSourceFactory;
            this.eventProcessorFactory = builder.eventProcessorFactory == null ? Components.sendEvents() : builder.eventProcessorFactory;
        }
        this.bigSegmentsConfigBuilder = builder.bigSegmentsConfigBuilder == null ? Components.bigSegments(null) : builder.bigSegmentsConfigBuilder;
        this.dataStoreFactory = builder.dataStoreFactory == null ? Components.inMemoryDataStore() : builder.dataStoreFactory;
        this.diagnosticOptOut = builder.diagnosticOptOut;
        this.httpConfigFactory = builder.httpConfigFactory == null ? Components.httpConfiguration() : builder.httpConfigFactory;
        this.loggingConfigFactory = builder.loggingConfigFactory == null ? Components.logging() : builder.loggingConfigFactory;
        this.offline = builder.offline;
        this.startWait = builder.startWait;
        this.threadPriority = builder.threadPriority;
    }

    public static class Builder {
        private BigSegmentsConfigurationBuilder bigSegmentsConfigBuilder = null;
        private DataSourceFactory dataSourceFactory = null;
        private DataStoreFactory dataStoreFactory = null;
        private boolean diagnosticOptOut = false;
        private EventProcessorFactory eventProcessorFactory = null;
        private HttpConfigurationFactory httpConfigFactory = null;
        private LoggingConfigurationFactory loggingConfigFactory = null;
        private boolean offline = false;
        private Duration startWait = DEFAULT_START_WAIT;
        private int threadPriority = 1;

        public Builder bigSegments(BigSegmentsConfigurationBuilder bigSegmentsConfigBuilder) {
            this.bigSegmentsConfigBuilder = bigSegmentsConfigBuilder;
            return this;
        }

        public Builder dataSource(DataSourceFactory factory2) {
            this.dataSourceFactory = factory2;
            return this;
        }

        public Builder dataStore(DataStoreFactory factory2) {
            this.dataStoreFactory = factory2;
            return this;
        }

        public Builder diagnosticOptOut(boolean diagnosticOptOut) {
            this.diagnosticOptOut = diagnosticOptOut;
            return this;
        }

        public Builder events(EventProcessorFactory factory2) {
            this.eventProcessorFactory = factory2;
            return this;
        }

        public Builder http(HttpConfigurationFactory factory2) {
            this.httpConfigFactory = factory2;
            return this;
        }

        public Builder logging(LoggingConfigurationFactory factory2) {
            this.loggingConfigFactory = factory2;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder startWait(Duration startWait) {
            this.startWait = startWait == null ? DEFAULT_START_WAIT : startWait;
            return this;
        }

        public Builder threadPriority(int threadPriority) {
            this.threadPriority = Math.max(1, Math.min(10, threadPriority));
            return this;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

