/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.okhttp3.internal.ws;

import com.launchdarkly.shaded.okhttp3.internal.ws.WebSocketProtocol;
import com.launchdarkly.shaded.okio.Buffer;
import com.launchdarkly.shaded.okio.BufferedSource;
import com.launchdarkly.shaded.okio.ByteString;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

final class WebSocketReader {
    final boolean isClient;
    final BufferedSource source;
    final FrameCallback frameCallback;
    boolean closed;
    int opcode;
    long frameLength;
    long frameBytesRead;
    boolean isFinalFrame;
    boolean isControlFrame;
    boolean isMasked;
    final byte[] maskKey = new byte[4];
    final byte[] maskBuffer = new byte[8192];

    WebSocketReader(boolean isClient, BufferedSource source, FrameCallback frameCallback) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (frameCallback == null) {
            throw new NullPointerException("frameCallback == null");
        }
        this.isClient = isClient;
        this.source = source;
        this.frameCallback = frameCallback;
    }

    void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader() throws IOException {
        boolean reservedFlag3;
        int b0;
        if (this.closed) {
            throw new IOException("closed");
        }
        long timeoutBefore = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            b0 = this.source.readByte() & 0xFF;
        }
        finally {
            this.source.timeout().timeout(timeoutBefore, TimeUnit.NANOSECONDS);
        }
        this.opcode = b0 & 0xF;
        this.isFinalFrame = (b0 & 0x80) != 0;
        boolean bl = this.isControlFrame = (b0 & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean reservedFlag1 = (b0 & 0x40) != 0;
        boolean reservedFlag2 = (b0 & 0x20) != 0;
        boolean bl2 = reservedFlag3 = (b0 & 0x10) != 0;
        if (reservedFlag1 || reservedFlag2 || reservedFlag3) {
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        int b1 = this.source.readByte() & 0xFF;
        boolean bl3 = this.isMasked = (b1 & 0x80) != 0;
        if (this.isMasked == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = b1 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = (long)this.source.readShort() & 0xFFFFL;
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Long.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        this.frameBytesRead = 0L;
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (this.isMasked) {
            this.source.readFully(this.maskKey);
        }
    }

    private void readControlFrame() throws IOException {
        Buffer buffer = new Buffer();
        if (this.frameBytesRead < this.frameLength) {
            if (this.isClient) {
                this.source.readFully(buffer, this.frameLength);
            } else {
                while (this.frameBytesRead < this.frameLength) {
                    int toRead = (int)Math.min(this.frameLength - this.frameBytesRead, (long)this.maskBuffer.length);
                    int read = this.source.read(this.maskBuffer, 0, toRead);
                    if (read == -1) {
                        throw new EOFException();
                    }
                    WebSocketProtocol.toggleMask(this.maskBuffer, read, this.maskKey, this.frameBytesRead);
                    buffer.write(this.maskBuffer, 0, read);
                    this.frameBytesRead += (long)read;
                }
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(buffer.readByteString());
                break;
            }
            case 10: {
                this.frameCallback.onReadPong(buffer.readByteString());
                break;
            }
            case 8: {
                int code = 1005;
                String reason = "";
                long bufferSize = buffer.size();
                if (bufferSize == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (bufferSize != 0L) {
                    code = buffer.readShort();
                    reason = buffer.readUtf8();
                    String codeExceptionMessage = WebSocketProtocol.closeCodeExceptionMessage(code);
                    if (codeExceptionMessage != null) {
                        throw new ProtocolException(codeExceptionMessage);
                    }
                }
                this.frameCallback.onReadClose(code, reason);
                this.closed = true;
                break;
            }
            default: {
                throw new ProtocolException("Unknown control opcode: " + Integer.toHexString(this.opcode));
            }
        }
    }

    private void readMessageFrame() throws IOException {
        int opcode = this.opcode;
        if (opcode != 1 && opcode != 2) {
            throw new ProtocolException("Unknown opcode: " + Integer.toHexString(opcode));
        }
        Buffer message = new Buffer();
        this.readMessage(message);
        if (opcode == 1) {
            this.frameCallback.onReadMessage(message.readUtf8());
        } else {
            this.frameCallback.onReadMessage(message.readByteString());
        }
    }

    void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private void readMessage(Buffer sink) throws IOException {
        while (true) {
            long read;
            if (this.closed) {
                throw new IOException("closed");
            }
            if (this.frameBytesRead == this.frameLength) {
                if (this.isFinalFrame) {
                    return;
                }
                this.readUntilNonControlFrame();
                if (this.opcode != 0) {
                    throw new ProtocolException("Expected continuation opcode. Got: " + Integer.toHexString(this.opcode));
                }
                if (this.isFinalFrame && this.frameLength == 0L) {
                    return;
                }
            }
            long toRead = this.frameLength - this.frameBytesRead;
            if (this.isMasked) {
                read = this.source.read(this.maskBuffer, 0, (int)(toRead = Math.min(toRead, (long)this.maskBuffer.length)));
                if (read == -1L) {
                    throw new EOFException();
                }
                WebSocketProtocol.toggleMask(this.maskBuffer, read, this.maskKey, this.frameBytesRead);
                sink.write(this.maskBuffer, 0, (int)read);
            } else {
                read = this.source.read(sink, toRead);
                if (read == -1L) {
                    throw new EOFException();
                }
            }
            this.frameBytesRead += read;
        }
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

