/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.shaded.org.apache.commons.codec.digest.DigestUtils;
import java.util.List;

class VariationOrRollout {
    private static final float long_scale = 1.1529215E18f;
    private final Integer variation;
    private final Rollout rollout;

    VariationOrRollout(Integer variation, Rollout rollout) {
        this.variation = variation;
        this.rollout = rollout;
    }

    Integer variationIndexForUser(LDUser user, String key, String salt) {
        if (this.variation != null) {
            return this.variation;
        }
        if (this.rollout != null) {
            String bucketBy = this.rollout.bucketBy == null ? "key" : this.rollout.bucketBy;
            float bucket = this.bucketUser(user, key, bucketBy, salt);
            float sum = 0.0f;
            for (WeightedVariation wv : this.rollout.variations) {
                if (!(bucket < (sum += (float)wv.weight / 100000.0f))) continue;
                return wv.variation;
            }
        }
        return null;
    }

    private float bucketUser(LDUser user, String key, String attr, String salt) {
        JsonElement userValue = user.getValueForEvaluation(attr);
        if (userValue != null && userValue.isJsonPrimitive() && userValue.getAsJsonPrimitive().isString()) {
            String idHash = userValue.getAsString();
            if (user.getSecondary() != null) {
                idHash = idHash + "." + user.getSecondary().getAsString();
            }
            String hash = DigestUtils.sha1Hex(key + "." + salt + "." + idHash).substring(0, 15);
            long longVal = Long.parseLong(hash, 16);
            return (float)longVal / 1.1529215E18f;
        }
        return 0.0f;
    }

    static class WeightedVariation {
        private final int variation;
        private final int weight;

        WeightedVariation(int variation, int weight) {
            this.variation = variation;
            this.weight = weight;
        }
    }

    static class Rollout {
        private final List<WeightedVariation> variations;
        private final String bucketBy;

        Rollout(List<WeightedVariation> variations, String bucketBy) {
            this.variations = variations;
            this.bucketBy = bucketBy;
        }
    }
}

