/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureFlagBuilder;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.RedisFeatureStoreBuilder;
import com.launchdarkly.shaded.com.google.common.base.Optional;
import com.launchdarkly.shaded.com.google.common.cache.CacheBuilder;
import com.launchdarkly.shaded.com.google.common.cache.CacheLoader;
import com.launchdarkly.shaded.com.google.common.cache.CacheStats;
import com.launchdarkly.shaded.com.google.common.cache.LoadingCache;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.launchdarkly.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.BinaryJedis;
import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPool;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.Transaction;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisFeatureStore
implements FeatureStore {
    private static final Logger logger = LoggerFactory.getLogger(RedisFeatureStore.class);
    private static final String DEFAULT_PREFIX = "launchdarkly";
    private static final String INIT_KEY = "$initialized$";
    private static final String CACHE_REFRESH_THREAD_POOL_NAME_FORMAT = "RedisFeatureStore-cache-refresher-pool-%d";
    private final JedisPool pool;
    private LoadingCache<String, Optional<FeatureFlag>> cache;
    private LoadingCache<String, Boolean> initCache;
    private String prefix;
    private ListeningExecutorService executorService;

    @Deprecated
    public RedisFeatureStore(String host, int port, String prefix, long cacheTimeSecs) {
        this(host, port, prefix, cacheTimeSecs, RedisFeatureStore.getPoolConfig());
    }

    @Deprecated
    public RedisFeatureStore(URI uri, String prefix, long cacheTimeSecs) {
        this(uri, prefix, cacheTimeSecs, RedisFeatureStore.getPoolConfig());
    }

    @Deprecated
    public RedisFeatureStore(String host, int port, String prefix, long cacheTimeSecs, JedisPoolConfig poolConfig) {
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port);
        this.setPrefix(prefix);
        this.createCache(cacheTimeSecs);
        this.createInitCache(cacheTimeSecs);
    }

    @Deprecated
    public RedisFeatureStore(URI uri, String prefix, long cacheTimeSecs, JedisPoolConfig poolConfig) {
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, uri);
        this.setPrefix(prefix);
        this.createCache(cacheTimeSecs);
        this.createInitCache(cacheTimeSecs);
    }

    protected RedisFeatureStore(RedisFeatureStoreBuilder builder) {
        this.pool = builder.poolConfig == null ? new JedisPool((GenericObjectPoolConfig)RedisFeatureStore.getPoolConfig(), builder.uri, builder.connectTimeout, builder.socketTimeout) : new JedisPool((GenericObjectPoolConfig)builder.poolConfig, builder.uri, builder.connectTimeout, builder.socketTimeout);
        this.setPrefix(builder.prefix);
        this.createCache(builder.cacheTimeSecs, builder.refreshStaleValues, builder.asyncRefresh);
        this.createInitCache(builder.cacheTimeSecs);
    }

    public RedisFeatureStore() {
        this.pool = new JedisPool((GenericObjectPoolConfig)RedisFeatureStore.getPoolConfig(), "localhost");
        this.prefix = DEFAULT_PREFIX;
    }

    private void setPrefix(String prefix) {
        this.prefix = prefix == null || prefix.isEmpty() ? DEFAULT_PREFIX : prefix;
    }

    private void createCache(long cacheTimeSecs) {
        this.createCache(cacheTimeSecs, false, false);
    }

    private void createCache(long cacheTimeSecs, boolean refreshStaleValues, boolean asyncRefresh) {
        if (cacheTimeSecs > 0L) {
            if (refreshStaleValues) {
                this.createRefreshCache(cacheTimeSecs, asyncRefresh);
            } else {
                this.createExpiringCache(cacheTimeSecs);
            }
        }
    }

    private CacheLoader<String, Optional<FeatureFlag>> createDefaultCacheLoader() {
        return new CacheLoader<String, Optional<FeatureFlag>>(){

            @Override
            public Optional<FeatureFlag> load(String key) throws Exception {
                return Optional.fromNullable(RedisFeatureStore.this.getRedis(key));
            }
        };
    }

    private void createRefreshCache(long cacheTimeSecs, boolean asyncRefresh) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(CACHE_REFRESH_THREAD_POOL_NAME_FORMAT).setDaemon(true).build();
        ExecutorService parentExecutor = Executors.newSingleThreadExecutor(threadFactory);
        this.executorService = MoreExecutors.listeningDecorator(parentExecutor);
        CacheLoader<String, Optional<FeatureFlag>> cacheLoader = this.createDefaultCacheLoader();
        if (asyncRefresh) {
            cacheLoader = CacheLoader.asyncReloading(cacheLoader, this.executorService);
        }
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(cacheLoader);
    }

    private void createExpiringCache(long cacheTimeSecs) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(this.createDefaultCacheLoader());
    }

    private void createInitCache(long cacheTimeSecs) {
        if (cacheTimeSecs > 0L) {
            this.initCache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(new CacheLoader<String, Boolean>(){

                @Override
                public Boolean load(String key) throws Exception {
                    return RedisFeatureStore.this.getInit();
                }
            });
        }
    }

    @Override
    public FeatureFlag get(String key) {
        FeatureFlag featureFlag = this.cache != null ? this.cache.getUnchecked(key).orNull() : this.getRedis(key);
        if (featureFlag != null) {
            logger.debug("[get] Key: " + key + " with version: " + featureFlag.getVersion() + " found in feature store.");
        }
        return featureFlag;
    }

    @Override
    public Map<String, FeatureFlag> all() {
        try (Jedis jedis = this.pool.getResource();){
            Map<String, String> featuresJson = jedis.hgetAll(this.featuresKey());
            HashMap<String, FeatureFlag> result = new HashMap<String, FeatureFlag>();
            Gson gson = new Gson();
            Type type = new TypeToken<FeatureFlag>(){}.getType();
            for (Map.Entry<String, String> entry : featuresJson.entrySet()) {
                FeatureFlag featureFlag = (FeatureFlag)gson.fromJson(entry.getValue(), type);
                if (featureFlag.isDeleted()) continue;
                result.put(entry.getKey(), featureFlag);
            }
            HashMap<String, FeatureFlag> hashMap = result;
            return hashMap;
        }
    }

    @Override
    public void init(Map<String, FeatureFlag> features) {
        try (Jedis jedis = this.pool.getResource();){
            Gson gson = new Gson();
            Transaction t = jedis.multi();
            t.del(this.featuresKey());
            for (FeatureFlag f : features.values()) {
                t.hset(this.featuresKey(), f.getKey(), gson.toJson(f));
            }
            t.exec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key, int version) {
        BinaryJedis jedis = null;
        try {
            Gson gson = new Gson();
            jedis = this.pool.getResource();
            ((Jedis)jedis).watch(this.featuresKey());
            FeatureFlag feature = this.getRedis(key);
            if (feature != null && feature.getVersion() >= version) {
                logger.warn("Attempted to delete flag: " + key + " version: " + feature.getVersion() + " with a version that is the same or older: " + version);
                return;
            }
            FeatureFlagBuilder newBuilder = new FeatureFlagBuilder(feature);
            newBuilder.deleted(true);
            newBuilder.version(version);
            ((Jedis)jedis).hset(this.featuresKey(), key, gson.toJson(newBuilder.build()));
            if (this.cache != null) {
                this.cache.invalidate(key);
            }
        }
        finally {
            if (jedis != null) {
                jedis.unwatch();
                ((Jedis)jedis).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsert(String key, FeatureFlag feature) {
        Jedis jedis = null;
        try {
            jedis = this.pool.getResource();
            Gson gson = new Gson();
            jedis.watch(this.featuresKey());
            FeatureFlag f = this.getRedis(key);
            if (f != null && f.getVersion() >= feature.getVersion()) {
                logger.warn("Attempted to update flag: " + key + " version: " + f.getVersion() + " with a version that is the same or older: " + feature.getVersion());
                return;
            }
            jedis.hset(this.featuresKey(), key, gson.toJson(feature));
            if (this.cache != null) {
                this.cache.invalidate(key);
            }
        }
        finally {
            if (jedis != null) {
                jedis.unwatch();
                jedis.close();
            }
        }
    }

    @Override
    public boolean initialized() {
        Boolean initialized;
        if (this.initCache != null && (initialized = this.initCache.getUnchecked(INIT_KEY)) != null && initialized.booleanValue()) {
            return true;
        }
        return this.getInit();
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly RedisFeatureStore");
        try {
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
        }
        finally {
            this.pool.destroy();
        }
    }

    public CacheStats getCacheStats() {
        if (this.cache != null) {
            return this.cache.stats();
        }
        return null;
    }

    private String featuresKey() {
        return this.prefix + ":features";
    }

    private Boolean getInit() {
        try (Jedis jedis = this.pool.getResource();){
            Boolean bl = jedis.exists(this.featuresKey());
            return bl;
        }
    }

    private FeatureFlag getRedis(String key) {
        try (Jedis jedis = this.pool.getResource();){
            Gson gson = new Gson();
            String featureJson = jedis.hget(this.featuresKey(), key);
            if (featureJson == null) {
                logger.debug("[get] Key: " + key + " not found in feature store. Returning null");
                FeatureFlag featureFlag = null;
                return featureFlag;
            }
            Type type = new TypeToken<FeatureFlag>(){}.getType();
            FeatureFlag f = (FeatureFlag)gson.fromJson(featureJson, type);
            if (f.isDeleted()) {
                logger.debug("[get] Key: " + key + " has been deleted. Returning null");
                FeatureFlag featureFlag = null;
                return featureFlag;
            }
            FeatureFlag featureFlag = f;
            return featureFlag;
        }
    }

    private static JedisPoolConfig getPoolConfig() {
        return new JedisPoolConfig();
    }
}

