/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android.integrations;

import androidx.annotation.NonNull;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.android.ConnectionInformation;
import com.launchdarkly.sdk.android.DataModel;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import com.launchdarkly.sdk.android.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.android.subsystems.DataSource;
import com.launchdarkly.sdk.android.subsystems.DataSourceUpdateSink;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TestData
implements ComponentConfigurer<DataSource> {
    private final Object lock = new Object();
    private final Map<String, Integer> currentFlagVersions = new HashMap<String, Integer>();
    private final Map<String, FlagBuilder> currentBuilders = new HashMap<String, FlagBuilder>();
    private final List<DataSourceImpl> instances = new CopyOnWriteArrayList<DataSourceImpl>();

    public static TestData dataSource() {
        return new TestData();
    }

    private TestData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlagBuilder flag(String key) {
        FlagBuilder existingBuilder;
        Object object = this.lock;
        synchronized (object) {
            existingBuilder = this.currentBuilders.get(key);
        }
        if (existingBuilder != null) {
            return new FlagBuilder(existingBuilder);
        }
        return new FlagBuilder(key).booleanFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestData update(FlagBuilder flagBuilder) {
        int newVersion;
        String key = flagBuilder.key;
        FlagBuilder clonedBuilder = new FlagBuilder(flagBuilder);
        Iterator<DataSourceImpl> iterator = this.lock;
        synchronized (iterator) {
            int oldVersion = this.currentFlagVersions.containsKey(key) ? this.currentFlagVersions.get(key) : 0;
            newVersion = oldVersion + 1;
            this.currentFlagVersions.put(key, newVersion);
            this.currentBuilders.put(key, clonedBuilder);
        }
        for (DataSourceImpl instance : this.instances) {
            instance.doUpdate(clonedBuilder, newVersion);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource build(ClientContext clientContext) {
        DataSourceImpl instance = new DataSourceImpl(clientContext.getEvaluationContext(), clientContext.getDataSourceUpdateSink());
        Object object = this.lock;
        synchronized (object) {
            this.instances.add(instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DataModel.Flag> makeInitData(LDContext context) {
        HashMap<String, DataModel.Flag> data = new HashMap<String, DataModel.Flag>();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, FlagBuilder> kv : this.currentBuilders.entrySet()) {
                int version = this.currentFlagVersions.containsKey(kv.getKey()) ? this.currentFlagVersions.get(kv.getKey()) : 1;
                data.put(kv.getKey(), kv.getValue().createFlag(version, context));
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closedInstance(DataSourceImpl instance) {
        Object object = this.lock;
        synchronized (object) {
            this.instances.remove(instance);
        }
    }

    private final class DataSourceImpl
    implements DataSource {
        final LDContext context;
        final DataSourceUpdateSink updates;

        DataSourceImpl(LDContext context, DataSourceUpdateSink updates) {
            this.context = context;
            this.updates = updates;
        }

        @Override
        public void start(@NonNull Callback<Boolean> resultCallback) {
            this.updates.init(this.context, TestData.this.makeInitData(this.context));
            this.updates.setStatus(ConnectionInformation.ConnectionMode.STREAMING, null);
            resultCallback.onSuccess(true);
        }

        @Override
        public void stop(@NonNull Callback<Void> completionCallback) {
            TestData.this.closedInstance(this);
        }

        void doUpdate(FlagBuilder flagBuilder, int version) {
            DataModel.Flag flag = flagBuilder.createFlag(version, this.context);
            this.updates.upsert(this.context, flag);
        }
    }

    public static final class FlagBuilder {
        private static final int TRUE_VARIATION_FOR_BOOLEAN = 0;
        private static final int FALSE_VARIATION_FOR_BOOLEAN = 1;
        final String key;
        CopyOnWriteArrayList<LDValue> variations;
        int defaultVariation;
        Map<ContextKind, Map<String, Integer>> variationByContextKey;
        VariationFunc<Integer> variationFunc;

        private FlagBuilder(String key) {
            this.key = key;
            this.variations = new CopyOnWriteArrayList();
            this.defaultVariation = 0;
            this.variationByContextKey = new HashMap<ContextKind, Map<String, Integer>>();
        }

        private FlagBuilder(FlagBuilder from) {
            this.key = from.key;
            this.variations = new CopyOnWriteArrayList<LDValue>(from.variations);
            this.defaultVariation = from.defaultVariation;
            this.variationByContextKey = new HashMap<ContextKind, Map<String, Integer>>();
            for (Map.Entry<ContextKind, Map<String, Integer>> kv : from.variationByContextKey.entrySet()) {
                this.variationByContextKey.put(kv.getKey(), new HashMap<String, Integer>(kv.getValue()));
            }
            this.variationFunc = from.variationFunc;
        }

        private boolean isBooleanFlag() {
            return this.variations.size() == 2 && this.variations.get(0).equals((Object)LDValue.of((boolean)true)) && this.variations.get(1).equals((Object)LDValue.of((boolean)false));
        }

        public FlagBuilder booleanFlag() {
            return this.isBooleanFlag() ? this : this.variations(LDValue.of((boolean)true), LDValue.of((boolean)false));
        }

        public FlagBuilder variation(boolean variation) {
            return this.booleanFlag().variation(FlagBuilder.variationForBoolean(variation));
        }

        public FlagBuilder variation(int variationIndex) {
            this.defaultVariation = variationIndex;
            return this;
        }

        public FlagBuilder variation(LDValue value) {
            this.defaultVariation = this.findOrAddVariationValue(value);
            this.variationFunc = null;
            return this;
        }

        public FlagBuilder variationForUser(String userKey, boolean variation) {
            return this.variationForKey(ContextKind.DEFAULT, userKey, variation);
        }

        public FlagBuilder variationForUser(String userKey, int variationIndex) {
            return this.variationForKey(ContextKind.DEFAULT, userKey, variationIndex);
        }

        public FlagBuilder variationForUser(String userKey, LDValue value) {
            return this.variationForUser(userKey, this.findOrAddVariationValue(value));
        }

        public FlagBuilder variationForKey(ContextKind contextKind, String contextKey, boolean variation) {
            return this.booleanFlag().variationForKey(contextKind, contextKey, FlagBuilder.variationForBoolean(variation));
        }

        public FlagBuilder variationForKey(ContextKind contextKind, String contextKey, int variationIndex) {
            Map<String, Integer> targets = this.variationByContextKey.get(contextKind = contextKind == null ? ContextKind.DEFAULT : contextKind);
            if (targets == null) {
                targets = new HashMap<String, Integer>();
                this.variationByContextKey.put(contextKind, targets);
            }
            targets.put(contextKey, variationIndex);
            return this;
        }

        public FlagBuilder variationForKey(ContextKind contextKind, String contextKey, LDValue value) {
            return this.variationForKey(contextKind, contextKey, this.findOrAddVariationValue(value));
        }

        public FlagBuilder variationFunc(final VariationFunc<Boolean> variationFunc) {
            return this.booleanFlag().variationIndexFunc(new VariationFunc<Integer>(){

                @Override
                public Integer apply(LDContext context) {
                    Boolean v = (Boolean)variationFunc.apply(context);
                    return v == null ? null : Integer.valueOf(FlagBuilder.variationForBoolean(v));
                }
            });
        }

        public FlagBuilder variationValueFunc(final VariationFunc<LDValue> variationFunc) {
            return this.variationIndexFunc(new VariationFunc<Integer>(){

                @Override
                public Integer apply(LDContext context) {
                    LDValue v = (LDValue)variationFunc.apply(context);
                    return variations.contains(v) ? Integer.valueOf(variations.indexOf(v)) : null;
                }
            });
        }

        public FlagBuilder variationIndexFunc(VariationFunc<Integer> variationFunc) {
            this.variationFunc = variationFunc;
            return this;
        }

        public FlagBuilder variations(LDValue ... values) {
            this.variations.clear();
            for (LDValue v : values) {
                this.variations.add(v);
            }
            return this;
        }

        private int findOrAddVariationValue(LDValue value) {
            if (!this.variations.contains(value)) {
                this.variations.add(value);
            }
            return this.variations.indexOf(value);
        }

        private Integer findVariationInTargets(LDContext context) {
            if (context.isMultiple()) {
                for (int i = 0; i < context.getIndividualContextCount(); ++i) {
                    Integer result = this.findVariationInTargets(context.getIndividualContext(i));
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
            Map<String, Integer> targets = this.variationByContextKey.get(context.getKind());
            return targets == null ? null : targets.get(context.getKey());
        }

        DataModel.Flag createFlag(int version, LDContext context) {
            Integer targetedVariation = this.findVariationInTargets(context);
            if (targetedVariation == null && this.variationFunc != null) {
                targetedVariation = this.variationFunc.apply(context);
            }
            int variation = targetedVariation == null ? this.defaultVariation : targetedVariation;
            LDValue value = variation < 0 || variation >= this.variations.size() ? LDValue.ofNull() : this.variations.get(variation);
            EvaluationReason reason = targetedVariation == null ? EvaluationReason.fallthrough() : EvaluationReason.targetMatch();
            return new DataModel.Flag(this.key, value, version, null, variation, false, false, null, reason, null);
        }

        private static int variationForBoolean(boolean value) {
            return value ? 0 : 1;
        }

        public static interface VariationFunc<T> {
            public T apply(LDContext var1);
        }
    }
}

