/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android.integrations;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.android.LDAndroidLogging;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.subsystems.ApplicationInfo;

public final class ApplicationInfoBuilder {
    @Nullable
    private String applicationId;
    @Nullable
    private String applicationName;
    @Nullable
    private String applicationVersion;
    @Nullable
    private String applicationVersionName;
    @VisibleForTesting
    LDLogger logger = LDLogger.withAdapter((LDLogAdapter)LDAndroidLogging.adapter(), (String)ApplicationInfoBuilder.class.getSimpleName());

    public ApplicationInfoBuilder applicationId(String applicationId) {
        this.validatedThenSet("applicationId", (Consumer<String>)((Consumer)s -> {
            this.applicationId = s;
        }), applicationId, this.logger);
        return this;
    }

    public ApplicationInfoBuilder applicationName(String applicationName) {
        this.validatedThenSet("applicationName", (Consumer<String>)((Consumer)s -> {
            this.applicationName = s;
        }), applicationName, this.logger);
        return this;
    }

    public ApplicationInfoBuilder applicationVersion(String version) {
        this.validatedThenSet("applicationVersion", (Consumer<String>)((Consumer)s -> {
            this.applicationVersion = s;
        }), version, this.logger);
        return this;
    }

    public ApplicationInfoBuilder applicationVersionName(String versionName) {
        this.validatedThenSet("applicationVersionName", (Consumer<String>)((Consumer)s -> {
            this.applicationVersionName = s;
        }), versionName, this.logger);
        return this;
    }

    public ApplicationInfo createApplicationInfo() {
        return new ApplicationInfo(this.applicationId, this.applicationVersion, this.applicationName, this.applicationVersionName);
    }

    private void validatedThenSet(String propertyName, Consumer<String> propertySetter, String input, LDLogger logger) {
        if (input == null) {
            propertySetter.accept((Object)input);
            return;
        }
        String sanitized = LDUtil.sanitizeSpaces(input);
        String error = LDUtil.validateStringValue(sanitized);
        if (error != null) {
            logger.warn("Issue setting {} value '{}'. {}", new Object[]{propertyName, sanitized, error});
            return;
        }
        propertySetter.accept((Object)sanitized);
    }
}

