/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.ConnectivityManager;
import com.launchdarkly.sdk.android.FeatureFetcher;
import com.launchdarkly.sdk.android.PlatformState;
import com.launchdarkly.sdk.android.TaskExecutor;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.DataSource;
import com.launchdarkly.sdk.android.subsystems.DataSourceUpdateSink;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;

final class PollingDataSource
implements DataSource {
    private final LDContext currentContext;
    private final DataSourceUpdateSink dataSourceUpdateSink;
    final int initialDelayMillis;
    final int pollIntervalMillis;
    private final FeatureFetcher fetcher;
    private final PlatformState platformState;
    private final TaskExecutor taskExecutor;
    private final LDLogger logger;
    private final AtomicReference<ScheduledFuture<?>> currentPollTask = new AtomicReference();

    PollingDataSource(LDContext currentContext, DataSourceUpdateSink dataSourceUpdateSink, int initialDelayMillis, int pollIntervalMillis, FeatureFetcher fetcher, PlatformState platformState, TaskExecutor taskExecutor, LDLogger logger) {
        this.currentContext = currentContext;
        this.dataSourceUpdateSink = dataSourceUpdateSink;
        this.initialDelayMillis = initialDelayMillis;
        this.pollIntervalMillis = pollIntervalMillis;
        this.fetcher = fetcher;
        this.platformState = platformState;
        this.taskExecutor = taskExecutor;
        this.logger = logger;
    }

    @Override
    public void start(final Callback<Boolean> resultCallback) {
        Runnable trigger = new Runnable(){

            @Override
            public void run() {
                PollingDataSource.this.triggerPoll(resultCallback);
            }
        };
        this.logger.debug("Scheduling polling task with interval of {}ms, starting after {}ms", (Object)this.pollIntervalMillis, (Object)this.initialDelayMillis);
        ScheduledFuture<?> task = this.taskExecutor.startRepeatingTask(trigger, this.initialDelayMillis, this.pollIntervalMillis);
        this.currentPollTask.set(task);
    }

    @Override
    public void stop(Callback<Void> completionCallback) {
        ScheduledFuture task = this.currentPollTask.getAndSet(null);
        if (task != null) {
            task.cancel(true);
        }
        completionCallback.onSuccess(null);
    }

    private void triggerPoll(Callback<Boolean> resultCallback) {
        ConnectivityManager.fetchAndSetData(this.fetcher, this.currentContext, this.dataSourceUpdateSink, resultCallback, this.logger);
    }
}

