/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.android.subsystems.PersistentDataStore;
import java.util.ArrayList;

abstract class Migration {
    static final String SHARED_PREFS_BASE_KEY = "LaunchDarkly-";
    static final String MIGRATIONS_NAMESPACE = "LaunchDarkly-migrations";
    static final String CURRENT_SCHEMA_ID = "v4.0.0";

    private Migration() {
    }

    static void migrateWhenNeeded(PersistentDataStore store, LDLogger logger) {
        if (store.getValue(MIGRATIONS_NAMESPACE, CURRENT_SCHEMA_ID) != null) {
            return;
        }
        Migration.updateFromPre_v4_0_0(store, logger);
        store.setValue(MIGRATIONS_NAMESPACE, CURRENT_SCHEMA_ID, CURRENT_SCHEMA_ID);
    }

    static void updateFromPre_v4_0_0(PersistentDataStore store, LDLogger logger) {
        ArrayList<String> namespacesToDelete = new ArrayList<String>();
        String generatedAnonUserKey = null;
        for (String namespace : store.getAllNamespaces()) {
            if (!namespace.startsWith(SHARED_PREFS_BASE_KEY)) continue;
            namespacesToDelete.add(namespace);
            if (!namespace.equals("LaunchDarkly-id")) continue;
            generatedAnonUserKey = store.getValue(namespace, "instanceId");
        }
        for (String namespace : namespacesToDelete) {
            store.clear(namespace, true);
        }
        if (generatedAnonUserKey != null) {
            PersistentDataStoreWrapper w = new PersistentDataStoreWrapper(store, logger);
            w.setGeneratedContextKey(ContextKind.DEFAULT, generatedAnonUserKey);
        }
        if (namespacesToDelete.size() != 0) {
            logger.debug((Object)"initialized v4.0.0 store schema and removed earlier SDK data");
        }
    }
}

