/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import com.launchdarkly.sdk.android.LDClient;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class LDAwaitFuture<T>
implements Future<T> {
    private volatile T result = null;
    private volatile Throwable error = null;
    private volatile boolean completed = false;
    private final Object notifier = new Object();

    LDAwaitFuture() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void set(T result) {
        if (!this.completed) {
            this.result = result;
            Object object = this.notifier;
            synchronized (object) {
                this.completed = true;
                this.notifier.notifyAll();
            }
        } else {
            LDClient.getSharedLogger().warn((Object)"LDAwaitFuture set twice");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setException(@NonNull Throwable error) {
        if (!this.completed) {
            this.error = error;
            Object object = this.notifier;
            synchronized (object) {
                this.completed = true;
                this.notifier.notifyAll();
            }
        } else {
            LDClient.getSharedLogger().warn((Object)"LDAwaitFuture set twice");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws ExecutionException, InterruptedException {
        Object object = this.notifier;
        synchronized (object) {
            while (!this.completed) {
                this.notifier.wait();
            }
        }
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, @NonNull TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
        long remaining = unit.toNanos(timeout);
        long doneAt = remaining + System.nanoTime();
        Object object = this.notifier;
        synchronized (object) {
            while (!this.completed & remaining > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.notifier, remaining);
                remaining = doneAt - System.nanoTime();
            }
        }
        if (!this.completed) {
            throw new TimeoutException("LDAwaitFuture timed out awaiting completion");
        }
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }
}

