/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.ClientContextImpl;
import com.launchdarkly.sdk.android.FeatureFetcher;
import com.launchdarkly.sdk.android.LDConfig;
import com.launchdarkly.sdk.android.LDFailure;
import com.launchdarkly.sdk.android.LDInvalidResponseCodeFailure;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.ClientContext;
import com.launchdarkly.sdk.internal.http.HttpHelpers;
import com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

class HttpFeatureFlagFetcher
implements FeatureFetcher {
    private static final int MAX_CACHE_SIZE_BYTES = 500000;
    private final URI pollUri;
    private final boolean evaluationReasons;
    private final boolean useReport;
    private final HttpProperties httpProperties;
    private final OkHttpClient client;
    private final LDLogger logger;

    HttpFeatureFlagFetcher(@NonNull ClientContext clientContext) {
        this.pollUri = clientContext.getServiceEndpoints().getPollingBaseUri();
        this.evaluationReasons = clientContext.isEvaluationReasons();
        this.useReport = clientContext.getHttp().isUseReport();
        this.httpProperties = LDUtil.makeHttpProperties(clientContext);
        this.logger = clientContext.getBaseLogger();
        File cacheDir = new File(ClientContextImpl.get(clientContext).getPlatformState().getCacheDir(), "com.launchdarkly.http-cache");
        this.logger.debug("Using cache at: {}", (Object)cacheDir.getAbsolutePath());
        this.client = this.httpProperties.toHttpClientBuilder().cache(new Cache(cacheDir, 500000L)).connectionPool(new ConnectionPool(0, 1L, TimeUnit.MILLISECONDS)).retryOnConnectionFailure(true).build();
    }

    @Override
    public synchronized void fetch(LDContext ldContext, final Callback<String> callback) {
        if (ldContext != null) {
            Request request;
            try {
                request = this.useReport ? this.getReportRequest(ldContext) : this.getDefaultRequest(ldContext);
            }
            catch (IOException e) {
                LDUtil.logExceptionAtErrorLevel(this.logger, e, "Unexpected error in constructing request", new Object[0]);
                callback.onError(new LDFailure("Exception while fetching flags", e, LDFailure.FailureType.UNKNOWN_ERROR));
                return;
            }
            this.logger.debug("Polling for flag data: {}", (Object)request.url());
            Call call = this.client.newCall(request);
            call.enqueue(new okhttp3.Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    LDUtil.logExceptionAtErrorLevel(HttpFeatureFlagFetcher.this.logger, e, "Exception when fetching flags", new Object[0]);
                    callback.onError(new LDFailure("Exception while fetching flags", e, LDFailure.FailureType.NETWORK_FAILURE));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(@NonNull Call call, @NonNull Response response) {
                    String body = "";
                    try {
                        ResponseBody responseBody = response.body();
                        if (responseBody != null) {
                            body = responseBody.string();
                        }
                        if (!response.isSuccessful()) {
                            if (response.code() == 400) {
                                HttpFeatureFlagFetcher.this.logger.error((Object)"Received 400 response when fetching flag values. Please check recommended ProGuard settings");
                            }
                            callback.onError(new LDInvalidResponseCodeFailure("Unexpected response when retrieving Feature Flags: " + response + " using url: " + request.url() + " with body: " + body, response.code(), true));
                            return;
                        }
                        HttpFeatureFlagFetcher.this.logger.debug((Object)body);
                        HttpFeatureFlagFetcher.this.logger.debug("Cache hit count: {} Cache network Count: {}", (Object)HttpFeatureFlagFetcher.this.client.cache().hitCount(), (Object)HttpFeatureFlagFetcher.this.client.cache().networkCount());
                        HttpFeatureFlagFetcher.this.logger.debug("Cache response: {}", (Object)response.cacheResponse());
                        HttpFeatureFlagFetcher.this.logger.debug("Network response: {}", (Object)response.networkResponse());
                        callback.onSuccess(body);
                    }
                    catch (Exception e) {
                        LDUtil.logExceptionAtErrorLevel(HttpFeatureFlagFetcher.this.logger, e, "Exception when handling response for url: {} with body: {}", request.url(), body);
                        callback.onError(new LDFailure("Exception while handling flag fetch response", e, LDFailure.FailureType.INVALID_RESPONSE_BODY));
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void close() {
        HttpProperties.shutdownHttpClient((OkHttpClient)this.client);
    }

    private Request getDefaultRequest(LDContext ldContext) throws IOException {
        URI uri = HttpHelpers.concatenateUriPath((URI)this.pollUri, (String)"/msdk/evalx/contexts");
        uri = HttpHelpers.concatenateUriPath((URI)uri, (String)LDUtil.base64Url(ldContext));
        if (this.evaluationReasons) {
            uri = URI.create(uri.toString() + "?withReasons=true");
        }
        this.logger.debug("Attempting to fetch Feature flags using uri: {}", (Object)uri);
        return new Request.Builder().url(uri.toURL()).headers(this.httpProperties.toHeadersBuilder().build()).build();
    }

    private Request getReportRequest(LDContext ldContext) throws IOException {
        URI uri = HttpHelpers.concatenateUriPath((URI)this.pollUri, (String)"/msdk/evalx/context");
        if (this.evaluationReasons) {
            uri = URI.create(uri.toString() + "?withReasons=true");
        }
        this.logger.debug("Attempting to report user using uri: {}", (Object)uri);
        String contextJson = JsonSerialization.serialize((JsonSerializable)ldContext);
        RequestBody reportBody = RequestBody.create((String)contextJson, (MediaType)LDConfig.JSON);
        return new Request.Builder().url(uri.toURL()).headers(this.httpProperties.toHeadersBuilder().build()).method("REPORT", reportBody).build();
    }
}

