/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class Debounce {
    private volatile Callable<Void> pending;
    private volatile Callable<Void> inFlight = null;
    private final ExecutorService service = Executors.newSingleThreadExecutor();

    Debounce() {
    }

    synchronized void call(Callable<Void> task) {
        this.pending = task;
        this.schedulePending();
    }

    private synchronized void schedulePending() {
        if (this.pending == null) {
            return;
        }
        if (this.inFlight == null) {
            this.inFlight = this.pending;
            this.service.submit(() -> {
                try {
                    this.inFlight.call();
                }
                finally {
                    this.inFlight = null;
                    this.schedulePending();
                }
                return null;
            });
            this.pending = null;
        }
    }
}

