/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.ContextBuilder;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.ContextMultiBuilder;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.android.IContextModifier;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.android.env.IEnvironmentReporter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public class AutoEnvContextModifier
implements IContextModifier {
    static final String LD_APPLICATION_KIND = "ld_application";
    static final String LD_DEVICE_KIND = "ld_device";
    static final String ATTR_ID = "id";
    static final String ATTR_NAME = "name";
    static final String ATTR_VERSION = "version";
    static final String ATTR_VERSION_NAME = "versionName";
    static final String ATTR_MANUFACTURER = "manufacturer";
    static final String ATTR_MODEL = "model";
    static final String ATTR_LOCALE = "locale";
    static final String ATTR_OS = "os";
    static final String ATTR_FAMILY = "family";
    static final String ENV_ATTRIBUTES_VERSION = "envAttributesVersion";
    static final String SPEC_VERSION = "1.0";
    private final PersistentDataStoreWrapper persistentData;
    private final IEnvironmentReporter environmentReporter;
    private final LDLogger logger;

    public AutoEnvContextModifier(PersistentDataStoreWrapper persistentData, IEnvironmentReporter environmentReporter, LDLogger logger) {
        this.persistentData = persistentData;
        this.environmentReporter = environmentReporter;
        this.logger = logger;
    }

    @Override
    public LDContext modifyContext(LDContext context) {
        ContextMultiBuilder builder = LDContext.multiBuilder();
        builder.add(context);
        for (ContextRecipe recipe : this.makeRecipeList()) {
            if (context.getIndividualContext(recipe.kind) == null) {
                builder.add(this.makeLDContextFromRecipe(recipe));
                continue;
            }
            this.logger.warn("Unable to automatically add environment attributes for kind:{}. {} already exists.", (Object)recipe.kind, (Object)recipe.kind);
        }
        return builder.build();
    }

    private LDContext makeLDContextFromRecipe(ContextRecipe recipe) {
        try {
            ContextBuilder builder = LDContext.builder((ContextKind)recipe.kind, (String)recipe.keyCallable.call());
            for (Map.Entry<String, Callable<LDValue>> entry : recipe.attributeCallables.entrySet()) {
                builder.set(entry.getKey(), entry.getValue().call());
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<ContextRecipe> makeRecipeList() {
        ContextKind ldApplicationKind = ContextKind.of((String)LD_APPLICATION_KIND);
        HashMap<String, Callable<LDValue>> applicationCallables = new HashMap<String, Callable<LDValue>>();
        applicationCallables.put(ENV_ATTRIBUTES_VERSION, () -> LDValue.of((String)SPEC_VERSION));
        applicationCallables.put(ATTR_ID, () -> LDValue.of((String)this.environmentReporter.getApplicationInfo().getApplicationId()));
        applicationCallables.put(ATTR_NAME, () -> LDValue.of((String)this.environmentReporter.getApplicationInfo().getApplicationName()));
        applicationCallables.put(ATTR_VERSION, () -> LDValue.of((String)this.environmentReporter.getApplicationInfo().getApplicationVersion()));
        applicationCallables.put(ATTR_VERSION_NAME, () -> LDValue.of((String)this.environmentReporter.getApplicationInfo().getApplicationVersionName()));
        applicationCallables.put(ATTR_LOCALE, () -> LDValue.of((String)this.environmentReporter.getLocale()));
        ContextKind ldDeviceKind = ContextKind.of((String)LD_DEVICE_KIND);
        HashMap<String, Callable<LDValue>> deviceCallables = new HashMap<String, Callable<LDValue>>();
        deviceCallables.put(ENV_ATTRIBUTES_VERSION, () -> LDValue.of((String)SPEC_VERSION));
        deviceCallables.put(ATTR_MANUFACTURER, () -> LDValue.of((String)this.environmentReporter.getManufacturer()));
        deviceCallables.put(ATTR_MODEL, () -> LDValue.of((String)this.environmentReporter.getModel()));
        deviceCallables.put(ATTR_OS, () -> new ObjectBuilder().put(ATTR_FAMILY, this.environmentReporter.getOSFamily()).put(ATTR_NAME, this.environmentReporter.getOSName()).put(ATTR_VERSION, this.environmentReporter.getOSVersion()).build());
        return Arrays.asList(new ContextRecipe(ldApplicationKind, () -> LDUtil.urlSafeBase64Hash(Objects.toString(this.environmentReporter.getApplicationInfo().getApplicationId(), "")), applicationCallables), new ContextRecipe(ldDeviceKind, () -> this.persistentData.getOrGenerateContextKey(ldDeviceKind), deviceCallables));
    }

    private static class ContextRecipe {
        ContextKind kind;
        Callable<String> keyCallable;
        Map<String, Callable<LDValue>> attributeCallables;

        public ContextRecipe(ContextKind kind, Callable<String> keyCallable, Map<String, Callable<LDValue>> attributeCallables) {
            this.kind = kind;
            this.keyCallable = keyCallable;
            this.attributeCallables = attributeCallables;
        }
    }
}

