/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.TaskExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class AndroidTaskExecutor
implements TaskExecutor {
    private final Application application;
    private final Handler handler;
    private final LDLogger logger;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    AndroidTaskExecutor(Application application, LDLogger logger) {
        this.application = application;
        this.handler = new Handler(Looper.getMainLooper());
        this.logger = logger;
    }

    @Override
    public void executeOnMainThread(Runnable action) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.callActionWithErrorHandling(action);
        } else {
            this.handler.post(this.wrapActionWithErrorHandling(action));
        }
    }

    @Override
    public ScheduledFuture<?> scheduleTask(Runnable action, long delayMillis) {
        return this.executor.schedule(this.wrapActionWithErrorHandling(action), delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> startRepeatingTask(Runnable action, long initialDelayMillis, long intervalMillis) {
        return this.executor.scheduleAtFixedRate(this.wrapActionWithErrorHandling(action), initialDelayMillis, intervalMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    private Runnable wrapActionWithErrorHandling(final Runnable action) {
        return new Runnable(){

            @Override
            public void run() {
                AndroidTaskExecutor.this.callActionWithErrorHandling(action);
            }
        };
    }

    private void callActionWithErrorHandling(Runnable action) {
        try {
            if (action != null) {
                action.run();
            }
        }
        catch (RuntimeException e) {
            LDUtil.logExceptionAtErrorLevel(this.logger, e, "Unexpected exception from asynchronous task", new Object[0]);
        }
    }
}

