/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.android.PlatformState;
import com.launchdarkly.sdk.android.TaskExecutor;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;

final class AndroidPlatformState
implements PlatformState {
    private final Application application;
    private final TaskExecutor taskExecutor;
    private final LDLogger logger;
    private final ConnectivityReceiver connectivityReceiver;
    private final Application.ActivityLifecycleCallbacks lifecycleCallbacks;
    private final CopyOnWriteArrayList<PlatformState.ConnectivityChangeListener> connectivityChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<PlatformState.ForegroundChangeListener> foregroundChangeListeners = new CopyOnWriteArrayList();
    private final AtomicBoolean foreground = new AtomicBoolean(false);
    private volatile boolean paused = true;

    public AndroidPlatformState(Application application, TaskExecutor taskExecutor, LDLogger logger) {
        this.application = application;
        this.taskExecutor = taskExecutor;
        this.logger = logger;
        this.connectivityReceiver = new ConnectivityReceiver();
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        application.registerReceiver((BroadcastReceiver)this.connectivityReceiver, filter);
        if (application instanceof TestApplicationForegroundStateOverride) {
            this.foreground.set(((TestApplicationForegroundStateOverride)application).isTestFixtureInitiallyInForeground());
        } else {
            ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
            this.foreground.set(appProcessInfo.importance == 100 || appProcessInfo.importance == 200);
        }
        this.lifecycleCallbacks = new ActivityCallbacks();
        application.registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
    }

    @Override
    public boolean isNetworkAvailable() {
        try {
            ConnectivityManager cm = (ConnectivityManager)this.application.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                Network net = cm.getActiveNetwork();
                if (net == null) {
                    return false;
                }
                NetworkCapabilities nwc = cm.getNetworkCapabilities(net);
                return nwc != null && (nwc.hasTransport(1) || nwc.hasTransport(0) || nwc.hasTransport(3) || nwc.hasTransport(2) || nwc.hasTransport(4));
            }
            NetworkInfo active = cm.getActiveNetworkInfo();
            return active != null && active.isConnectedOrConnecting();
        }
        catch (SecurityException ignored) {
            return true;
        }
    }

    @Override
    public void addConnectivityChangeListener(PlatformState.ConnectivityChangeListener listener) {
        this.connectivityChangeListeners.add(listener);
    }

    @Override
    public void removeConnectivityChangeListener(PlatformState.ConnectivityChangeListener listener) {
        this.connectivityChangeListeners.remove(listener);
    }

    @Override
    public boolean isForeground() {
        return this.foreground.get();
    }

    @Override
    public void addForegroundChangeListener(PlatformState.ForegroundChangeListener listener) {
        this.foregroundChangeListeners.add(listener);
    }

    @Override
    public void removeForegroundChangeListener(PlatformState.ForegroundChangeListener listener) {
        this.foregroundChangeListeners.remove(listener);
    }

    @Override
    public File getCacheDir() {
        return this.application.getCacheDir();
    }

    @Override
    public void close() {
        this.connectivityChangeListeners.clear();
        this.foregroundChangeListeners.clear();
        try {
            this.application.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.application.unregisterActivityLifecycleCallbacks(this.lifecycleCallbacks);
    }

    private final class ConnectivityReceiver
    extends BroadcastReceiver {
        static final String CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
        private boolean knownState = false;
        private boolean lastState = false;

        private ConnectivityReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            boolean connectionStatus;
            if (!CONNECTIVITY_CHANGE.equals(intent.getAction())) {
                return;
            }
            ConnectivityReceiver connectivityReceiver = this;
            synchronized (connectivityReceiver) {
                connectionStatus = AndroidPlatformState.this.isNetworkAvailable();
                if (this.knownState && this.lastState == connectionStatus) {
                    return;
                }
                this.knownState = true;
                this.lastState = connectionStatus;
            }
            for (PlatformState.ConnectivityChangeListener listener : AndroidPlatformState.this.connectivityChangeListeners) {
                listener.onConnectivityChanged(connectionStatus);
            }
        }
    }

    static interface TestApplicationForegroundStateOverride {
        public boolean isTestFixtureInitiallyInForeground();
    }

    private final class ActivityCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private static final int WAIT_AFTER_PAUSED_MILLIS = 500;
        private volatile ScheduledFuture<?> deferredOnPauseTask = null;

        private ActivityCallbacks() {
        }

        public void onActivityResumed(Activity activity) {
            AndroidPlatformState.this.paused = false;
            boolean wasForeground = AndroidPlatformState.this.foreground.getAndSet(true);
            if (wasForeground) {
                AndroidPlatformState.this.logger.debug((Object)"activity resumed while already in foreground");
            } else {
                AndroidPlatformState.this.logger.debug((Object)"activity resumed, we are now in foreground");
                AndroidPlatformState.this.taskExecutor.scheduleTask(() -> {
                    for (PlatformState.ForegroundChangeListener listener : AndroidPlatformState.this.foregroundChangeListeners) {
                        listener.onForegroundChanged(true);
                    }
                }, 0L);
            }
        }

        public void onActivityPaused(Activity activity) {
            if (!AndroidPlatformState.this.foreground.get()) {
                return;
            }
            AndroidPlatformState.this.paused = true;
            if (this.deferredOnPauseTask != null) {
                this.deferredOnPauseTask.cancel(false);
            }
            AndroidPlatformState.this.logger.debug((Object)"activity paused; waiting to see if another activity resumes");
            this.deferredOnPauseTask = AndroidPlatformState.this.taskExecutor.scheduleTask(() -> {
                if (!AndroidPlatformState.this.paused) {
                    return;
                }
                if (AndroidPlatformState.this.foreground.getAndSet(false)) {
                    AndroidPlatformState.this.logger.debug((Object)"went background");
                    for (PlatformState.ForegroundChangeListener listener : AndroidPlatformState.this.foregroundChangeListeners) {
                        listener.onForegroundChanged(false);
                    }
                }
            }, 500L);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

