/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.helpdesk.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.helpdesk.v1.model.AgentEmailAgentResp;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentReq;
import com.lark.oapi.service.helpdesk.v1.model.PatchAgentResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private static final Logger log = LoggerFactory.getLogger(Agent.class);
    private final Config config;

    public Agent(Config config) {
        this.config = config;
    }

    public AgentEmailAgentResp agentEmail(RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_emails", Sets.newHashSet(AccessTokenType.Tenant), null);
        AgentEmailAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, AgentEmailAgentResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_emails", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        return resp;
    }

    public AgentEmailAgentResp agentEmail() throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_emails", Sets.newHashSet(AccessTokenType.Tenant), null);
        AgentEmailAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, AgentEmailAgentResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_emails", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        return resp;
    }

    public PatchAgentResp patch(PatchAgentReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id", Sets.newHashSet(AccessTokenType.User), req);
        PatchAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public PatchAgentResp patch(PatchAgentReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PATCH", "/open-apis/helpdesk/v1/agents/:agent_id", Sets.newHashSet(AccessTokenType.User), req);
        PatchAgentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAgentResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agents/:agent_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

