/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.card;

import com.lark.oapi.card.exception.HandlerNotFoundException;
import com.lark.oapi.card.model.CardAction;
import com.lark.oapi.card.model.CustomResponse;
import com.lark.oapi.core.IHandler;
import com.lark.oapi.core.exception.DecryptException;
import com.lark.oapi.core.exception.IllegalHttpStatusCodeException;
import com.lark.oapi.core.exception.IncorrectChallengeException;
import com.lark.oapi.core.exception.IncorrectSignatureException;
import com.lark.oapi.core.request.EventReq;
import com.lark.oapi.core.response.EventResp;
import com.lark.oapi.core.utils.Decryptor;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.event.model.Fuzzy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardActionHandler
implements IHandler {
    private static final Logger log = LoggerFactory.getLogger(CardActionHandler.class);
    private String verificationToken;
    private String encryptKey;
    private ICardHandler cardHandler;

    public CardActionHandler(Builder builder) {
        this.verificationToken = builder.verificationToken;
        this.encryptKey = builder.encryptKey;
        this.cardHandler = builder.cardHandler;
    }

    public static Builder newBuilder(String verificationToken, String encryptKey, ICardHandler cardHandler) {
        return new Builder(verificationToken, encryptKey, cardHandler);
    }

    private boolean verifySign(EventReq eventReq) throws NoSuchAlgorithmException {
        if (Strings.isEmpty(this.verificationToken)) {
            return true;
        }
        String cipherEventJsonStr = new String(eventReq.getBody(), StandardCharsets.UTF_8);
        String timestamp = eventReq.getHeaderFirstValue("X-Lark-Request-Timestamp");
        String nonce = eventReq.getHeaderFirstValue("X-Lark-Request-Nonce");
        String sourceSign = eventReq.getHeaderFirstValue("X-Lark-Signature");
        String targetSign = this.calculateSignature(timestamp, nonce, this.verificationToken, cipherEventJsonStr);
        return targetSign.equals(sourceSign);
    }

    protected String calculateSignature(String timestamp, String nonce, String token, String bodyString) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        String s = timestamp + nonce + token + bodyString;
        byte[] digest = messageDigest.digest(s.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString().toLowerCase();
    }

    private EventResp buildResult(Object result) {
        EventResp eventResp = new EventResp();
        eventResp.setStatusCode(200);
        eventResp.setContentType("application/json; charset=utf-8");
        if (result == null) {
            eventResp.setBody(String.format("{\"msg\":\"%s\"}", "success").getBytes(StandardCharsets.UTF_8));
            return eventResp;
        }
        if (result instanceof String) {
            eventResp.setBody(((String)result).getBytes(StandardCharsets.UTF_8));
            return eventResp;
        }
        if (result instanceof CustomResponse) {
            if (((CustomResponse)result).getStatusCode() == 0) {
                throw new IllegalHttpStatusCodeException(0);
            }
            eventResp.setStatusCode(((CustomResponse)result).getStatusCode());
            eventResp.setBody(Jsons.DEFAULT.toJson(((CustomResponse)result).getBody()).getBytes(StandardCharsets.UTF_8));
            eventResp.setHeaders(((CustomResponse)result).getHeaders());
            return eventResp;
        }
        eventResp.setBody(Jsons.DEFAULT.toJson(result).getBytes(StandardCharsets.UTF_8));
        return eventResp;
    }

    @Override
    public EventResp handle(EventReq eventReq) throws Throwable {
        EventResp eventResp = new EventResp();
        eventResp.setStatusCode(200);
        eventResp.setContentType("Content-Type");
        try {
            String plain = this.decrypt(eventReq.getBody());
            CardAction cardAction = (CardAction)Jsons.DEFAULT.fromJson(plain, CardAction.class);
            cardAction.setEventReq(eventReq);
            if ("url_verification".equals(cardAction.getType())) {
                if (!this.verificationToken.equals(cardAction.getToken())) {
                    throw new IncorrectChallengeException();
                }
                eventResp.setBody(String.format("{\"challenge\":\"%s\"}", cardAction.getChallenge()).getBytes(StandardCharsets.UTF_8));
                return eventResp;
            }
            if (!"url_verification".equals(cardAction.getType()) && !this.verifySign(eventReq)) {
                throw new IncorrectSignatureException();
            }
            if (this.cardHandler == null) {
                throw new HandlerNotFoundException();
            }
            Object result = this.cardHandler.handle(cardAction);
            return this.buildResult(result);
        }
        catch (Throwable e) {
            log.error("handle card action failed,requestId:{},err:{}", (Object)eventReq.getRequestID(), (Object)e);
            if (e instanceof HandlerNotFoundException) {
                eventResp.setBody(String.format("{\"msg\":\"%s\"}", e.getMessage()).getBytes(StandardCharsets.UTF_8));
                return eventResp;
            }
            eventResp.setStatusCode(500);
            eventResp.setBody(String.format("{\"msg\":\"%s\"}", e.getMessage()).getBytes(StandardCharsets.UTF_8));
            return eventResp;
        }
    }

    public String decrypt(byte[] bs) {
        String plain;
        String text = new String(bs, StandardCharsets.UTF_8);
        Fuzzy fuzzy = (Fuzzy)Jsons.DEFAULT.fromJson(text, Fuzzy.class);
        if (fuzzy != null && Strings.isNotEmpty(fuzzy.getEncrypt())) {
            if (Strings.isEmpty(this.encryptKey)) {
                throw new DecryptException("encrypt_key not found");
            }
            plain = new Decryptor(this.encryptKey).decrypt(fuzzy.getEncrypt());
        } else {
            plain = text;
        }
        return plain;
    }

    public static class Builder {
        private Map<String, IEventHandler> eventType2EventHandler = new HashMap<String, IEventHandler>();
        private String verificationToken;
        private String encryptKey;
        private ICardHandler cardHandler;

        public Builder(String verificationToken, String encryptKey, ICardHandler cardHandler) {
            this.verificationToken = verificationToken;
            this.encryptKey = encryptKey;
            this.cardHandler = cardHandler;
        }

        public CardActionHandler build() {
            return new CardActionHandler(this);
        }
    }

    public static interface ICardHandler {
        public Object handle(CardAction var1) throws Throwable;
    }
}

