/*
 * Decompiled with CFR 0.152.
 */
package com.weavey.loading.lib;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.weavey.loading.lib.R;
import com.weavey.loading.lib.Utils;

public class LoadingLayout
extends FrameLayout {
    public static final int Success = 0;
    public static final int Empty = 1;
    public static final int Error = 2;
    public static final int No_Network = 3;
    public static final int Loading = 4;
    private int state;
    private Context mContext;
    private View loadingPage;
    private View errorPage;
    private View emptyPage;
    private View networkPage;
    private View defineLoadingPage;
    private ImageView errorImg;
    private ImageView emptyImg;
    private ImageView networkImg;
    private TextView errorText;
    private TextView emptyText;
    private TextView networkText;
    private TextView errorReloadBtn;
    private TextView networkReloadBtn;
    private View contentView;
    private OnReloadListener listener;
    private boolean isFirstVisible;
    private static Config mConfig = new Config();
    private static String emptyStr = "\u6682\u65e0\u6570\u636e";
    private static String errorStr = "\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u00b7\u00b7\u00b7";
    private static String netwrokStr = "\u65e0\u7f51\u7edc\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u00b7\u00b7\u00b7";
    private static String reloadBtnStr = "\u70b9\u51fb\u91cd\u8bd5";
    private static int emptyImgId = R.mipmap.empty;
    private static int errorImgId = R.mipmap.error;
    private static int networkImgId = R.mipmap.no_network;
    private static int reloadBtnId = R.drawable.selector_btn_back_gray;
    private static int tipTextSize = 14;
    private static int buttonTextSize = 14;
    private static int tipTextColor = R.color.base_text_color_light;
    private static int buttonTextColor = R.color.base_text_color_light;
    private static int buttonWidth = -1;
    private static int buttonHeight = -1;
    private static int loadingLayoutId = R.layout.widget_loading_page;
    private static int backgroundColor = R.color.base_loading_background;

    public LoadingLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadingLayout);
        this.isFirstVisible = a.getBoolean(R.styleable.LoadingLayout_isFirstVisible, false);
        a.recycle();
    }

    public LoadingLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
    }

    public LoadingLayout(Context context) {
        super(context);
        this.mContext = context;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 1) {
            throw new IllegalStateException("LoadingLayout can host only one direct child");
        }
        this.contentView = this.getChildAt(0);
        if (!this.isFirstVisible) {
            this.contentView.setVisibility(8);
        }
        this.build();
    }

    private void build() {
        this.loadingPage = LayoutInflater.from((Context)this.mContext).inflate(loadingLayoutId, null);
        this.errorPage = LayoutInflater.from((Context)this.mContext).inflate(R.layout.widget_error_page, null);
        this.emptyPage = LayoutInflater.from((Context)this.mContext).inflate(R.layout.widget_empty_page, null);
        this.networkPage = LayoutInflater.from((Context)this.mContext).inflate(R.layout.widget_nonetwork_page, null);
        this.defineLoadingPage = null;
        this.loadingPage.setBackgroundColor(Utils.getColor(this.mContext, backgroundColor));
        this.errorPage.setBackgroundColor(Utils.getColor(this.mContext, backgroundColor));
        this.emptyPage.setBackgroundColor(Utils.getColor(this.mContext, backgroundColor));
        this.networkPage.setBackgroundColor(Utils.getColor(this.mContext, backgroundColor));
        this.errorText = (TextView)Utils.findViewById(this.errorPage, R.id.error_text);
        this.emptyText = (TextView)Utils.findViewById(this.emptyPage, R.id.empty_text);
        this.networkText = (TextView)Utils.findViewById(this.networkPage, R.id.no_network_text);
        this.errorImg = (ImageView)Utils.findViewById(this.errorPage, R.id.error_img);
        this.emptyImg = (ImageView)Utils.findViewById(this.emptyPage, R.id.empty_img);
        this.networkImg = (ImageView)Utils.findViewById(this.networkPage, R.id.no_network_img);
        this.errorReloadBtn = (TextView)Utils.findViewById(this.errorPage, R.id.error_reload_btn);
        this.networkReloadBtn = (TextView)Utils.findViewById(this.networkPage, R.id.no_network_reload_btn);
        this.errorReloadBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LoadingLayout.this.listener != null) {
                    LoadingLayout.this.listener.onReload(v);
                }
            }
        });
        this.networkReloadBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LoadingLayout.this.listener != null) {
                    LoadingLayout.this.listener.onReload(v);
                }
            }
        });
        this.errorText.setText((CharSequence)errorStr);
        this.emptyText.setText((CharSequence)emptyStr);
        this.networkText.setText((CharSequence)netwrokStr);
        this.errorText.setTextSize((float)tipTextSize);
        this.emptyText.setTextSize((float)tipTextSize);
        this.networkText.setTextSize((float)tipTextSize);
        this.errorText.setTextColor(Utils.getColor(this.mContext, tipTextColor));
        this.emptyText.setTextColor(Utils.getColor(this.mContext, tipTextColor));
        this.networkText.setTextColor(Utils.getColor(this.mContext, tipTextColor));
        this.errorImg.setImageResource(errorImgId);
        this.emptyImg.setImageResource(emptyImgId);
        this.networkImg.setImageResource(networkImgId);
        this.errorReloadBtn.setBackgroundResource(reloadBtnId);
        this.networkReloadBtn.setBackgroundResource(reloadBtnId);
        this.errorReloadBtn.setText((CharSequence)reloadBtnStr);
        this.networkReloadBtn.setText((CharSequence)reloadBtnStr);
        this.errorReloadBtn.setTextSize((float)buttonTextSize);
        this.networkReloadBtn.setTextSize((float)buttonTextSize);
        this.errorReloadBtn.setTextColor(Utils.getColor(this.mContext, buttonTextColor));
        this.networkReloadBtn.setTextColor(Utils.getColor(this.mContext, buttonTextColor));
        if (buttonHeight != -1) {
            this.errorReloadBtn.setHeight(Utils.dp2px(this.mContext, buttonHeight));
            this.networkReloadBtn.setHeight(Utils.dp2px(this.mContext, buttonHeight));
        }
        if (buttonWidth != -1) {
            this.errorReloadBtn.setWidth(Utils.dp2px(this.mContext, buttonWidth));
            this.networkReloadBtn.setWidth(Utils.dp2px(this.mContext, buttonWidth));
        }
        this.addView(this.networkPage);
        this.addView(this.emptyPage);
        this.addView(this.errorPage);
        this.addView(this.loadingPage);
    }

    public void setStatus(@Flavour int status) {
        this.state = status;
        switch (status) {
            case 0: {
                this.contentView.setVisibility(0);
                this.emptyPage.setVisibility(8);
                this.errorPage.setVisibility(8);
                this.networkPage.setVisibility(8);
                if (this.defineLoadingPage != null) {
                    this.defineLoadingPage.setVisibility(8);
                    break;
                }
                this.loadingPage.setVisibility(8);
                break;
            }
            case 4: {
                this.contentView.setVisibility(8);
                this.emptyPage.setVisibility(8);
                this.errorPage.setVisibility(8);
                this.networkPage.setVisibility(8);
                if (this.defineLoadingPage != null) {
                    this.defineLoadingPage.setVisibility(0);
                    break;
                }
                this.loadingPage.setVisibility(0);
                break;
            }
            case 1: {
                this.contentView.setVisibility(8);
                this.emptyPage.setVisibility(0);
                this.errorPage.setVisibility(8);
                this.networkPage.setVisibility(8);
                if (this.defineLoadingPage != null) {
                    this.defineLoadingPage.setVisibility(8);
                    break;
                }
                this.loadingPage.setVisibility(8);
                break;
            }
            case 2: {
                this.contentView.setVisibility(8);
                this.loadingPage.setVisibility(8);
                this.emptyPage.setVisibility(8);
                this.errorPage.setVisibility(0);
                this.networkPage.setVisibility(8);
                if (this.defineLoadingPage != null) {
                    this.defineLoadingPage.setVisibility(8);
                    break;
                }
                this.loadingPage.setVisibility(8);
                break;
            }
            case 3: {
                this.contentView.setVisibility(8);
                this.loadingPage.setVisibility(8);
                this.emptyPage.setVisibility(8);
                this.errorPage.setVisibility(8);
                this.networkPage.setVisibility(0);
                if (this.defineLoadingPage != null) {
                    this.defineLoadingPage.setVisibility(8);
                    break;
                }
                this.loadingPage.setVisibility(8);
                break;
            }
        }
    }

    public int getStatus() {
        return this.state;
    }

    public LoadingLayout setEmptyText(String text) {
        this.emptyText.setText((CharSequence)text);
        return this;
    }

    public LoadingLayout setErrorText(String text) {
        this.errorText.setText((CharSequence)text);
        return this;
    }

    public LoadingLayout setNoNetworkText(String text) {
        this.networkText.setText((CharSequence)text);
        return this;
    }

    public LoadingLayout setEmptyImage(@DrawableRes int id2) {
        this.emptyImg.setImageResource(id2);
        return this;
    }

    public LoadingLayout setErrorImage(@DrawableRes int id2) {
        this.errorImg.setImageResource(id2);
        return this;
    }

    public LoadingLayout setNoNetworkImage(@DrawableRes int id2) {
        this.networkImg.setImageResource(id2);
        return this;
    }

    public LoadingLayout setEmptyTextSize(int sp) {
        this.emptyText.setTextSize((float)sp);
        return this;
    }

    public LoadingLayout setErrorTextSize(int sp) {
        this.errorText.setTextSize((float)sp);
        return this;
    }

    public LoadingLayout setNoNetworkTextSize(int sp) {
        this.networkText.setTextSize((float)sp);
        return this;
    }

    public LoadingLayout setEmptyImageVisible(boolean bool) {
        if (bool) {
            this.emptyImg.setVisibility(0);
        } else {
            this.emptyImg.setVisibility(8);
        }
        return this;
    }

    public LoadingLayout setErrorImageVisible(boolean bool) {
        if (bool) {
            this.errorImg.setVisibility(0);
        } else {
            this.errorImg.setVisibility(8);
        }
        return this;
    }

    public LoadingLayout setNoNetworkImageVisible(boolean bool) {
        if (bool) {
            this.networkImg.setVisibility(0);
        } else {
            this.networkImg.setVisibility(8);
        }
        return this;
    }

    public LoadingLayout setReloadButtonText(@NonNull String text) {
        this.errorReloadBtn.setText((CharSequence)text);
        this.networkReloadBtn.setText((CharSequence)text);
        return this;
    }

    public LoadingLayout setReloadButtonTextSize(int sp) {
        this.errorReloadBtn.setTextSize((float)sp);
        this.networkReloadBtn.setTextSize((float)sp);
        return this;
    }

    public LoadingLayout setReloadButtonTextColor(@ColorRes int id2) {
        this.errorReloadBtn.setTextColor(Utils.getColor(this.mContext, id2));
        this.networkReloadBtn.setTextSize((float)Utils.getColor(this.mContext, id2));
        return this;
    }

    public LoadingLayout setReloadButtonBackgroundResource(@DrawableRes int id2) {
        this.errorReloadBtn.setBackgroundResource(id2);
        this.networkReloadBtn.setBackgroundResource(id2);
        return this;
    }

    public LoadingLayout setOnReloadListener(OnReloadListener listener) {
        this.listener = listener;
        return this;
    }

    public LoadingLayout setLoadingPage(View view) {
        this.defineLoadingPage = view;
        this.removeView(this.loadingPage);
        this.defineLoadingPage.setVisibility(8);
        this.addView(view);
        return this;
    }

    public LoadingLayout setLoadingPage(@LayoutRes int id2) {
        View view;
        this.removeView(this.loadingPage);
        this.defineLoadingPage = view = LayoutInflater.from((Context)this.mContext).inflate(id2, null);
        this.defineLoadingPage.setVisibility(8);
        this.addView(view);
        return this;
    }

    public View getLoadingPage() {
        return this.defineLoadingPage;
    }

    public View getGlobalLoadingPage() {
        return this.loadingPage;
    }

    public static Config getConfig() {
        return mConfig;
    }

    public static class Config {
        public Config setErrorText(@NonNull String text) {
            errorStr = text;
            return mConfig;
        }

        public Config setEmptyText(@NonNull String text) {
            emptyStr = text;
            return mConfig;
        }

        public Config setNoNetworkText(@NonNull String text) {
            netwrokStr = text;
            return mConfig;
        }

        public Config setReloadButtonText(@NonNull String text) {
            reloadBtnStr = text;
            return mConfig;
        }

        public Config setAllTipTextSize(int sp) {
            tipTextSize = sp;
            return mConfig;
        }

        public Config setAllTipTextColor(@ColorRes int color2) {
            tipTextColor = color2;
            return mConfig;
        }

        public Config setReloadButtonTextSize(int sp) {
            buttonTextSize = sp;
            return mConfig;
        }

        public Config setReloadButtonTextColor(@ColorRes int color2) {
            buttonTextColor = color2;
            return mConfig;
        }

        public Config setReloadButtonBackgroundResource(@DrawableRes int id2) {
            reloadBtnId = id2;
            return mConfig;
        }

        public Config setReloadButtonWidthAndHeight(int width_dp, int height_dp) {
            buttonWidth = width_dp;
            buttonHeight = height_dp;
            return mConfig;
        }

        public Config setErrorImage(@DrawableRes int id2) {
            errorImgId = id2;
            return mConfig;
        }

        public Config setEmptyImage(@DrawableRes int id2) {
            emptyImgId = id2;
            return this;
        }

        public Config setNoNetworkImage(@DrawableRes int id2) {
            networkImgId = id2;
            return mConfig;
        }

        public Config setLoadingPageLayout(@LayoutRes int id2) {
            loadingLayoutId = id2;
            return mConfig;
        }

        public Config setAllPageBackgroundColor(@ColorRes int color2) {
            backgroundColor = color2;
            return mConfig;
        }
    }

    public static interface OnReloadListener {
        public void onReload(View var1);
    }

    public static @interface Flavour {
    }
}

