/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.architecture.ui.page;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.kunminx.architecture.BaseApplication;
import com.kunminx.architecture.ui.page.DataBindingConfig;
import com.kunminx.strictdatabinding.R;

public abstract class DataBindingActivity
extends AppCompatActivity {
    private ViewModelProvider mActivityProvider;
    private ViewModelProvider.Factory mFactory;
    private ViewDataBinding mBinding;
    private TextView mTvStrictModeTip;

    protected abstract void initViewModel();

    protected abstract DataBindingConfig getDataBindingConfig();

    protected ViewDataBinding getBinding() {
        if (this.isDebug() && this.mBinding != null && this.mTvStrictModeTip == null) {
            this.mTvStrictModeTip = new TextView(this.getApplicationContext());
            this.mTvStrictModeTip.setAlpha(0.5f);
            this.mTvStrictModeTip.setTextSize(16.0f);
            this.mTvStrictModeTip.setBackgroundColor(-1);
            this.mTvStrictModeTip.setText(R.string.debug_activity_databinding_warning);
            ((ViewGroup)this.mBinding.getRoot()).addView((View)this.mTvStrictModeTip);
        }
        return this.mBinding;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initViewModel();
        DataBindingConfig dataBindingConfig = this.getDataBindingConfig();
        ViewDataBinding binding = DataBindingUtil.setContentView((Activity)this, (int)dataBindingConfig.getLayout());
        binding.setLifecycleOwner((LifecycleOwner)this);
        binding.setVariable(dataBindingConfig.getVmVariableId(), (Object)dataBindingConfig.getStateViewModel());
        SparseArray bindingParams = dataBindingConfig.getBindingParams();
        int length = bindingParams.size();
        for (int i = 0; i < length; ++i) {
            binding.setVariable(bindingParams.keyAt(i), bindingParams.valueAt(i));
        }
        this.mBinding = binding;
    }

    public boolean isDebug() {
        return this.getApplicationContext().getApplicationInfo() != null && (this.getApplicationContext().getApplicationInfo().flags & 2) != 0;
    }

    protected void showLongToast(String text) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)text, (int)1).show();
    }

    protected void showShortToast(String text) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)text, (int)0).show();
    }

    protected void showLongToast(int stringRes) {
        this.showLongToast(this.getApplicationContext().getString(stringRes));
    }

    protected void showShortToast(int stringRes) {
        this.showShortToast(this.getApplicationContext().getString(stringRes));
    }

    protected <T extends ViewModel> T getActivityViewModel(@NonNull Class<T> modelClass) {
        if (this.mActivityProvider == null) {
            this.mActivityProvider = new ViewModelProvider((ViewModelStoreOwner)this);
        }
        return (T)this.mActivityProvider.get(modelClass);
    }

    protected ViewModelProvider getAppViewModelProvider() {
        return new ViewModelProvider((ViewModelStoreOwner)((BaseApplication)this.getApplicationContext()), this.getAppFactory((Activity)this));
    }

    private ViewModelProvider.Factory getAppFactory(Activity activity) {
        Application application = this.checkApplication(activity);
        if (this.mFactory == null) {
            this.mFactory = ViewModelProvider.AndroidViewModelFactory.getInstance((Application)application);
        }
        return this.mFactory;
    }

    private Application checkApplication(Activity activity) {
        Application application = activity.getApplication();
        if (application == null) {
            throw new IllegalStateException("Your activity/fragment is not yet attached to Application. You can't request ViewModel before onCreate call.");
        }
        return application;
    }
}

