/*
 * Decompiled with CFR 0.152.
 */
package com.kotlex.system.android;

import android.content.res.AssetManager;
import com.kotlex.system.io.BufferedOutputStreamKt;
import com.kotlex.system.io.ClosableKt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0006\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u001a\u0010\b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"FILE_ANDROID_ASSET", "", "isAssetAvailable", "", "Landroid/content/res/AssetManager;", "assetPath", "isAssetPath", "src", "tryCopy", "target", "Ljava/io/File;", "system_release"})
public final class AssetManagerKt {
    private static final String FILE_ANDROID_ASSET = "file:///android_asset/";

    public static final boolean isAssetPath(@NotNull AssetManager $receiver, @NotNull String src) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        return StringsKt.startsWith$default((String)src, (String)FILE_ANDROID_ASSET, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isAssetAvailable(@NotNull AssetManager $receiver, @NotNull String assetPath) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)assetPath, (String)"assetPath");
        if (!StringsKt.startsWith$default((String)assetPath, (String)FILE_ANDROID_ASSET, (boolean)false, (int)2, null)) {
            return false;
        }
        InputStream inputStream = null;
        boolean success = false;
        try {
            inputStream = $receiver.open(assetPath);
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                ClosableKt.closeCatched(inputStream2);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static final boolean tryCopy(@NotNull AssetManager $receiver, @NotNull String assetPath, @NotNull File target) {
        InputStream inputStream;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)assetPath, (String)"assetPath");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        InputStream inputStream2 = null;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream2 = $receiver.open(assetPath);
            bufferedInputStream = new BufferedInputStream($receiver.open(assetPath));
            fileOutputStream = new FileOutputStream(target);
            BufferedOutputStreamKt.writeTo$default(bufferedInputStream, fileOutputStream, 0, 2, null);
            bl = true;
            inputStream = inputStream2;
        }
        catch (Exception exception) {
            InputStream inputStream3 = inputStream2;
            if (inputStream3 != null) {
                ClosableKt.closeCatched(inputStream3);
            }
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            if (bufferedInputStream2 != null) {
                ClosableKt.closeCatched(bufferedInputStream2);
            }
            FileOutputStream fileOutputStream2 = fileOutputStream;
            if (fileOutputStream2 != null) {
                ClosableKt.closeCatched(fileOutputStream2);
            }
            catch (Throwable throwable) {
                InputStream inputStream4 = inputStream2;
                if (inputStream4 != null) {
                    ClosableKt.closeCatched(inputStream4);
                }
                BufferedInputStream bufferedInputStream3 = bufferedInputStream;
                if (bufferedInputStream3 != null) {
                    ClosableKt.closeCatched(bufferedInputStream3);
                }
                FileOutputStream fileOutputStream3 = fileOutputStream;
                if (fileOutputStream3 != null) {
                    ClosableKt.closeCatched(fileOutputStream3);
                }
                throw throwable;
            }
        }
        if (inputStream != null) {
            ClosableKt.closeCatched(inputStream);
        }
        ClosableKt.closeCatched(bufferedInputStream);
        ClosableKt.closeCatched(fileOutputStream);
        return bl;
        return false;
    }
}

