/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http.data;

import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.data.AbstractEntityData;
import com.kontakt.sdk.android.http.data.EntityData;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class VenueData
extends AbstractEntityData {
    private static final String VENUE_ID_PARAMETER = "venueId";
    private static final String NAME_PARAMETER = "name";
    private static final String DESCRIPTION_PARAMETER = "description";
    private static final String LAT_PARAMETER = "lat";
    private static final String LNG_PARAMETER = "lng";

    private VenueData(EntityData entityData) {
        super(entityData);
    }

    public static Builder create(String name, String description) {
        SDKPreconditions.checkNotNullOrEmpty((String)name, (String)"Venue name is null");
        SDKPreconditions.checkNotNullOrEmpty((String)description, (String)"Venue description is null");
        return new Builder(name, description);
    }

    public static Builder update(UUID venueId) {
        SDKPreconditions.checkNotNull((Object)venueId, (Object)"Venue Id is null.");
        return new Builder(venueId);
    }

    public static final class Builder {
        private final EntityData.Builder builder = new EntityData.Builder();

        private Builder(UUID venueId) {
            this.builder.addParameter(VenueData.VENUE_ID_PARAMETER, venueId.toString());
        }

        private Builder(String name, String description) {
            this.builder.addParameter(VenueData.NAME_PARAMETER, name).addParameter(VenueData.DESCRIPTION_PARAMETER, description);
        }

        public Builder withName(String name) {
            this.builder.addParameter(VenueData.NAME_PARAMETER, name);
            return this;
        }

        public Builder withDescription(String description) {
            this.builder.addParameter(VenueData.DESCRIPTION_PARAMETER, description);
            return this;
        }

        public Builder withCoverFile(File file, SDKFunction<byte[], String> convertFunction) throws IOException {
            SDKPreconditions.checkNotNull((Object)file, (Object)"File is null.");
            SDKPreconditions.checkNotNull((Object)file.exists(), (Object)"File does not exist");
            SDKPreconditions.checkNotNull(convertFunction, (Object)"Convert Function is null.");
            byte[] bytes = ConversionUtils.convert((File)file);
            this.builder.addParameter("file", (String)convertFunction.apply((Object)bytes));
            return this;
        }

        public Builder withLatitude(String lat) {
            this.builder.addParameter(VenueData.LAT_PARAMETER, lat);
            return this;
        }

        public Builder withLongitude(String lng) {
            this.builder.addParameter(VenueData.LNG_PARAMETER, lng);
            return this;
        }

        public VenueData build() {
            return new VenueData(this.builder.build());
        }
    }
}

