/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http.data;

import android.text.TextUtils;
import com.kontakt.sdk.android.common.interfaces.SDKFunction;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.HttpUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EntityData {
    private final List<Map.Entry<String, String>> parameterList;

    private EntityData(Builder builder) {
        this.parameterList = Collections.unmodifiableList(builder.argumentList);
    }

    List<Map.Entry<String, String>> getParameters() {
        return this.parameterList;
    }

    public static final class Builder {
        private List<Map.Entry<String, String>> argumentList = new ArrayList<Map.Entry<String, String>>();

        public Builder addParameter(String name, String value) {
            this.argumentList.add(HttpUtils.toUrlParameter((String)name, (String)value));
            return this;
        }

        public Builder addParameterIfNotNull(String name, String value) {
            if (name != null && value != null) {
                return this.addParameter(name, value);
            }
            return this;
        }

        public Builder addParameter(String name, int value) {
            return this.addParameter(name, String.valueOf(value));
        }

        public Builder addParameter(String name, UUID value) {
            if (value != null) {
                this.addParameter(name, value.toString());
            }
            return this;
        }

        public Builder addParameter(String name, double value) {
            return this.addParameter(name, String.valueOf(value));
        }

        public Builder addParameter(String name, boolean value) {
            return this.addParameter(name, String.valueOf(value));
        }

        public Builder addParameter(String name, File file, SDKFunction<byte[], String> convertFunction) throws IOException {
            SDKPreconditions.checkNotNull((Object)file, (Object)"File is null.");
            SDKPreconditions.checkState((boolean)file.exists(), (Object)"File does not exist");
            SDKPreconditions.checkNotNull(convertFunction, (Object)"Convert function is null.");
            byte[] fileData = ConversionUtils.convert((File)file);
            return this.addParameter(name, (String)convertFunction.apply((Object)fileData));
        }

        public Builder addParameter(String name, Collection<String> collection) {
            SDKPreconditions.checkNotNull(collection, (Object)"Collection is null.");
            String value = TextUtils.join((CharSequence)",", collection);
            return this.addParameter(name, value);
        }

        public EntityData build() {
            return new EntityData(this);
        }
    }
}

