/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http.data;

import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.ICloudBeacon;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.data.AbstractEntityData;
import com.kontakt.sdk.android.http.data.EntityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public final class DeviceData
extends AbstractEntityData {
    private static final String DEVICE_TYPE_PARAMETER = "deviceType";
    private static final String UNIQUE_ID_PARAMETER = "uniqueId";
    private static final String PROXIMITY_PARAMETER = "proximity";
    private static final String MAJOR_PARAMETER = "major";
    private static final String MINOR_PARAMETER = "minor";
    private static final String PASSWORD_PARAMETER = "password";
    private static final String TX_POWER_PARAMETER = "txPower";
    private static final String INTERVAL_PARAMETER = "interval";
    private static final String ALIAS_PARAMETER = "alias";
    private static final String NAME_PARAMETER = "name";
    private static final String FIRMWARE_PARAMETER = "firmware";
    private static final String DEFAULT_SSID_AUTH_PARAMETER = "defaultSSIDAuth";
    private static final String DEFAULT_SSID_CRYPT_PARAMETER = "defaultSSIDCrypt";
    private static final String DEFAULT_SSID_NAME_PARAMETER = "defaultSSIDName";
    private static final String DEFAULT_SSID_KEY_PARAMETER = "defaultSSIDKey";
    private static final String WORKING_MODE_PARAMETER = "workingMode";
    private static final String WIFI_SCAN_INTERVAL_PARAMETER = "wifiScanInterval";
    private static final String DATA_SEND_INTERVAL_PARAMETER = "dataSendInterval";
    private static final String BLE_SCAN_INTERVAL_PARAMETER = "bleScanInterval";
    private static final String BLE_SCAN_DURATION_PARAMETER = "bleScanDuration";

    private DeviceData(EntityData entityData) {
        super(entityData);
    }

    public static Builder update(DeviceType deviceType, String uniqueId) {
        SDKPreconditions.checkNotNull((Object)deviceType, (Object)"Device type is null");
        SDKPreconditions.checkNotNullOrEmpty((String)uniqueId, (String)"Unique Id is null or empty");
        return new Builder(deviceType, uniqueId);
    }

    public static final class Builder {
        private final EntityData.Builder builder = new EntityData.Builder();

        private Builder(DeviceType deviceType, String uniqueId) {
            this.builder.addParameter(DeviceData.DEVICE_TYPE_PARAMETER, deviceType.name());
            this.builder.addParameter(DeviceData.UNIQUE_ID_PARAMETER, uniqueId);
        }

        public Builder withProximityUUID(UUID proximityUUID) {
            if (proximityUUID != null) {
                this.builder.addParameter(DeviceData.PROXIMITY_PARAMETER, proximityUUID.toString());
            }
            return this;
        }

        public Builder withMajor(int major) {
            this.builder.addParameter(DeviceData.MAJOR_PARAMETER, major);
            return this;
        }

        public Builder withMinor(int minor) {
            this.builder.addParameter(DeviceData.MINOR_PARAMETER, minor);
            return this;
        }

        public Builder withPassword(String password) {
            this.builder.addParameter(DeviceData.PASSWORD_PARAMETER, password);
            return this;
        }

        public Builder withTxPower(int txPower) {
            this.builder.addParameter(DeviceData.TX_POWER_PARAMETER, txPower);
            return this;
        }

        public Builder withInterval(int interval) {
            this.builder.addParameter(DeviceData.INTERVAL_PARAMETER, interval);
            return this;
        }

        public Builder withAlias(String alias) {
            this.builder.addParameter(DeviceData.ALIAS_PARAMETER, alias);
            return this;
        }

        public Builder withName(String name) {
            this.builder.addParameter(DeviceData.NAME_PARAMETER, name);
            return this;
        }

        public Builder withFirmware(String firmware) {
            this.builder.addParameter(DeviceData.FIRMWARE_PARAMETER, firmware);
            return this;
        }

        public Builder withDefaultSSIDAuth(String defaultSSIDAuth) {
            this.builder.addParameter(DeviceData.DEFAULT_SSID_AUTH_PARAMETER, defaultSSIDAuth);
            return this;
        }

        public Builder withDefaultSSIDCrypt(String defaultSSIDCrypt) {
            this.builder.addParameter(DeviceData.DEFAULT_SSID_CRYPT_PARAMETER, defaultSSIDCrypt);
            return this;
        }

        public Builder withDefaultSSIDName(String defaultSSIDName) {
            this.builder.addParameter(DeviceData.DEFAULT_SSID_NAME_PARAMETER, defaultSSIDName);
            return this;
        }

        public Builder withDefaultSSIDKey(String defaultSSIDKey) {
            this.builder.addParameter(DeviceData.DEFAULT_SSID_KEY_PARAMETER, defaultSSIDKey);
            return this;
        }

        public Builder withWorkingMode(ICloudBeacon.WorkingMode workingMode) {
            if (workingMode != null) {
                this.builder.addParameter(DeviceData.WORKING_MODE_PARAMETER, workingMode.name());
            }
            return this;
        }

        public Builder withWifiScanInterval(int wifiScanInterval) {
            this.builder.addParameter(DeviceData.WIFI_SCAN_INTERVAL_PARAMETER, wifiScanInterval);
            return this;
        }

        public Builder withDataSendInterval(int dataSendInterval) {
            this.builder.addParameter(DeviceData.DATA_SEND_INTERVAL_PARAMETER, dataSendInterval);
            return this;
        }

        public Builder withBleScanInterval(int bleScanInterval) {
            this.builder.addParameter(DeviceData.BLE_SCAN_INTERVAL_PARAMETER, bleScanInterval);
            return this;
        }

        public Builder withBleScanDuration(int bleScanDuration) {
            this.builder.addParameter(DeviceData.BLE_SCAN_DURATION_PARAMETER, bleScanDuration);
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.builder.addParameter("instanceId", instanceId);
            return this;
        }

        public Builder withLatitude(String latitude) {
            this.builder.addParameter("lat", latitude);
            return this;
        }

        public Builder withLongitude(String longitude) {
            this.builder.addParameter("lng", longitude);
            return this;
        }

        public Builder force(boolean force) {
            this.builder.addParameter("force", String.valueOf(force));
            return this;
        }

        public Builder withUrl(String url) {
            this.builder.addParameter("url", url);
            return this;
        }

        public Builder withNamespace(String namespace) {
            this.builder.addParameter("namespace", namespace);
            return this;
        }

        public Builder withDeviceProfiles(Collection<DeviceProfile> deviceProfiles) {
            ArrayList<String> deviceProfilesList = new ArrayList<String>();
            for (DeviceProfile deviceProfile : deviceProfiles) {
                deviceProfilesList.add(deviceProfile.name());
            }
            this.builder.addParameter("profiles", deviceProfilesList);
            return this;
        }

        public DeviceData build() {
            return new DeviceData(this.builder.build());
        }
    }
}

