/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http.data;

import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.ICloudBeacon;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.data.AbstractEntityData;
import com.kontakt.sdk.android.http.data.EntityData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

public final class ConfigData
extends AbstractEntityData {
    private static final String UNIQUE_ID_PARAMETER = "uniqueId";
    private static final String DEVICE_TYPE_PARAMETER = "deviceType";
    private static final String PROXIMITY_PARAMETER = "proximity";
    private static final String MAJOR_PARAMETER = "major";
    private static final String MINOR_PARAMETER = "minor";
    private static final String TX_POWER_PARAMETER = "txPower";
    private static final String INTERVAL_PARAMETER = "interval";
    private static final String PASSWORD_PARAMETER = "password";
    private static final String DEFAULT_SSID_NAME_PARAMETER = "defaultSSIDName";
    private static final String DEFAULT_SSID_KEY_PARAMETER = "defaultSSIDKey";
    private static final String DEFAULT_SSID_AUTH_PARAMETER = "defaultSSIDAuth";
    private static final String DEFAULT_SSID_CRYPT_PARAMETER = "defaultSSIDCrypt";
    private static final String WORKING_MODE_PARAMETER = "workingMode";
    private static final String WIFI_SCAN_INTERVAL_PARAMETER = "wifiScanInterval";
    private static final String DATA_SEND_INTERVAL_PARAMETER = "dataSendInterval";
    private static final String BLE_SCAN_INTERVAL_PARAMETER = "bleScanInterval";
    private static final String BLE_SCAN_DURATION_PARAMETER = "bleScanDuration";
    private static final String NAME_PARAMETER = "name";

    private ConfigData(EntityData entityData) {
        super(entityData);
    }

    public static Builder create(Collection<String> uniqueIds, DeviceType deviceType) {
        return new Builder(uniqueIds, deviceType);
    }

    public static Builder create(String uniqueId, DeviceType deviceType) {
        return ConfigData.create(Arrays.asList(uniqueId), deviceType);
    }

    public static Builder update(String uniqueId, DeviceType deviceType) {
        return ConfigData.update(Arrays.asList(uniqueId), deviceType);
    }

    public static Builder update(Collection<String> uniqueIds, DeviceType deviceType) {
        return new Builder(uniqueIds, deviceType);
    }

    public static final class Builder {
        private final EntityData.Builder builder = new EntityData.Builder();

        private Builder(Collection<String> uniqueIds, DeviceType deviceType) {
            SDKPreconditions.checkNotNullOrEmpty(uniqueIds, (String)"Unique Ids collection is empty");
            SDKPreconditions.checkNotNull((Object)deviceType, (Object)"Device type is null");
            for (String uniqueId : uniqueIds) {
                this.builder.addParameter(ConfigData.UNIQUE_ID_PARAMETER, uniqueId);
            }
            this.builder.addParameter(ConfigData.DEVICE_TYPE_PARAMETER, deviceType.name());
        }

        public Builder withProximityUUID(UUID proximityUUID) {
            SDKPreconditions.checkNotNull((Object)proximityUUID, (Object)"Proximity UUID is null.");
            this.builder.addParameter(ConfigData.PROXIMITY_PARAMETER, proximityUUID.toString());
            return this;
        }

        public Builder withMajor(int major) {
            this.builder.addParameter(ConfigData.MAJOR_PARAMETER, major);
            return this;
        }

        public Builder withMinor(int minor) {
            this.builder.addParameter(ConfigData.MINOR_PARAMETER, minor);
            return this;
        }

        public Builder withTxPower(int txPower) {
            this.builder.addParameter(ConfigData.TX_POWER_PARAMETER, txPower);
            return this;
        }

        public Builder withInterval(int interval) {
            this.builder.addParameter(ConfigData.INTERVAL_PARAMETER, interval);
            return this;
        }

        public Builder withPassword(String password) {
            this.builder.addParameter(ConfigData.PASSWORD_PARAMETER, password);
            return this;
        }

        public Builder withDefaultSSIDName(String defaultSSIDName) {
            this.builder.addParameter(ConfigData.DEFAULT_SSID_NAME_PARAMETER, defaultSSIDName);
            return this;
        }

        public Builder withDefaultSSIDKey(String defaultSSIDKey) {
            this.builder.addParameter(ConfigData.DEFAULT_SSID_KEY_PARAMETER, defaultSSIDKey);
            return this;
        }

        public Builder withDefaultSSIDAuth(String defaultSSIDAuth) {
            this.builder.addParameter(ConfigData.DEFAULT_SSID_AUTH_PARAMETER, defaultSSIDAuth);
            return this;
        }

        public Builder withDefaultSSIDCrypt(String defaultSSIDCrypt) {
            this.builder.addParameter(ConfigData.DEFAULT_SSID_CRYPT_PARAMETER, defaultSSIDCrypt);
            return this;
        }

        public Builder withWorkingMode(ICloudBeacon.WorkingMode workingMode) {
            this.builder.addParameterIfNotNull(ConfigData.WORKING_MODE_PARAMETER, workingMode == null ? null : workingMode.name());
            return this;
        }

        public Builder withWifiScanInterval(int wifiScanInterval) {
            this.builder.addParameter(ConfigData.WIFI_SCAN_INTERVAL_PARAMETER, wifiScanInterval);
            return this;
        }

        public Builder withDataSendInterval(int dataSendInterval) {
            this.builder.addParameter(ConfigData.DATA_SEND_INTERVAL_PARAMETER, dataSendInterval);
            return this;
        }

        public Builder withBleScanInterval(int bleScanInterval) {
            this.builder.addParameter(ConfigData.BLE_SCAN_INTERVAL_PARAMETER, bleScanInterval);
            return this;
        }

        public Builder withBleScanDuration(int bleScanDuration) {
            this.builder.addParameter(ConfigData.BLE_SCAN_DURATION_PARAMETER, bleScanDuration);
            return this;
        }

        public Builder withName(String name) {
            this.builder.addParameter(ConfigData.NAME_PARAMETER, name);
            return this;
        }

        public Builder withUrl(String url) {
            this.builder.addParameter("url", EddystoneUtils.toHexString((byte[])EddystoneUtils.serializeUrl((String)url)));
            return this;
        }

        public Builder withNamespace(String namespace) {
            this.builder.addParameter("namespace", namespace);
            return this;
        }

        public Builder withDeviceProfiles(Collection<DeviceProfile> deviceProfiles) {
            ArrayList<String> deviceProfilesList = new ArrayList<String>();
            for (DeviceProfile deviceProfile : deviceProfiles) {
                deviceProfilesList.add(deviceProfile.name());
            }
            this.builder.addParameter("profiles", deviceProfilesList);
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.builder.addParameter("instanceId", instanceId);
            return this;
        }

        public Builder withShufled(boolean shuffled) {
            this.builder.addParameter("shuffled", shuffled);
            return this;
        }

        public ConfigData build() {
            return new ConfigData(this.builder.build());
        }
    }
}

