/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.http.data;

import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.model.IAction;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import com.kontakt.sdk.android.http.data.AbstractEntityData;
import com.kontakt.sdk.android.http.data.EntityData;

public final class ActionData
extends AbstractEntityData {
    private static final String PROXIMITY_PARAMETER = "proximity";
    private static final String UNIQUE_ID_PARAMETER = "uniqueId";
    private static final String ACTION_TYPE_PARAMETER = "actionType";
    private static final String URL_PARAMETER = "url";

    public static ActionData createContentAction(Proximity proximity, String deviceUniqueId) {
        SDKPreconditions.checkNotNull((Object)proximity, (Object)"Proximity is null");
        SDKPreconditions.checkNotNullOrEmpty((String)deviceUniqueId, (String)"Device Unique Id is null or empty.");
        return new ActionData(new EntityData.Builder().addParameter(PROXIMITY_PARAMETER, proximity.name()).addParameter(UNIQUE_ID_PARAMETER, deviceUniqueId).addParameter(ACTION_TYPE_PARAMETER, IAction.ActionType.CONTENT.name()).build());
    }

    public static ActionData createBrowserAction(Proximity proximity, String deviceUniqueId, String url) {
        SDKPreconditions.checkNotNull((Object)proximity);
        SDKPreconditions.checkNotNullOrEmpty((String)deviceUniqueId, (String)"Device Unique Id is null");
        SDKPreconditions.checkNotNullOrEmpty((String)url, (String)"Url is empty");
        return new ActionData(new EntityData.Builder().addParameter(PROXIMITY_PARAMETER, proximity.name()).addParameter(UNIQUE_ID_PARAMETER, deviceUniqueId).addParameter(URL_PARAMETER, url).addParameter(ACTION_TYPE_PARAMETER, IAction.ActionType.BROWSER.name()).build());
    }

    private ActionData(EntityData entityData) {
        super(entityData);
    }
}

